/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.openai;

import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpClient;
import com.azure.core.implementation.AccessTokenCache;
import com.azure.core.util.HttpClientOptions;
import com.azure.identity.AuthorizationCodeCredentialBuilder;
import com.azure.identity.EnvironmentCredential;
import com.azure.identity.EnvironmentCredentialBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.positron.api.connector.AIConnectionException;
import com.oxygenxml.positron.api.connector.dto.ModerationRequest;
import com.oxygenxml.positron.api.connector.dto.Pair;
import com.oxygenxml.positron.api.connector.dto.SpeechToTextRequest;
import com.oxygenxml.positron.connector.SystemEnvUtil;
import com.oxygenxml.positron.connector.api.HttpClientExtraConfigProvider;
import com.oxygenxml.positron.connector.auth.OAuthCodeFlowHelper;
import com.oxygenxml.positron.connector.openai.OAuthAccessTokenCache;
import com.oxygenxml.positron.connector.openai.OpenAIService;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class MSOpenAIService
extends OpenAIService {
    static final String API_VERSION = "2024-12-01-preview";
    public static final String AZURE_OAUTH_CLIENT_ID_ENV = "AZURE_OAUTH_CLIENT_ID";
    public static final String AZURE_OAUTH_TENANT_ID_ENV = "AZURE_OAUTH_TENANT_ID";
    public static final String AZURE_OAUTH_REDIRECT_URI_ENV = "AZURE_OAUTH_REDIRECT_URI";
    public static final String AZURE_AUTH_BASE_URL = "https://login.microsoftonline.com/";
    public static final String AZURE_OAUTH_COGNITIVE_SERVICES_SCOPE = "https://cognitiveservices.azure.com/.default";
    private static final String AUTHORIZATION_BEARER_VALUE_PATTERN = "Bearer {0}";
    private AccessTokenCache accessTokenCacheForEnvironmentCredentials;
    private OAuthAccessTokenCache oauthAccessTokenCache;
    private HttpClientExtraConfigProvider httpClientExtraConfigProvider;
    private String speechToTextRegion;
    private String speechToTextSubscriptionKey;
    private OAuthCodeFlowHelper oauthCodeFlowHelper;
    public static final String SPEECH_REGION_ENV = "SPEECH_REGION";
    public static final String SPEECH_KEY_ENV = "SPEECH_KEY";
    public static final String SPEECH_IMPOSED_BASE_URL_ENV = "SPEECH_IMPOSED_BASE_URL";
    public static final String SPEECH_LANGUAGE_ENV = "SPEECH_LANGUAGE";

    public MSOpenAIService(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String baseUrl, String apiKey, List<Pair<String, String>> extraHeaders, String speechToTextRegion, String speechToTextSubscriptionKey, OAuthCodeFlowHelper oauthCodeFlowHelper) {
        super(httpClientExtraConfigProvider, baseUrl, apiKey, null, extraHeaders, false, false);
        this.httpClientExtraConfigProvider = httpClientExtraConfigProvider;
        this.oauthCodeFlowHelper = oauthCodeFlowHelper;
        if (speechToTextRegion != null && !speechToTextRegion.isEmpty()) {
            this.speechToTextRegion = speechToTextRegion;
        }
        if (speechToTextSubscriptionKey != null && !speechToTextSubscriptionKey.isEmpty()) {
            this.speechToTextSubscriptionKey = speechToTextSubscriptionKey;
        }
    }

    @Override
    public boolean applyModeration(ModerationRequest moderationRequest) throws AIConnectionException {
        return false;
    }

    @Override
    protected OkHttpClient createServiceHttpClient(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String baseUrl, String token) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("api-version", API_VERSION);
        return this.createHttpClient(httpClientExtraConfigProvider, baseUrl, () -> this.computeHeaders(httpClientExtraConfigProvider, token), queryParams);
    }

    private Map<String, String> computeHeaders(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String token) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (token != null && !token.isBlank()) {
            headers.put("api-key", token);
        } else {
            headers.put("Authorization", this.getBearerAccessToken(httpClientExtraConfigProvider));
        }
        return headers;
    }

    String getBearerAccessToken(HttpClientExtraConfigProvider httpClientExtraConfigProvider) throws IOException {
        boolean isOAuthCodeFlowConfigured;
        String clientId = SystemEnvUtil.getenv(AZURE_OAUTH_CLIENT_ID_ENV);
        String tenantId = SystemEnvUtil.getenv(AZURE_OAUTH_TENANT_ID_ENV);
        String redirectUri = SystemEnvUtil.getenv(AZURE_OAUTH_REDIRECT_URI_ENV);
        boolean bl = isOAuthCodeFlowConfigured = this.oauthCodeFlowHelper != null && clientId != null && !clientId.isEmpty() && tenantId != null && !tenantId.isEmpty() && redirectUri != null && !redirectUri.isEmpty();
        if (isOAuthCodeFlowConfigured) {
            return this.getBearerAccessTokenForOAuthCodeFlow(httpClientExtraConfigProvider, clientId, tenantId, redirectUri);
        }
        return this.getBearerAccessTokenForEnvironmentCredentials(httpClientExtraConfigProvider);
    }

    private String getBearerAccessTokenForOAuthCodeFlow(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String clientId, String tenantId, String redirectUri) throws IOException {
        if (this.oauthAccessTokenCache == null) {
            this.oauthAccessTokenCache = new OAuthAccessTokenCache("azure_openai", () -> {
                TokenCredential credential = this.createTokenCredentialForAuthCodeFlow(httpClientExtraConfigProvider, clientId, tenantId, redirectUri);
                TokenRequestContext requestContext = new TokenRequestContext();
                requestContext.addScopes(new String[]{AZURE_OAUTH_COGNITIVE_SERVICES_SCOPE});
                return credential.getTokenSync(requestContext);
            }, this.oauthCodeFlowHelper);
        }
        return MessageFormat.format(AUTHORIZATION_BEARER_VALUE_PATTERN, this.oauthAccessTokenCache.getTokenSync());
    }

    private String getBearerAccessTokenForEnvironmentCredentials(HttpClientExtraConfigProvider httpClientExtraConfigProvider) throws IOException {
        try {
            if (this.accessTokenCacheForEnvironmentCredentials == null) {
                EnvironmentCredential credential = ((EnvironmentCredentialBuilder)new EnvironmentCredentialBuilder().httpClient(HttpClient.createDefault((HttpClientOptions)httpClientExtraConfigProvider.configureHttpClientAccordingToPreferences(new HttpClientOptions(), AZURE_AUTH_BASE_URL)))).executorService(Executors.newFixedThreadPool(1)).build();
                this.accessTokenCacheForEnvironmentCredentials = new AccessTokenCache((TokenCredential)credential);
            }
            TokenRequestContext requestContext = new TokenRequestContext();
            requestContext.addScopes(new String[]{AZURE_OAUTH_COGNITIVE_SERVICES_SCOPE});
            String token = this.accessTokenCacheForEnvironmentCredentials.getTokenSync(requestContext, false).getToken();
            return MessageFormat.format(AUTHORIZATION_BEARER_VALUE_PATTERN, token);
        }
        catch (RuntimeException ex) {
            String message = ex.getMessage();
            for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
                message = cause.getMessage();
            }
            throw new IOException(message, new AIConnectionException(message, null, (Exception)ex));
        }
    }

    private TokenCredential createTokenCredentialForAuthCodeFlow(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String clientId, String tenantId, String redirectUri) throws IOException {
        try {
            String authorizationUrl = MSOpenAIService.buildAzureAuthorizationUrl(clientId, tenantId, redirectUri);
            CompletableFuture<String> authCodeFuture = this.oauthCodeFlowHelper.startAuthorization(Translator.getInstance().getTranslation("MS_Azure_Authentication_Required"), Translator.getInstance().getTranslation("MS_Azure_Authentication_Description"), authorizationUrl, redirectUri);
            String authorizationCode = authCodeFuture.get();
            if (authorizationCode == null || authorizationCode.isBlank()) {
                throw new IOException("Authorization canceled by user");
            }
            return this.createAuthorizationCodeCredential(httpClientExtraConfigProvider, clientId, tenantId, redirectUri, authorizationCode);
        }
        catch (Exception e) {
            throw new IOException("OAuth authorization failed: " + e.getMessage(), e);
        }
    }

    TokenCredential createAuthorizationCodeCredential(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String clientId, String tenantId, String redirectUri, String authorizationCode) {
        return ((AuthorizationCodeCredentialBuilder)((AuthorizationCodeCredentialBuilder)((AuthorizationCodeCredentialBuilder)((AuthorizationCodeCredentialBuilder)new AuthorizationCodeCredentialBuilder().clientId(clientId)).tenantId(tenantId)).authorizationCode(authorizationCode).redirectUrl(redirectUri).httpClient(HttpClient.createDefault((HttpClientOptions)httpClientExtraConfigProvider.configureHttpClientAccordingToPreferences(new HttpClientOptions(), AZURE_AUTH_BASE_URL)))).executorService(Executors.newFixedThreadPool(1))).build();
    }

    private static String buildAzureAuthorizationUrl(String clientId, String tenantId, String redirectUri) {
        try {
            String baseUrl = AZURE_AUTH_BASE_URL + tenantId + "/oauth2/v2.0/authorize";
            StringBuilder urlBuilder = new StringBuilder(baseUrl);
            urlBuilder.append("?client_id=").append(clientId);
            urlBuilder.append("&response_type=code");
            urlBuilder.append("&redirect_uri=").append(URLEncoder.encode(redirectUri, "UTF-8"));
            urlBuilder.append("&scope=").append(URLEncoder.encode(AZURE_OAUTH_COGNITIVE_SERVICES_SCOPE, "UTF-8"));
            urlBuilder.append("&response_mode=query");
            return urlBuilder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build Azure authorization URL", e);
        }
    }

    @VisibleForTesting
    void setAccessTokenCache(AccessTokenCache accessTokenCache) {
        this.accessTokenCacheForEnvironmentCredentials = accessTokenCache;
    }

    @Override
    public boolean isEnabledSpeechToText() {
        return !(this.speechToTextRegion == null && SystemEnvUtil.getenv(SPEECH_REGION_ENV) == null || this.speechToTextSubscriptionKey == null && SystemEnvUtil.getenv(SPEECH_KEY_ENV) == null);
    }

    @Override
    public String convertSpeechToText(SpeechToTextRequest speechRequest) throws AIConnectionException {
        String string;
        block11: {
            String region = this.speechToTextRegion != null ? this.speechToTextRegion : SystemEnvUtil.getenv(SPEECH_REGION_ENV);
            Object base = SystemEnvUtil.getenv(SPEECH_IMPOSED_BASE_URL_ENV);
            if (base == null) {
                base = "https://" + region + ".stt.speech.microsoft.com/speech/recognition/conversation/cognitiveservices/v1";
            }
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            String language = SystemEnvUtil.getenv(SPEECH_LANGUAGE_ENV);
            if (language == null) {
                language = speechRequest.getLanguage();
            }
            params.put("language", language);
            params.put("format", "simple");
            OkHttpClient client = this.createHttpClient(this.httpClientExtraConfigProvider, (String)base, () -> new LinkedHashMap(), params);
            Headers headers = new Headers.Builder().add("Ocp-Apim-Subscription-Key", this.speechToTextSubscriptionKey != null ? this.speechToTextSubscriptionKey : SystemEnvUtil.getenv(SPEECH_KEY_ENV)).add("Content-Type", speechRequest.getMimeType()).build();
            RequestBody requestBody = RequestBody.create((byte[])speechRequest.getInput(), (MediaType)MediaType.parse((String)speechRequest.getMimeType()));
            Request request = new Request.Builder().url((String)base).headers(headers).post(requestBody).build();
            Response response = client.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new IOException("Unexpected code " + response);
                }
                String jsonResponse = response.body().string();
                Map responseMap = (Map)AIRequestUtil.defaultObjectMapper().readValue(jsonResponse, Map.class);
                string = (String)responseMap.get("DisplayText");
                if (response == null) break block11;
            }
            catch (Throwable jsonResponse) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable) {
                            jsonResponse.addSuppressed(throwable);
                        }
                    }
                    throw jsonResponse;
                }
                catch (IOException e) {
                    AIConnectionException ex = new AIConnectionException(e.getMessage());
                    ex.initCause((Throwable)e);
                    throw ex;
                }
            }
            response.close();
        }
        return string;
    }
}

