/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.api.claude;

import com.oxygenxml.positron.api.connector.AIConnectionException;
import com.oxygenxml.positron.api.connector.AIService;
import com.oxygenxml.positron.api.connector.dto.CompletionChunk;
import com.oxygenxml.positron.api.connector.dto.CompletionRequest;
import com.oxygenxml.positron.api.connector.dto.CompletionResponse;
import com.oxygenxml.positron.api.connector.dto.ModerationRequest;
import com.oxygenxml.positron.api.connector.dto.Pair;
import com.oxygenxml.positron.connector.api.HttpClientExtraConfigProvider;
import com.oxygenxml.positron.connector.api.claude.ClaudeAPIProvider;
import com.oxygenxml.positron.connector.openai.HeadersQueryInterceptor;
import com.oxygenxml.positron.connector.openai.RequestLoggingInterceptor;
import com.oxygenxml.positron.connector.util.AIServiceUtil;
import com.oxygenxml.positron.connector.util.ReactiveUtil;
import com.oxygenxml.positron.utilities.claude.ClaudeRequestResponseMapper;
import com.oxygenxml.positron.utilities.claude.dto.ClaudeCompletionRequest;
import com.oxygenxml.positron.utilities.claude.dto.ClaudeCompletionResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClaudeService
implements AIService {
    private static final Logger log = LoggerFactory.getLogger(ClaudeService.class);
    private static final String API_KEY_HEADER = "x-api-key";
    static final String VERSION_API_HEADER_KEY = "anthropic-version";
    private static final String ANTHROPIC_VERSION = "2023-06-01";
    private List<Pair<String, String>> extraHeaders;
    protected ClaudeAPIProvider apiProvider;

    public ClaudeService(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String baseUrl, String apiKey, List<Pair<String, String>> extraHeaders) {
        this.extraHeaders = extraHeaders;
        this.apiProvider = new ClaudeAPIProvider(httpClientExtraConfigProvider, baseUrl, apiKey){

            @Override
            public OkHttpClient createHttpClient(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String baseUrl, String token) {
                return ClaudeService.this.createHttpClient(httpClientExtraConfigProvider, baseUrl, token);
            }
        };
    }

    public Flow.Publisher<CompletionChunk> getCompletionFlux(CompletionRequest completionRequest) {
        ClaudeCompletionRequest claudeRequest = ClaudeRequestResponseMapper.mapToClaudeRequest((CompletionRequest)completionRequest);
        Flow.Publisher<ClaudeCompletionResponse> chunkedFlow = ReactiveUtil.streamFlow(this.apiProvider.getOpenAIApi().createChatCompletionStream(claudeRequest), ClaudeCompletionResponse.class);
        return ReactiveUtil.map(chunkedFlow, ClaudeRequestResponseMapper::translateClaudeChunkToCommonChunk);
    }

    public CompletionResponse getCompletion(CompletionRequest completionRequest) throws AIConnectionException {
        ClaudeCompletionRequest claudeRequest = ClaudeRequestResponseMapper.mapToClaudeRequest((CompletionRequest)completionRequest);
        ClaudeCompletionResponse resp = ReactiveUtil.execute(this.apiProvider.getOpenAIApi().createChatCompletion(claudeRequest));
        return ClaudeRequestResponseMapper.translateClaudeChunkToCommonChunk((ClaudeCompletionResponse)resp);
    }

    public boolean isRequiringApplyingModeration() {
        return false;
    }

    public boolean applyModeration(ModerationRequest moderationRequest) throws AIConnectionException {
        return false;
    }

    protected OkHttpClient createHttpClient(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String baseUrl, String token) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (token != null && !token.isBlank()) {
            headers.put(API_KEY_HEADER, token);
        }
        headers.put(VERSION_API_HEADER_KEY, ANTHROPIC_VERSION);
        return this.createHttpClient(httpClientExtraConfigProvider, baseUrl, headers, null);
    }

    protected OkHttpClient createHttpClient(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String baseUrl, Map<String, String> headers, Map<String, String> queryParams) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder = httpClientExtraConfigProvider.configureHttpClientAccordingToPreferences(builder, baseUrl);
        if (this.extraHeaders != null) {
            for (Pair<String, String> pair : this.extraHeaders) {
                headers.put((String)pair.getFirst(), (String)pair.getSecond());
            }
        }
        builder = builder.addInterceptor((Interceptor)new HeadersQueryInterceptor(() -> headers, queryParams));
        if (log.isDebugEnabled()) {
            builder = builder.addInterceptor((Interceptor)new RequestLoggingInterceptor(log));
        }
        return builder.connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS)).readTimeout((long)AIServiceUtil.getAIClientReadTimeout(), TimeUnit.MILLISECONDS).build();
    }

    void setApiProviderForTc(ClaudeAPIProvider apiProvider) {
        this.apiProvider = apiProvider;
    }
}

