/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.api.bedrock;

import com.oxygenxml.positron.api.connector.dto.AssistantMessage;
import com.oxygenxml.positron.api.connector.dto.ChatFunctionDTO;
import com.oxygenxml.positron.api.connector.dto.CompletionChoice;
import com.oxygenxml.positron.api.connector.dto.CompletionChunk;
import com.oxygenxml.positron.api.connector.dto.CompletionFunctionCall;
import com.oxygenxml.positron.api.connector.dto.CompletionMessage;
import com.oxygenxml.positron.api.connector.dto.CompletionRequest;
import com.oxygenxml.positron.api.connector.dto.CompletionResponse;
import com.oxygenxml.positron.api.connector.dto.CompletionToolCall;
import com.oxygenxml.positron.api.connector.dto.ImageUrl;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageContent;
import com.oxygenxml.positron.api.connector.dto.MessageContentType;
import com.oxygenxml.positron.api.connector.dto.MessageImageUrlContent;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.api.connector.dto.TokensUsageInfo;
import com.oxygenxml.positron.api.connector.dto.Tool;
import com.oxygenxml.positron.api.connector.dto.ToolCallResponseMessage;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockContentBlock;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockContentBlockDelta;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockContentBlockDeltaEvent;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockContentBlockStartEvent;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockConverseRequest;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockConverseResponse;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockConverseStreamResponse;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockImageBlock;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockImageSource;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockInferenceConfig;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockMessage;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockMessageStopEvent;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockMetadataEvent;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockSystemMessage;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockTool;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockToolConfig;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockToolInputSchema;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockToolResultBlock;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockToolSpec;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockToolUseBlock;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockToolUseDelta;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import com.oxygenxml.positron.utilities.claude.dto.EmptyClass;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BedrockRequestResponseMapper {
    private static final Logger log = LoggerFactory.getLogger(BedrockRequestResponseMapper.class);
    private static final String DEFAULT_USER_MESSAGE_TEXT = "Please help me with this task.";

    private BedrockRequestResponseMapper() {
    }

    public static BedrockConverseRequest mapToBedrockRequest(CompletionRequest completionRequest) {
        BedrockConverseRequest bedrockRequest = new BedrockConverseRequest();
        bedrockRequest.setModelId(completionRequest.getModel());
        BedrockMessagesWithSystemPrompt messagesResult = BedrockRequestResponseMapper.convertMessages(completionRequest.getMessages());
        bedrockRequest.setMessages(messagesResult.messages);
        bedrockRequest.setSystem(messagesResult.systemMessages);
        BedrockInferenceConfig inferenceConfig = new BedrockInferenceConfig();
        if (completionRequest.getMaxTokens() != null) {
            inferenceConfig.setMaxTokens(completionRequest.getMaxTokens());
        }
        inferenceConfig.setTemperature(completionRequest.getTemperature() != null ? Double.valueOf(completionRequest.getTemperature().doubleValue()) : null);
        inferenceConfig.setStopSequences(completionRequest.getStop());
        bedrockRequest.setInferenceConfig(inferenceConfig);
        if (completionRequest.getTools() != null && !completionRequest.getTools().isEmpty()) {
            BedrockToolConfig toolConfig = new BedrockToolConfig();
            toolConfig.setTools(BedrockRequestResponseMapper.convertTools(completionRequest.getTools()));
            bedrockRequest.setToolConfig(toolConfig);
        }
        return bedrockRequest;
    }

    private static BedrockMessagesWithSystemPrompt convertMessages(List<Message> messages) {
        ArrayList<BedrockMessage> bedrockMessages = new ArrayList<BedrockMessage>();
        ArrayList<BedrockSystemMessage> systemMessages = new ArrayList<BedrockSystemMessage>();
        if (messages != null) {
            ArrayList<ToolCallResponseMessage> consecutiveToolResponses = new ArrayList<ToolCallResponseMessage>();
            for (int i = 0; i < messages.size(); ++i) {
                AssistantMessage assistantMessage;
                Message message = messages.get(i);
                if (message.getRole() == RoleType.SYSTEM) {
                    if (!consecutiveToolResponses.isEmpty()) {
                        bedrockMessages.add(BedrockRequestResponseMapper.groupToolResponsesIntoSingleMessage(consecutiveToolResponses));
                        consecutiveToolResponses.clear();
                    }
                    BedrockSystemMessage systemMessage = new BedrockSystemMessage();
                    systemMessage.setText(BedrockRequestResponseMapper.extractTextFromMessage(message));
                    systemMessages.add(systemMessage);
                    continue;
                }
                if (message.getRole() == RoleType.TOOL) {
                    consecutiveToolResponses.add((ToolCallResponseMessage)message);
                    continue;
                }
                if (!consecutiveToolResponses.isEmpty()) {
                    bedrockMessages.add(BedrockRequestResponseMapper.groupToolResponsesIntoSingleMessage(consecutiveToolResponses));
                    consecutiveToolResponses.clear();
                }
                BedrockMessage bedrockMessage = new BedrockMessage();
                bedrockMessage.setRole(BedrockRequestResponseMapper.convertRole(message.getRole()));
                List<BedrockContentBlock> content = BedrockRequestResponseMapper.convertMessageContent(message.getContent());
                if (message instanceof AssistantMessage && (assistantMessage = (AssistantMessage)message).getToolCalls() != null && !assistantMessage.getToolCalls().isEmpty()) {
                    List<BedrockContentBlock> toolCallBlocks = BedrockRequestResponseMapper.convertToolCallsToContent(assistantMessage.getToolCalls());
                    content.addAll(toolCallBlocks);
                }
                if (content.isEmpty()) continue;
                bedrockMessage.setContent(content);
                bedrockMessages.add(bedrockMessage);
            }
            if (!consecutiveToolResponses.isEmpty()) {
                bedrockMessages.add(BedrockRequestResponseMapper.groupToolResponsesIntoSingleMessage(consecutiveToolResponses));
            }
        }
        BedrockRequestResponseMapper.ensureFirstMessageIsUserType(bedrockMessages);
        return new BedrockMessagesWithSystemPrompt(bedrockMessages, systemMessages);
    }

    private static BedrockMessage groupToolResponsesIntoSingleMessage(List<ToolCallResponseMessage> toolResponses) {
        BedrockMessage bedrockMessage = new BedrockMessage();
        bedrockMessage.setRole("user");
        ArrayList<BedrockContentBlock> allToolResults = new ArrayList<BedrockContentBlock>();
        for (ToolCallResponseMessage toolResponse : toolResponses) {
            allToolResults.addAll(BedrockRequestResponseMapper.convertToolResponseToContent(toolResponse));
        }
        bedrockMessage.setContent(allToolResults);
        return bedrockMessage;
    }

    private static void ensureFirstMessageIsUserType(List<BedrockMessage> bedrockMessages) {
        if (bedrockMessages.isEmpty() || bedrockMessages.get(0).getRole() == "assistant") {
            BedrockMessage bedrockMessage = new BedrockMessage();
            bedrockMessage.setRole("user");
            ArrayList<BedrockContentBlock> defaultContentList = new ArrayList<BedrockContentBlock>();
            BedrockContentBlock defaultContent = new BedrockContentBlock();
            defaultContent.setText(DEFAULT_USER_MESSAGE_TEXT);
            defaultContentList.add(defaultContent);
            bedrockMessage.setContent(defaultContentList);
            bedrockMessages.add(0, bedrockMessage);
        }
    }

    private static List<BedrockTool> convertTools(List<Tool> tools) {
        ArrayList<BedrockTool> bedrockTools = new ArrayList<BedrockTool>();
        if (tools != null) {
            for (Tool tool : tools) {
                if (tool.getFunction() == null) continue;
                BedrockTool bedrockTool = new BedrockTool();
                BedrockToolSpec toolSpec = new BedrockToolSpec();
                ChatFunctionDTO function = tool.getFunction();
                toolSpec.setName(function.getName());
                toolSpec.setDescription(function.getDescription());
                if (function.getParametersObj() != null) {
                    BedrockToolInputSchema inputSchema = new BedrockToolInputSchema();
                    inputSchema.setJson(function.getParametersObj());
                    toolSpec.setInputSchema(inputSchema);
                }
                bedrockTool.setToolSpec(toolSpec);
                bedrockTools.add(bedrockTool);
            }
        }
        return bedrockTools;
    }

    private static String convertRole(RoleType role) {
        switch (role) {
            case USER: {
                return "user";
            }
            case ASSISTANT: {
                return "assistant";
            }
            case SYSTEM: {
                return "user";
            }
        }
        return "user";
    }

    private static List<BedrockContentBlock> convertMessageContent(List<MessageContent> content) {
        ArrayList<BedrockContentBlock> bedrockContent = new ArrayList<BedrockContentBlock>();
        if (content != null) {
            for (MessageContent messageContent : content) {
                MessageImageUrlContent imageContent;
                BedrockImageBlock imageBlock;
                BedrockContentBlock contentBlock = new BedrockContentBlock();
                if (messageContent.getType() == MessageContentType.TEXT) {
                    MessageTextContent textContent = (MessageTextContent)messageContent;
                    if (textContent.getText().isEmpty()) continue;
                    contentBlock.setText(textContent.getText());
                    bedrockContent.add(contentBlock);
                    continue;
                }
                if (messageContent.getType() != MessageContentType.IMAGE_URL || (imageBlock = BedrockRequestResponseMapper.convertImageContent(imageContent = (MessageImageUrlContent)messageContent)) == null) continue;
                contentBlock.setImage(imageBlock);
                bedrockContent.add(contentBlock);
            }
        }
        return bedrockContent;
    }

    private static BedrockImageBlock convertImageContent(MessageImageUrlContent imageContent) {
        if (imageContent == null || imageContent.getImageUrl() == null) {
            return null;
        }
        ImageUrl imageUrl = imageContent.getImageUrl();
        String url = imageUrl.getUrl();
        if (url == null || url.trim().isEmpty()) {
            log.warn("Image URL is null or empty");
            return null;
        }
        if (url.startsWith("data:")) {
            return BedrockRequestResponseMapper.convertDataUrlToImageBlock(url);
        }
        log.warn("Regular image URLs are not supported by Bedrock. Only data URLs (base64) are supported. URL: {}", (Object)url);
        return null;
    }

    private static BedrockImageBlock convertDataUrlToImageBlock(String dataUrl) {
        try {
            if (!dataUrl.startsWith("data:")) {
                log.warn("Invalid data URL format: {}", (Object)dataUrl);
                return null;
            }
            int commaIndex = dataUrl.indexOf(44);
            if (commaIndex == -1) {
                log.warn("Invalid data URL format - no comma found: {}", (Object)dataUrl);
                return null;
            }
            String header = dataUrl.substring(5, commaIndex);
            String base64Data = dataUrl.substring(commaIndex + 1);
            String mediaType = "image/png";
            if (header.contains("/")) {
                mediaType = header.split(";")[0];
            }
            String format = "png";
            if (mediaType.contains("/")) {
                format = mediaType.split("/")[1];
            }
            if (!BedrockRequestResponseMapper.isValidImageFormat(format)) {
                log.warn("Unsupported image format: {}. Supported formats are: png, jpeg, gif, webp", (Object)format);
                format = "png";
            }
            byte[] imageBytes = Base64.getDecoder().decode(base64Data);
            BedrockImageBlock imageBlock = new BedrockImageBlock();
            imageBlock.setFormat(format);
            BedrockImageSource imageSource = new BedrockImageSource();
            imageSource.setBytes(imageBytes);
            imageBlock.setSource(imageSource);
            log.debug("Successfully converted data URL to image block. Format: {}, Size: {} bytes", (Object)format, (Object)imageBytes.length);
            return imageBlock;
        }
        catch (Exception e) {
            log.error("Failed to convert data URL to image block: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private static boolean isValidImageFormat(String format) {
        if (format == null) {
            return false;
        }
        String lowerFormat = format.toLowerCase();
        return lowerFormat.equals("png") || lowerFormat.equals("jpeg") || lowerFormat.equals("jpg") || lowerFormat.equals("gif") || lowerFormat.equals("webp");
    }

    private static String extractTextFromMessage(Message message) {
        StringBuilder text = new StringBuilder();
        if (message.getContent() != null) {
            for (MessageContent content : message.getContent()) {
                if (content.getType() != MessageContentType.TEXT) continue;
                MessageTextContent textContent = (MessageTextContent)content;
                if (text.length() > 0) {
                    text.append("\n");
                }
                text.append(textContent.getText());
            }
        }
        return text.toString();
    }

    private static List<BedrockContentBlock> convertToolCallsToContent(List<CompletionToolCall> toolCalls) {
        ArrayList<BedrockContentBlock> contentBlocks = new ArrayList<BedrockContentBlock>();
        if (toolCalls != null) {
            for (CompletionToolCall toolCall : toolCalls) {
                if (toolCall.getFunction() == null) continue;
                BedrockContentBlock contentBlock = new BedrockContentBlock();
                BedrockToolUseBlock toolUse = new BedrockToolUseBlock();
                toolUse.setToolUseId(toolCall.getId());
                toolUse.setName(toolCall.getFunction().getName());
                Object inputObject = BedrockRequestResponseMapper.parseJsonArguments(toolCall.getFunction().getArguments());
                toolUse.setInput(inputObject);
                contentBlock.setToolUse(toolUse);
                contentBlocks.add(contentBlock);
            }
        }
        return contentBlocks;
    }

    private static List<BedrockContentBlock> convertToolResponseToContent(ToolCallResponseMessage toolMessage) {
        ArrayList<BedrockContentBlock> contentBlocks = new ArrayList<BedrockContentBlock>();
        BedrockContentBlock contentBlock = new BedrockContentBlock();
        BedrockToolResultBlock toolResult = new BedrockToolResultBlock();
        toolResult.setToolUseId(toolMessage.getToolCallId());
        ArrayList<BedrockContentBlock> toolResultContent = new ArrayList<BedrockContentBlock>();
        if (toolMessage.getContent() != null && !toolMessage.getContent().isEmpty()) {
            for (MessageContent content : toolMessage.getContent()) {
                if (content.getType() != MessageContentType.TEXT) continue;
                MessageTextContent textContent = (MessageTextContent)content;
                BedrockContentBlock resultBlock = new BedrockContentBlock();
                resultBlock.setText(textContent.getText());
                toolResultContent.add(resultBlock);
            }
        }
        toolResult.setContent(toolResultContent);
        contentBlock.setToolResult(toolResult);
        contentBlocks.add(contentBlock);
        return contentBlocks;
    }

    private static Object parseJsonArguments(String argumentsJson) {
        if (argumentsJson != null && !argumentsJson.trim().isEmpty()) {
            try {
                return AIRequestUtil.defaultObjectMapper().readValue(argumentsJson, Object.class);
            }
            catch (Exception e) {
                log.warn("Failed to parse tool call arguments JSON: {}", (Object)e.getMessage());
            }
        }
        return new EmptyClass();
    }

    public static CompletionResponse translateBedrockResponseToCommonResponse(BedrockConverseResponse response) {
        BedrockMessage bedrockMessage;
        CompletionResponse commonResponse = new CompletionResponse();
        CompletionChoice choice = new CompletionChoice();
        choice.setIndex(0);
        choice.setFinishReason(BedrockRequestResponseMapper.mapStopReason(response.getStopReason()));
        CompletionMessage message = new CompletionMessage();
        if (response.getOutput() != null && response.getOutput().getMessage() != null && (bedrockMessage = response.getOutput().getMessage()).getContent() != null && !bedrockMessage.getContent().isEmpty()) {
            StringBuilder content = new StringBuilder();
            ArrayList<CompletionToolCall> toolCalls = new ArrayList<CompletionToolCall>();
            for (int i = 0; i < bedrockMessage.getContent().size(); ++i) {
                BedrockContentBlock contentBlock = bedrockMessage.getContent().get(i);
                if (contentBlock.getText() != null) {
                    content.append(contentBlock.getText());
                }
                if (contentBlock.getToolUse() == null) continue;
                CompletionToolCall toolCall = BedrockRequestResponseMapper.mapBedrockToolUseToCompletionToolCall(contentBlock.getToolUse(), i);
                toolCalls.add(toolCall);
            }
            message.setContent(content.toString());
            if (!toolCalls.isEmpty()) {
                message.setToolCalls(toolCalls);
            }
        }
        choice.setMessage(message);
        commonResponse.setChoices(List.of(choice));
        if (response.getUsage() != null) {
            TokensUsageInfo usage = new TokensUsageInfo();
            usage.setPromptTokens(response.getUsage().getInputTokens().intValue());
            usage.setCompletionTokens(response.getUsage().getOutputTokens().intValue());
            usage.setTotalTokens(response.getUsage().getTotalTokens().intValue());
            commonResponse.setUsage(usage);
        }
        return commonResponse;
    }

    public static CompletionChunk translateBedrockChunkToCommonChunk(BedrockConverseStreamResponse streamResponse) {
        BedrockMetadataEvent metadata;
        CompletionChoice choice;
        CompletionChunk chunk = new CompletionChunk();
        if (streamResponse.getContentBlockStart() != null) {
            BedrockContentBlockStartEvent startEvent = streamResponse.getContentBlockStart();
            choice = new CompletionChoice();
            choice.setIndex(0);
            CompletionMessage message = new CompletionMessage();
            if (startEvent.getStart() != null && startEvent.getStart().getToolUse() != null) {
                CompletionToolCall toolCall = BedrockRequestResponseMapper.mapBedrockToolUseToCompletionToolCall(startEvent.getStart().getToolUse(), startEvent.getContentBlockIndex());
                message.setToolCalls(List.of(toolCall));
            }
            choice.setDelta(message);
            chunk.setChoices(List.of(choice));
        }
        if (streamResponse.getContentBlockDelta() != null) {
            BedrockContentBlockDeltaEvent deltaEvent = streamResponse.getContentBlockDelta();
            BedrockContentBlockDelta delta = deltaEvent.getDelta();
            CompletionChoice choice2 = new CompletionChoice();
            choice2.setIndex(0);
            CompletionMessage message = new CompletionMessage();
            if (delta != null && delta.getText() != null) {
                message.setContent(delta.getText());
            }
            if (delta != null && delta.getToolUse() != null) {
                CompletionToolCall toolCall = BedrockRequestResponseMapper.mapBedrockToolUseDeltaToCompletionToolCall(delta.getToolUse(), deltaEvent.getContentBlockIndex());
                message.setToolCalls(List.of(toolCall));
            }
            choice2.setDelta(message);
            chunk.setChoices(List.of(choice2));
        }
        if (streamResponse.getMessageStop() != null) {
            BedrockMessageStopEvent stopEvent = streamResponse.getMessageStop();
            choice = new CompletionChoice();
            choice.setIndex(0);
            choice.setFinishReason(BedrockRequestResponseMapper.mapStopReason(stopEvent.getStopReason()));
            chunk.setChoices(List.of(choice));
        }
        if (streamResponse.getMetadata() != null && (metadata = streamResponse.getMetadata()).getUsage() != null) {
            TokensUsageInfo usage = new TokensUsageInfo();
            usage.setPromptTokens(metadata.getUsage().getInputTokens().intValue());
            usage.setCompletionTokens(metadata.getUsage().getOutputTokens().intValue());
            usage.setTotalTokens(metadata.getUsage().getTotalTokens().intValue());
            chunk.setUsage(usage);
        }
        return chunk;
    }

    private static String mapStopReason(String stopReason) {
        if (stopReason == null) {
            return null;
        }
        switch (stopReason) {
            case "end_turn": {
                return "stop";
            }
            case "max_tokens": {
                return "length";
            }
            case "stop_sequence": {
                return "stop";
            }
            case "tool_use": {
                return "tool_calls";
            }
            case "content_filtered": {
                return "content_filter";
            }
        }
        return stopReason;
    }

    private static CompletionToolCall mapBedrockToolUseToCompletionToolCall(BedrockToolUseBlock toolUse, Integer contentBlockIndex) {
        CompletionToolCall toolCall = new CompletionToolCall();
        toolCall.setId(toolUse.getToolUseId());
        toolCall.setType("function");
        toolCall.setIndex(contentBlockIndex);
        CompletionFunctionCall functionCall = new CompletionFunctionCall();
        functionCall.setName(toolUse.getName());
        if (toolUse.getInput() != null) {
            try {
                String argumentsJson = AIRequestUtil.defaultObjectMapper().writeValueAsString(toolUse.getInput());
                functionCall.setArguments(argumentsJson);
            }
            catch (Exception e) {
                log.warn("Failed to serialize tool input to JSON: {}", (Object)e.getMessage());
                functionCall.setArguments("");
            }
        } else {
            functionCall.setArguments("");
        }
        toolCall.setFunction(functionCall);
        return toolCall;
    }

    private static CompletionToolCall mapBedrockToolUseDeltaToCompletionToolCall(BedrockToolUseDelta toolUseDelta, Integer contentBlockIndex) {
        CompletionToolCall toolCall = new CompletionToolCall();
        toolCall.setType("function");
        toolCall.setIndex(contentBlockIndex);
        CompletionFunctionCall functionCall = new CompletionFunctionCall();
        if (toolUseDelta.getInput() != null && !toolUseDelta.getInput().equals("{}")) {
            functionCall.setArguments(toolUseDelta.getInput());
        } else {
            functionCall.setArguments("");
        }
        toolCall.setFunction(functionCall);
        return toolCall;
    }

    private static class BedrockMessagesWithSystemPrompt {
        final List<BedrockMessage> messages;
        final List<BedrockSystemMessage> systemMessages;

        BedrockMessagesWithSystemPrompt(List<BedrockMessage> messages, List<BedrockSystemMessage> systemMessages) {
            this.messages = messages;
            this.systemMessages = systemMessages;
        }
    }
}

