/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.api.bedrock;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.connector.api.HttpClientExtraConfigProvider;
import com.oxygenxml.positron.connector.api.bedrock.AWSBedrockApi;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava3.RxJava3CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public abstract class AWSBedrockAPIProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AWSBedrockAPIProvider.class.getName());
    private AWSBedrockApi api = null;
    private HttpClientExtraConfigProvider httpClientExtraConfigProvider;
    private String endpoint;
    private String apiKey;

    public AWSBedrockAPIProvider(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String endpoint, String apiKey) {
        this.httpClientExtraConfigProvider = httpClientExtraConfigProvider;
        this.endpoint = endpoint;
        this.apiKey = apiKey;
    }

    public AWSBedrockApi getBedrockApi() {
        if (this.api == null) {
            OkHttpClient httpClient = this.createHttpClient(this.httpClientExtraConfigProvider, this.endpoint, this.apiKey);
            ObjectMapper objectMapper = AIRequestUtil.defaultObjectMapper();
            Retrofit retrofit = new Retrofit.Builder().baseUrl(this.endpoint).client(httpClient).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper)).addCallAdapterFactory((CallAdapter.Factory)RxJava3CallAdapterFactory.create()).build();
            this.api = (AWSBedrockApi)retrofit.create(AWSBedrockApi.class);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("=== AWS Bedrock API Provider Debug ===");
                LOGGER.debug("Base URL: " + this.endpoint);
                LOGGER.debug("API Key (first 20 chars): " + (String)(this.apiKey != null ? this.apiKey.substring(0, Math.min(20, this.apiKey.length())) + "..." : "NULL"));
            }
        }
        return this.api;
    }

    public abstract OkHttpClient createHttpClient(HttpClientExtraConfigProvider var1, String var2, String var3);
}

