/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.api;

import com.oxygenxml.positron.api.connector.AIConnector;
import com.oxygenxml.positron.api.connector.dto.CompletionRequest;
import com.oxygenxml.positron.api.connector.dto.CompletionResponse;
import com.oxygenxml.positron.connector.api.HttpClientExtraConfigProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.utilities.AIRequestUtil;

public abstract class BuiltInAIConnector
extends AIConnector {
    protected static final Translator TRANSLATOR = Translator.getInstance();
    private HttpClientExtraConfigProvider httpClientExtraConfigProvider;
    private String lastOriginalRequestModel = null;

    public CompletionRequest configureCompletionRequest(CompletionRequest request) {
        request = super.configureCompletionRequest(request);
        if (this.getResolvedParameters().containsKey("streaming_param")) {
            boolean isStreamingAllowed = (Boolean)this.getResolvedParameters().get("streaming_param");
            if (request.getStream() != null && request.getStream().booleanValue() && !isStreamingAllowed) {
                request.setStream(Boolean.valueOf(false));
            }
        }
        request = this.configureCompletionRequestForBuiltInConnector(request);
        this.lastOriginalRequestModel = request.getModel();
        request = AIRequestUtil.processRequestTakingAccountOfReasoningModels((CompletionRequest)request, (String)request.getModel());
        request = AIRequestUtil.updateCompletionRequestTakingModelConfigurationIntoAccount((CompletionRequest)request);
        return request;
    }

    public void processCompletionResponse(CompletionResponse response) {
        String mappedModel = AIRequestUtil.mapResponseModelToConfiguredModel((String)response.getModel(), (String)this.lastOriginalRequestModel);
        response.setModel(mappedModel);
    }

    public abstract CompletionRequest configureCompletionRequestForBuiltInConnector(CompletionRequest var1);

    public HttpClientExtraConfigProvider getHttpClientExtraConfigProvider() {
        return this.httpClientExtraConfigProvider;
    }

    public String getLastOriginalRequestModel() {
        return this.lastOriginalRequestModel;
    }

    public void setHttpClientExtraConfigProvider(HttpClientExtraConfigProvider httpClientExtraConfigProvider) {
        this.httpClientExtraConfigProvider = httpClientExtraConfigProvider;
    }

    public void setLastOriginalRequestModel(String lastOriginalRequestModel) {
        this.lastOriginalRequestModel = lastOriginalRequestModel;
    }
}

