/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector;

import com.oxygenxml.positron.connector.AIConnectorConfiguration;
import com.oxygenxml.positron.connector.ConnectorConfigurationData;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.options.ExternalPersistentObject;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.SerializableLinkedHashMap;

public class ConnectorConfigurationsPO
implements ExternalPersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)ConnectorConfigurationsPO.class.getName());
    private SerializableLinkedHashMap<String, ConnectorConfigurationData> configurations = new SerializableLinkedHashMap();
    private String currentConfigurationId;
    private String configurationsOrder;

    public Map<String, ConnectorConfigurationData> getConfigurations() {
        return this.configurations;
    }

    public ConnectorConfigurationData getConfiguration(String configurationId) {
        return (ConnectorConfigurationData)this.configurations.get((Object)configurationId);
    }

    public void addConfiguration(AIConnectorConfiguration configuration, String connectorId) {
        ConnectorConfigurationData configData = new ConnectorConfigurationData(configuration.getName(), configuration.getConfigurationId(), connectorId);
        this.configurations.put((Object)configuration.getConfigurationId(), (Object)configData);
    }

    public void setConfigurationParameter(String configurationId, String parameterName, String parameterValue) {
        ConnectorConfigurationData configData = (ConnectorConfigurationData)this.configurations.get((Object)configurationId);
        if (configData != null) {
            configData.setParameter(parameterName, parameterValue);
        }
    }

    public Map<String, String> getConfigurationParameters(String configurationId) {
        ConnectorConfigurationData configData = (ConnectorConfigurationData)this.configurations.get((Object)configurationId);
        return configData != null ? configData.getParameters() : new SerializableLinkedHashMap();
    }

    public String getCurrentConfigurationId() {
        return this.currentConfigurationId;
    }

    public void setCurrentConfigurationId(String currentConfigurationId) {
        this.currentConfigurationId = currentConfigurationId;
    }

    public void checkValid() throws InvalidPersistentObjException {
    }

    public String[] getNotPersistentFieldNames() {
        return new String[0];
    }

    public void updateConfigurationsOrder() {
        this.configurationsOrder = this.configurations.keySet().stream().collect(Collectors.joining(","));
    }

    public Object clone() {
        try {
            ConnectorConfigurationsPO cloned = (ConnectorConfigurationsPO)super.clone();
            if (this.configurations != null) {
                cloned.configurations = new SerializableLinkedHashMap();
                for (Map.Entry entry : this.configurations.entrySet()) {
                    cloned.configurations.put((Object)((String)entry.getKey()), (Object)((ConnectorConfigurationData)entry.getValue()).clone());
                }
            }
            cloned.currentConfigurationId = this.currentConfigurationId;
            cloned.configurationsOrder = this.configurationsOrder;
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            logger.error("Failed to clone ConnectorConfigurationsPO", (Throwable)e);
            return this;
        }
    }

    public String toString() {
        return "ConnectorConfigurationsPO: configurations=" + this.configurations + ", currentConfigurationId=" + this.currentConfigurationId;
    }
}

