/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.options.ExternalPersistentObject;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.SerializableLinkedHashMap;

public class ConnectorConfigurationData
implements ExternalPersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)ConnectorConfigurationData.class.getName());
    private String name;
    private String id;
    private String connectorId;
    private SerializableLinkedHashMap<String, String> parameters;

    public ConnectorConfigurationData(String name, String id, String connectorId) {
        this.name = name;
        this.id = id;
        this.connectorId = connectorId;
        this.parameters = new SerializableLinkedHashMap();
    }

    public ConnectorConfigurationData() {
        this.parameters = new SerializableLinkedHashMap();
    }

    public String getName() {
        return this.name;
    }

    public String getConfigurationId() {
        return this.id;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public SerializableLinkedHashMap<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(SerializableLinkedHashMap<String, String> parameters) {
        this.parameters = parameters != null ? parameters : new SerializableLinkedHashMap();
    }

    public void setParameter(String parameterName, String parameterValue) {
        this.parameters.put((Object)parameterName, (Object)parameterValue);
    }

    public ConnectorConfigurationData clone() {
        try {
            ConnectorConfigurationData cloned = (ConnectorConfigurationData)super.clone();
            if (this.parameters != null) {
                cloned.parameters = (SerializableLinkedHashMap)this.parameters.clone();
            }
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            logger.error("Failed to clone ConnectorConfigurationData", (Throwable)e);
            return this;
        }
    }

    public String toString() {
        return "ConnectorConfigurationData{name='" + this.name + "', connectorId='" + this.connectorId + "', parameters=" + this.parameters + "}";
    }

    public void checkValid() throws InvalidPersistentObjException {
    }

    public String[] getNotPersistentFieldNames() {
        return new String[0];
    }
}

