/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector;

import com.oxygenxml.positron.api.connector.AIConnector;
import com.oxygenxml.positron.api.connector.AIService;
import com.oxygenxml.positron.api.connector.ProxyProvider;
import com.oxygenxml.positron.api.connector.param.ConnectorParamBase;
import com.oxygenxml.positron.connector.util.AIServiceUtil;
import com.oxygenxml.positron.core.InvalidUserConfigurationException;
import com.oxygenxml.positron.utilities.ModelIdentifierUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AIConnectorConfiguration {
    private final String name;
    private final String id;
    private final AIConnector connector;
    private AIService cachedAIService;
    private ProxyProvider proxyProvider;

    public AIConnectorConfiguration(String name, String id, AIConnector connector) {
        this.name = name;
        this.id = id;
        this.connector = connector;
    }

    public AIConnectorConfiguration(String name, AIConnector connector) {
        this.name = name;
        this.id = ModelIdentifierUtil.createConfigurationId((String)name);
        this.connector = connector;
    }

    public void setProxyProvider(ProxyProvider proxyProvider) {
        this.proxyProvider = proxyProvider;
    }

    public String getName() {
        return this.name;
    }

    public String getConfigurationId() {
        return this.id;
    }

    public AIConnector getConnector() {
        return this.connector;
    }

    public List<ConnectorParamBase> getParametersList() {
        return this.connector != null ? this.connector.getParametersList() : new ArrayList();
    }

    public String getConnectorId() {
        return this.connector != null ? this.connector.getConnectorId() : null;
    }

    public String getConnectorName() {
        return this.connector != null ? this.connector.getConnectorName() : null;
    }

    public void updateResolvedParameters(Map<String, Object> resolvedParameters) {
        if (this.connector != null) {
            this.connector.setResolvedParameters(resolvedParameters);
        }
        this.cachedAIService = null;
    }

    public AIService getAIService() throws InvalidUserConfigurationException {
        if (this.cachedAIService == null && this.connector != null) {
            try {
                this.cachedAIService = this.connector.createAIService(this.proxyProvider, AIServiceUtil.getAIClientReadTimeout());
            }
            catch (Throwable e) {
                throw new InvalidUserConfigurationException(e.getMessage(), null);
            }
        }
        return this.cachedAIService;
    }
}

