/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector;

import com.oxygenxml.positron.api.connector.AIConnector;
import com.oxygenxml.positron.connector.AIConnectorConfiguration;
import com.oxygenxml.positron.connector.AIConnectorsFactory;
import com.oxygenxml.positron.connector.ConnectorConfigurationData;
import com.oxygenxml.positron.connector.ConnectorConfigurationsPO;
import com.oxygenxml.positron.connector.OxyProxyProvider;
import com.oxygenxml.positron.connector.api.BuiltInAIConnector;
import com.oxygenxml.positron.connector.auth.OAuthCodeFlowEnabled;
import com.oxygenxml.positron.connector.auth.OAuthCodeFlowHelper;
import com.oxygenxml.positron.core.OxyHttpClientExtraConfigProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyDetailsProvider;

public class AIConnectorConfigsManager {
    private static final Logger log = LoggerFactory.getLogger(AIConnectorConfigsManager.class);
    private final List<AIConnectorConfiguration> configurations = new ArrayList<AIConnectorConfiguration>();
    private String currentConfigurationId;
    private ProxyDetailsProvider proxyProvider;
    private static AIConnectorConfigsManager instance = null;
    private final AIConnectorsFactory connectorsFactory = new AIConnectorsFactory();

    private AIConnectorConfigsManager() {
    }

    public static AIConnectorConfigsManager getInstance() {
        if (instance == null) {
            instance = new AIConnectorConfigsManager();
        }
        return instance;
    }

    public void setProxyProvider(ProxyDetailsProvider proxyDetailsProvider) {
        this.proxyProvider = proxyDetailsProvider;
    }

    public void setOAuthCodeFlowHelper(OAuthCodeFlowHelper oauthCodeFlowHelper) {
        this.connectorsFactory.setOAuthCodeFlowHelper(oauthCodeFlowHelper);
        this.applyOAuthHelperToExistingConfigurations(oauthCodeFlowHelper);
    }

    private void applyOAuthHelperToExistingConfigurations(OAuthCodeFlowHelper oauthCodeFlowHelper) {
        if (oauthCodeFlowHelper != null) {
            for (AIConnectorConfiguration config : this.configurations) {
                AIConnector connector = config.getConnector();
                if (!(connector instanceof OAuthCodeFlowEnabled)) continue;
                ((OAuthCodeFlowEnabled)connector).setOAuthCodeFlowHelper(oauthCodeFlowHelper);
            }
        }
    }

    public void loadConnectorConfigurations(ConnectorConfigurationsPO persistentConfigs) {
        if (persistentConfigs != null) {
            this.configurations.clear();
            Map<String, ConnectorConfigurationData> configurationsMap = persistentConfigs.getConfigurations();
            for (Map.Entry<String, ConnectorConfigurationData> entry : configurationsMap.entrySet()) {
                ConnectorConfigurationData configData = entry.getValue();
                String connectorId = configData.getConnectorId();
                String configurationName = configData.getName();
                try {
                    AIConnectorConfiguration configuration = this.createConfiguration(configData, connectorId);
                    if (configuration == null) {
                        log.error("Failed to create configuration '{}' with connector ID '{}' during initialization", (Object)configurationName, (Object)connectorId);
                        continue;
                    }
                    this.addConfiguration(configuration);
                }
                catch (Throwable e) {
                    log.error("Error creating configuration '{}' with connector ID '{}': {}", new Object[]{configurationName, connectorId, e.getMessage(), e});
                }
            }
            this.currentConfigurationId = persistentConfigs.getCurrentConfigurationId();
        }
    }

    public List<AIConnectorConfiguration> getConfigurations() {
        return this.configurations;
    }

    public AIConnectorConfiguration getConfigurationById(String configurationId) {
        AIConnectorConfiguration toRet = null;
        for (AIConnectorConfiguration config : this.configurations) {
            if (!config.getConfigurationId().equals(configurationId)) continue;
            toRet = config;
            break;
        }
        return toRet;
    }

    public AIConnectorConfiguration getCurrentConfiguration() {
        return this.getConfigurationById(this.currentConfigurationId);
    }

    public void addConfiguration(AIConnectorConfiguration configuration) {
        if (this.getConfigurationById(configuration.getConfigurationId()) != null) {
            log.error("Configuration with name '{}' already exists", (Object)configuration.getConfigurationId());
        }
        this.configurations.add(configuration);
    }

    public boolean removeConfiguration(String configurationId) {
        return this.configurations.removeIf(config -> config.getConfigurationId().equals(configurationId));
    }

    public AIConnectorConfiguration createConfiguration(ConnectorConfigurationData configData, String connectorTypeId) {
        AIConnector connectorInstance = this.connectorsFactory.createConnector(connectorTypeId);
        if (connectorInstance == null) {
            log.error("Cannot create configuration '{}': connector type '{}' not found", (Object)configData.getName(), (Object)connectorTypeId);
            return null;
        }
        if (connectorInstance instanceof BuiltInAIConnector) {
            ((BuiltInAIConnector)connectorInstance).setHttpClientExtraConfigProvider(new OxyHttpClientExtraConfigProvider(this.proxyProvider));
        }
        AIConnectorConfiguration configuration = new AIConnectorConfiguration(configData.getName(), configData.getConfigurationId(), connectorInstance);
        configuration.setProxyProvider(new OxyProxyProvider(this.proxyProvider));
        return configuration;
    }

    public List<AIConnector> getConnectorTypes() {
        return this.connectorsFactory.getConnectorTypes();
    }
}

