/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp.implementation;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import okhttp3.Call;

public final class PerCallTimeoutCall {
    private static final Timer TIMER = new Timer("azure-okhttp-response-timeout-tracker", true);
    private final long perCallTimeout;
    private volatile boolean timedOut;
    private static final AtomicReferenceFieldUpdater<PerCallTimeoutCall, TimerTask> CURRENT_TIMEOUT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PerCallTimeoutCall.class, TimerTask.class, "currentTimeout");
    private volatile TimerTask currentTimeout;

    public PerCallTimeoutCall(long perCallTimeout) {
        this.perCallTimeout = perCallTimeout;
    }

    public void beginPerCallTimeout(Call call) {
        if (this.perCallTimeout > 0L) {
            PerCallTimerTask currentTimeout = new PerCallTimerTask(this, call);
            TIMER.schedule((TimerTask)currentTimeout, this.perCallTimeout);
            TimerTask existing = CURRENT_TIMEOUT_UPDATER.getAndSet(this, currentTimeout);
            if (existing != null) {
                existing.cancel();
            }
        }
    }

    public void endPerCallTimeout() {
        TimerTask currentTimeout = CURRENT_TIMEOUT_UPDATER.getAndSet(this, null);
        if (currentTimeout != null) {
            currentTimeout.cancel();
        }
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    private static final class PerCallTimerTask
    extends TimerTask {
        private final PerCallTimeoutCall perCallTimeoutCall;
        private final Call call;

        PerCallTimerTask(PerCallTimeoutCall perCallTimeoutCall, Call call) {
            this.perCallTimeoutCall = perCallTimeoutCall;
            this.call = call;
        }

        @Override
        public void run() {
            this.perCallTimeoutCall.timedOut = true;
            this.call.cancel();
        }
    }
}

