/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp.implementation;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public final class OkHttpProxySelector
extends ProxySelector {
    private final Proxy.Type proxyType;
    private final Supplier<InetSocketAddress> proxyAddressSupplier;
    private final Pattern nonProxyHostsPattern;

    public OkHttpProxySelector(Proxy.Type proxyType, Supplier<InetSocketAddress> proxyAddressSupplier, String nonProxyHosts) {
        this.proxyType = proxyType;
        this.proxyAddressSupplier = proxyAddressSupplier;
        this.nonProxyHostsPattern = nonProxyHosts == null ? null : Pattern.compile(nonProxyHosts, 2);
    }

    @Override
    public List<Proxy> select(URI uri) {
        return this.nonProxyHostsPattern == null || !this.nonProxyHostsPattern.matcher(uri.getHost()).matches() ? Collections.singletonList(new Proxy(this.proxyType, OkHttpProxySelector.getProxyAddress(this.proxyAddressSupplier))) : null;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }

    private static InetSocketAddress getProxyAddress(Supplier<InetSocketAddress> proxyAddressSupplier) {
        InetSocketAddress socketAddress = proxyAddressSupplier.get();
        if (!socketAddress.isUnresolved()) {
            return socketAddress;
        }
        return new InetSocketAddress(socketAddress.getHostString(), socketAddress.getPort());
    }
}

