/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.view;

import com.oxygenxml.ai.positron.license.exception.InvalidLicenseException;
import com.oxygenxml.positron.api.connector.AIConnector;
import com.oxygenxml.positron.api.connector.dto.ModelDescriptor;
import com.oxygenxml.positron.api.connector.param.ConnectorParamType;
import com.oxygenxml.positron.connector.AIConnectorConfigsManager;
import com.oxygenxml.positron.core.actions.MessagePresenter;
import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.engines.EnginesManagerProvider;
import com.oxygenxml.positron.core.engines.IEnginesManager;
import com.oxygenxml.positron.core.interactions.ContentInserter;
import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.interactions.DocumentDetailsProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.progress.OperationProgressPresenter;
import com.oxygenxml.positron.core.util.PositronOptionsUtil;
import com.oxygenxml.positron.eclipse.actions.AIActionsPopup;
import com.oxygenxml.positron.eclipse.chat.ChatConfigurator;
import com.oxygenxml.positron.eclipse.chat.ChatPanel;
import com.oxygenxml.positron.eclipse.chat.OperationProgressPresenterImpl;
import com.oxygenxml.positron.eclipse.completion.DirectConnectionHelper;
import com.oxygenxml.positron.eclipse.recordexamples.InstructionsSaver;
import com.oxygenxml.positron.eclipse.utils.IconsLoader;
import com.oxygenxml.positron.eclipse.utils.PopupMenuAction;
import com.oxygenxml.positron.eclipse.utils.PositronUtilities;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import com.oxygenxml.positron.eclipse.view.DirectConnectionInfoPanel;
import com.oxygenxml.positron.eclipse.view.PositronAssistantPanelController;
import com.oxygenxml.positron.plugin.EnablePositronController;
import com.oxygenxml.positron.plugin.SAMessagePresenter;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.completion.CompletionImplementationProvider;
import com.oxygenxml.positron.plugin.license.DirectConnectionLicenseManager;
import com.oxygenxml.positron.plugin.util.DirectConnectionConfigurationHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.part.ViewPart;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyDetailsProvider;

public class PositronAssistantView
extends ViewPart {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private OperationProgressPresenterImpl operationsStatusPresenter;
    protected AIActionsPopup openAIActionsPopup;
    private Action preferencesAction;
    private PopupMenuAction userDropDownAction;
    private PopupMenuAction aiModelsBtn;
    private IToolBarManager toolBarManager;
    private final StackLayout cardPanelLayout = new StackLayout();
    private Composite cardPanel;
    protected PositronAssistantPanelController assistantController;
    private ChatPanel chatPanel;
    private DirectConnectionInfoPanel directConnectionInfoPanel;
    private Composite disabledPositronPanel;
    private MessagePresenter statusPresenter;
    @Inject
    IWorkbench workbench;

    public void initPositronPanel(PluginWorkspace pluginWS, ProxyDetailsProvider proxyProvider, CompletionActionsManager completionActionsManager, ChatPanel chatPanel, EnablePositronController enablePositronController) {
        InstructionsSaver instructionsSaver = new InstructionsSaver(this::getAssistantController, chatPanel.getFavoritesManager(), this::getChatPanel);
        this.assistantController = new PositronAssistantPanelController(pluginWS, this, completionActionsManager, enablePositronController);
        this.directConnectionInfoPanel.setController(this.assistantController);
        this.openAIActionsPopup.initPopup(completionActionsManager, pluginWS, instructionsSaver, chatPanel);
        pluginWS.getOptionsStorage().addOptionListener(new WSOptionListener("oxygen.positron.plugin.enable.positron"){

            public void optionValueChanged(WSOptionChangedEvent event) {
                PositronAssistantView.this.reconfigureLayout();
            }
        });
        this.addListenersToUpdateEngine(pluginWS);
        this.reconfigureLayout();
        this.updateComponentsStatus();
    }

    private void reconfigureLayout() {
        if (PositronOptionsUtil.isPositronEnabled()) {
            this.cardPanelLayout.topControl = this.chatPanel;
        } else {
            if (this.disabledPositronPanel == null) {
                this.disabledPositronPanel = SWTUtils.createGridComposite(this.cardPanel, 1, 0, 5);
                Label disabledExplanationLabel = SWTUtils.createGridMultiLineLabel(this.disabledPositronPanel, 200, -1, 1);
                disabledExplanationLabel.setText(Translator.getInstance().getTranslation("Positron_Disabled_Explanation"));
            }
            this.cardPanelLayout.topControl = this.disabledPositronPanel;
        }
        this.cardPanel.layout();
    }

    private void addListenersToUpdateEngine(PluginWorkspace pluginWS) {
        ArrayList<String> optionTagsToListenTo = new ArrayList<String>();
        optionTagsToListenTo.add("oxygen.positron.plugin.direct.connector");
        for (AIConnector connector : AIConnectorConfigsManager.getInstance().getConnectorTypes()) {
            connector.getParametersList().stream().filter(p -> p.getType() == ConnectorParamType.MODEL_COMBO_BOX).forEach(modelParam -> optionTagsToListenTo.add(DirectConnectionHelper.computeOptionIdentifier(connector, modelParam)));
        }
        optionTagsToListenTo.forEach(optionTag -> pluginWS.getOptionsStorage().addOptionListener(new WSOptionListener((String)optionTag){

            public void optionValueChanged(WSOptionChangedEvent arg0) {
                PositronAssistantView.this.updateEngine();
            }
        }));
    }

    public void updateMessageStatus(String message) {
        this.statusPresenter.showStatusMessage(message);
    }

    public void setCompletionImplementationProvider(CompletionImplementationProvider implementationProvider) {
        if (implementationProvider != null) {
            ContentInserter inserter = implementationProvider.getCompletionInserter();
            DocumentContentInteractor prefixExtractor = implementationProvider.getPrefixExtractor();
            this.openAIActionsPopup.setCompletionImplementation(inserter, prefixExtractor);
            this.chatPanel.editorContextChanged((DocumentDetailsProvider)inserter);
        } else {
            this.openAIActionsPopup.setCompletionImplementation(null, null);
            this.chatPanel.editorContextChanged(null);
        }
    }

    public void updateMessageStatus(String message, boolean modal) {
        this.statusPresenter.showStatusMessage(message, modal);
    }

    public Map<String, List<PositronAIActionBase>> getCompletionActions() {
        Map<String, List<PositronAIActionBase>> actions = Collections.emptyMap();
        try {
            this.assistantController.checkDirectConnectionLicense();
            actions = this.openAIActionsPopup.getCompletionActions();
        }
        catch (InvalidLicenseException invalidLicenseException) {
            // empty catch block
        }
        return actions;
    }

    public void updateComponentsStatus() {
        this.operationsStatusPresenter.setVisible(true);
        this.showToolbarComponents(false);
        try {
            this.assistantController.checkDirectConnectionLicense();
            this.showActionsAndChat();
        }
        catch (InvalidLicenseException e) {
            this.cardPanelLayout.topControl = this.directConnectionInfoPanel;
            this.cardPanel.layout();
        }
        this.updateConnectionActionsInDropdown();
        this.updateEngine();
    }

    private void updateEngine() {
        this.aiModelsBtn.clearActions();
        final IEnginesManager enginesManager = EnginesManagerProvider.getInstance().getEnginesManager();
        boolean isEnginesManagerAvailable = enginesManager.isChoosingEngineAllowed();
        this.aiModelsBtn.setEnabled(isEnginesManagerAvailable);
        if (isEnginesManagerAvailable) {
            ModelDescriptor currentEngine = enginesManager.getCurrentEngineDescriptor();
            this.aiModelsBtn.setText(currentEngine.getUiLabel());
            Object tooltipText = TRANSLATOR.getTranslation("Default_model_explanation");
            if (currentEngine.getDescription() != null) {
                tooltipText = (String)tooltipText + "\n\n" + currentEngine.getDescription();
            }
            this.aiModelsBtn.setToolTipText((String)tooltipText);
            enginesManager.getAvailableEngines().values().forEach(list -> list.forEach(descriptor -> {
                final String engine = descriptor.getId();
                final String engineName = descriptor.getUiLabel();
                Action changeEngineAction = new Action(engineName){

                    public void run() {
                        PositronAssistantView.this.aiModelsBtn.setText(engineName);
                        enginesManager.saveEngine(engine);
                    }
                };
                this.aiModelsBtn.addAction(changeEngineAction);
                if (descriptor.getDescription() != null) {
                    changeEngineAction.setToolTipText(descriptor.getDescription());
                }
            }));
        } else {
            AIConnector selConnector = DirectConnectionHelper.getSelectedConnector().orElse(null);
            this.aiModelsBtn.setText(selConnector != null ? selConnector.getConnectorName() : "<Default>");
            this.aiModelsBtn.setToolTipText(null);
        }
        if (this.toolBarManager instanceof ToolBarManager) {
            ToolBarManager tbm = (ToolBarManager)this.toolBarManager;
            ToolBar tb = tbm.getControl();
            tb.layout(true);
            tb.pack(true);
            tb.redraw();
            Composite c = tbm.getControl().getParent();
            c.layout(true);
            c.pack(true);
            c.redraw();
            SWTUtils.setBackground(c, Display.getDefault().getSystemColor(25));
        }
    }

    private void showActionsAndChat() {
        this.cardPanelLayout.topControl = this.chatPanel;
        this.cardPanel.layout();
        this.operationsStatusPresenter.setVisible(false);
        this.showToolbarComponents(true);
    }

    public void showToolbarComponents(boolean show) {
        this.chatPanel.getNewChatAction().setEnabled(show);
        this.chatPanel.getHistoryComponent().setEnabled(show);
        this.openAIActionsPopup.setEnabled(show);
    }

    private void updateConnectionActionsInDropdown() {
        this.userDropDownAction.clearActions();
        if (DirectConnectionConfigurationHelper.isDirectConnection() && !DirectConnectionLicenseManager.getInstance().isCoveredByOxygenEnterpriseLicense()) {
            this.userDropDownAction.addAction(this.assistantController.getRegisterDirectConnectionLicenseAction());
            this.userDropDownAction.addAction(null);
        }
        this.userDropDownAction.addAction(this.preferencesAction);
    }

    public void selectionChanged(boolean hasSelection) {
        this.chatPanel.updateInputAreaHintBasedOnSelection(hasSelection);
    }

    public void createPartControl(Composite parent) {
        GridLayout mainLayout = new GridLayout(1, false);
        parent.setLayout((Layout)mainLayout);
        this.cardPanel = new Composite(parent, 0);
        this.cardPanel.setLayout((Layout)this.cardPanelLayout);
        GridData data = new GridData(4, 4, true, true);
        this.cardPanel.setLayoutData((Object)data);
        this.directConnectionInfoPanel = new DirectConnectionInfoPanel(this.cardPanel);
        this.chatPanel = new ChatPanel(this.cardPanel, this);
        this.cardPanelLayout.topControl = this.chatPanel;
        this.operationsStatusPresenter = new OperationProgressPresenterImpl(parent);
        this.statusPresenter = new SAMessagePresenter((OperationProgressPresenter)this.operationsStatusPresenter);
        Label disclaimerLabel = SWTUtils.createGridMultiLineLabel(parent, 200, -1, 1);
        disclaimerLabel.setText(TRANSLATOR.getTranslation("AI_may_provide_innacurate_info"));
        disclaimerLabel.setEnabled(false);
        this.contributeToActionBars();
        Display.getDefault().asyncExec(() -> {
            this.cardPanel.layout();
            ChatConfigurator.getInstance().setPositronView(this);
        });
    }

    public void setFocus() {
        this.chatPanel.setFocus();
    }

    private void contributeToActionBars() {
        this.openAIActionsPopup = new AIActionsPopup();
        this.userDropDownAction = new PopupMenuAction(Translator.getInstance().getTranslation("Preferences"), IconsLoader.loadIcon("/images/SettingsToolbar16.png"));
        this.preferencesAction = new Action(){

            public void run() {
                PositronUtilities.showPreferences(PositronAssistantView.this.getSite().getShell(), "PositronPreferencePage", new String[]{"PositronPreferencePage", "AIServicePreferencePage", "RAGPreferencePage"});
            }
        };
        this.preferencesAction.setText(Translator.getInstance().getTranslation("Preferences") + "...");
        this.preferencesAction.setToolTipText(Translator.getInstance().getTranslation("Preferences") + "...");
        this.preferencesAction.setImageDescriptor(IconsLoader.loadIcon("/images/SettingsToolbar16.png"));
        this.userDropDownAction.addAction(this.preferencesAction);
        this.userDropDownAction.setAction(this.preferencesAction);
        this.aiModelsBtn = new PopupMenuAction("", null);
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillViewPullDown(bars.getMenuManager());
        this.fillViewToolBar(bars.getToolBarManager());
    }

    private void fillViewPullDown(IMenuManager manager) {
        manager.add((IAction)this.chatPanel.getNewChatAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.preferencesAction);
    }

    private void fillViewToolBar(IToolBarManager manager) {
        manager.add((IAction)this.chatPanel.getNewChatAction());
        manager.add(this.chatPanel.getHistoryComponent());
        manager.add((IAction)this.openAIActionsPopup);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.aiModelsBtn);
        this.toolBarManager = manager;
        manager.add((IAction)this.userDropDownAction);
    }

    public OperationProgressPresenterImpl getOperationsStatusPresenter() {
        return this.operationsStatusPresenter;
    }

    public PositronAssistantPanelController getAssistantController() {
        return this.assistantController;
    }

    public ChatPanel getChatPanel() {
        return this.chatPanel;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }
}

