/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.view;

import com.oxygenxml.ai.positron.license.exception.InvalidLicenseException;
import com.oxygenxml.positron.core.auth.exceptions.ServerRequestException;
import com.oxygenxml.positron.core.auth.requests.ServerRequestListener;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.eclipse.view.PositronAssistantView;
import com.oxygenxml.positron.plugin.CustomActionsLoader;
import com.oxygenxml.positron.plugin.EnablePositronController;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.license.DirectConnectionLicenseManager;
import com.oxygenxml.positron.plugin.ui.SwingTimer;
import com.oxygenxml.positron.plugin.util.DirectConnectionConfigurationHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;

public class PositronAssistantPanelController
implements CustomActionsLoader {
    private static final Logger log = LoggerFactory.getLogger(PositronAssistantPanelController.class);
    private static final Translator TRANSLATOR = Translator.getInstance();
    private final CompletionActionsManager aiActionsManager;
    private PositronAssistantView positronAssistantPanel;
    private Action registerAction;
    private SwingTimer reloadLocalActionsTimer;
    private final DirectConnectionLicenseManager licenseManager = DirectConnectionLicenseManager.getInstance();

    public PositronAssistantPanelController(PluginWorkspace pluginWS, PositronAssistantView positronAssistantPanel, CompletionActionsManager aiActionsManager, final EnablePositronController enablePositronController) {
        this.positronAssistantPanel = positronAssistantPanel;
        this.aiActionsManager = aiActionsManager;
        this.createReloadCustomActionsTimer();
        this.licenseManager.addDirectConnectionLicenseListener(() -> {
            positronAssistantPanel.updateMessageStatus("");
            positronAssistantPanel.updateComponentsStatus();
            this.loadAiActions(false);
        });
        pluginWS.getOptionsStorage().addOptionListener(new WSOptionListener("oxygen.positron.plugin.actions.folder"){

            public void optionValueChanged(WSOptionChangedEvent arg0) {
                PositronAssistantPanelController.this.reloadLocalActionsTimer.restart();
            }
        });
        pluginWS.getOptionsStorage().addOptionListener(new WSOptionListener("oxygen.positron.plugin.load.default.actions"){

            public void optionValueChanged(WSOptionChangedEvent arg0) {
                PositronAssistantPanelController.this.reloadLocalActionsTimer.stop();
                PositronAssistantPanelController.this.loadAiActions(false);
            }
        });
        pluginWS.getOptionsStorage().addOptionListener(new WSOptionListener("oxygen.positron.plugin.ignore.actions"){

            public void optionValueChanged(WSOptionChangedEvent arg0) {
                PositronAssistantPanelController.this.reloadLocalActionsTimer.stop();
                PositronAssistantPanelController.this.loadAiActions(false);
            }
        });
        pluginWS.getOptionsStorage().addOptionListener(new WSOptionListener("oxygen.positron.plugin.enable.positron"){

            public void optionValueChanged(WSOptionChangedEvent event) {
                enablePositronController.reconfigurePositronUIComponents();
            }
        });
        this.loadAiActions(false);
    }

    public Action getRegisterDirectConnectionLicenseAction() {
        if (this.registerAction == null) {
            String actionName = TRANSLATOR.getTranslation(DirectConnectionConfigurationHelper.isLicenseForDirectConnectionValid() ? "Update_License_Key" : "Configure_License_Key") + "...";
            this.registerAction = new Action(actionName){

                public void run() {
                    PositronAssistantPanelController.this.licenseManager.askForLicense();
                }
            };
            this.licenseManager.addDirectConnectionLicenseListener(() -> {
                String newActionName = TRANSLATOR.getTranslation(DirectConnectionConfigurationHelper.isLicenseForDirectConnectionValid() ? "Update_License_Key" : "Configure_License_Key") + "...";
                this.registerAction.setText(newActionName);
            });
        }
        return this.registerAction;
    }

    void loadAiActions(boolean shouldRequestOnlyCustomAction) {
        try {
            this.checkDirectConnectionLicense();
            this.loadAiActionsInternal(shouldRequestOnlyCustomAction);
        }
        catch (InvalidLicenseException ex) {
            log.debug(ex.getMessage(), (Throwable)ex);
        }
    }

    protected void loadAiActionsInternal(boolean shouldRequestOnlyCustomAction) {
        this.aiActionsManager.loadAiActions(new ServerRequestListener(){
            ServerRequestException ex = null;

            public void beforeRequestStarted() {
                Display.getDefault().syncExec(() -> PositronAssistantPanelController.this.positronAssistantPanel.updateMessageStatus(TRANSLATOR.getTranslation("Loading_ai_actions")));
            }

            public void requestFailed(ServerRequestException ex) {
                this.ex = ex;
            }

            public void requestEnded() {
                Display.getDefault().syncExec(() -> {
                    if (this.ex != null) {
                        log.debug(this.ex.getMessage(), (Throwable)this.ex);
                        String message = MessageFormat.format(TRANSLATOR.getTranslation("Cannot_load_actions_from_ai_service"), "Oxygen AI Positron");
                        PositronAssistantPanelController.this.positronAssistantPanel.updateMessageStatus(message);
                        if (this.ex.isBlockerError()) {
                            PositronAssistantPanelController.this.positronAssistantPanel.updateMessageStatus(message + " " + this.ex.getMessage(), true);
                        }
                    } else {
                        PositronAssistantPanelController.this.positronAssistantPanel.updateMessageStatus("");
                    }
                });
            }
        }, shouldRequestOnlyCustomAction);
    }

    public void localFileSaved(URL fileURL) {
        try {
            if (this.aiActionsManager.isAdditionalActionsFile(URLUtil.getAbsoluteFileFromFileUrl((URL)fileURL))) {
                this.reloadLocalActionsTimer.restart();
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    void createReloadCustomActionsTimer() {
        this.reloadLocalActionsTimer = new SwingTimer(400);
        this.reloadLocalActionsTimer.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PositronAssistantPanelController.this.loadAiActions(true);
            }
        });
    }

    public void checkDirectConnectionLicense() throws InvalidLicenseException {
        this.licenseManager.checkDirectConnectionLicense();
    }

    public void loadCustomActions() {
        this.loadAiActions(true);
    }

    public void forceLoadAllAiActions() {
        this.loadAiActions(false);
    }
}

