/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.utils;

import com.oxygenxml.positron.eclipse.utils.AnimatedGifLabel;
import com.oxygenxml.positron.eclipse.utils.CompositeInsideScroll;
import com.oxygenxml.positron.eclipse.utils.IconsLoader;
import com.oxygenxml.positron.eclipse.utils.InputValidator;
import com.oxygenxml.positron.eclipse.utils.SWTTextFieldWithPlaceholder;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.Workbench;
import ro.sync.exml.view.graphics.Color;

public class SWTUtils {
    private static int pushButtonStyle = 0;
    public static final int ERROR = 1;
    public static final int QUESTION = 3;
    public static final int WARNING = 4;
    public static final int INFORMATION = 2;
    private static boolean highContrastConfigured = false;
    private static boolean highContrast = false;
    public static final String DROP_INSIDE = "inside";
    public static final String DROP_BEFORE = "before";
    public static final String DROP_AFTER = "after";

    public static Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        return button;
    }

    public static Button createBoldCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        FontData fd = button.getFont().getFontData()[0];
        fd.setStyle(1);
        Font boldFont = new Font((Device)group.getDisplay(), fd);
        button.setFont(boldFont);
        button.addDisposeListener(e -> boldFont.dispose());
        return button;
    }

    public static Group createGridGroup(Composite parent, int style, int columns) {
        Group group = new Group(parent, style);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        layout.numColumns = columns;
        return group;
    }

    public static Group createGridGroupEquals(Composite parent, int style, int columns) {
        Group group = new Group(parent, style);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        layout.numColumns = columns;
        layout.makeColumnsEqualWidth = true;
        group.setLayout((Layout)layout);
        return group;
    }

    public static Composite createGridComposite(Composite parent, int numColumns, int style) {
        Composite composite = new Composite(parent, style);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        return composite;
    }

    public static Composite createGridComposite(Composite parent, int numColumns, int style, int margin) {
        Composite composite = new Composite(parent, style);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = margin;
        layout.marginHeight = margin;
        composite.setLayout((Layout)layout);
        return composite;
    }

    public static Composite createGridCompositeEquals(Composite parent, int numColumns, int style) {
        return SWTUtils.createGridCompositeEquals(parent, numColumns, style, 2, 2);
    }

    public static Composite createGridCompositeEquals(Composite parent, int numColumns, int style, int marginWidth, int marginHeight) {
        Composite composite = new Composite(parent, style);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = true;
        layout.horizontalSpacing = 5;
        layout.marginHeight = marginHeight;
        layout.marginWidth = marginWidth;
        composite.setLayout((Layout)layout);
        return composite;
    }

    public static void showErrorMessage(Shell parent, String message) {
        SWTUtils.showErrorMessage(parent, "Error", message);
    }

    public static void showErrorMessage(Shell parent, String title, String message) {
        SWTUtils.showMessage(parent, title, message, false, 1);
    }

    public static void showHelpErrorMessage(Shell parent, String title, String message, String helpID) {
        SWTUtils.showMessage(parent, title, message, false, 1, helpID);
    }

    public static void showErrorMessage(String message) {
        SWTUtils.showErrorMessage(SWTUtils.getShell(), message);
    }

    public static void showErrorMessage(String title, String message) {
        SWTUtils.showErrorMessage(SWTUtils.getShell(), title, message);
    }

    public static void showInfoMessage(Shell shell, String message) {
        SWTUtils.showInfoMessage(shell, "Information", message);
    }

    public static void showInfoMessage(Shell shell, String title, String message) {
        SWTUtils.showMessage(shell, title, message, false, 2);
    }

    public static void showInfoMessage(String title, String message) {
        SWTUtils.showInfoMessage(SWTUtils.getShell(), title, message);
    }

    public static void showWarningMessage(Shell shell, String message) {
        SWTUtils.showWarningMessage(shell, "Warning", message);
    }

    public static void showWarningMessage(Shell shell, String title, String message) {
        SWTUtils.showMessage(shell, title, message, true, 4);
    }

    public static void showWarningMessage(String title, String message) {
        SWTUtils.showWarningMessage(SWTUtils.getShell(), title, message);
    }

    public static boolean showQuestionMessage(final Shell shell, final String title, final String message) {
        final boolean[] result = new boolean[1];
        SWTUtils.invokeSynchronously(new Runnable(){

            @Override
            public void run() {
                Shell parent = shell;
                if (parent == null || parent.isDisposed()) {
                    parent = SWTUtils.getShell();
                }
                result[0] = MessageDialog.openQuestion((Shell)parent, (String)title, (String)message);
            }
        });
        return result[0];
    }

    public static int showQuestionMessageWithMultiAnswers(Shell shell, String title, String message, String[] buttonsText) {
        return SWTUtils.showMessageDialogWithMultiAnswers(shell, title, 3, message, buttonsText, 0);
    }

    public static int showMessageDialogWithMultiAnswers(String title, int type, String message, String[] buttonsText) {
        return SWTUtils.showMessageDialogWithMultiAnswers(SWTUtils.getShell(), title, type, message, buttonsText, 0);
    }

    public static int showMessageDialogWithMultiAnswers(final Shell shell, final String title, final int type, final String message, final String[] buttonsText, final int defaultButtonIndex) {
        final int[] result = new int[1];
        SWTUtils.invokeSynchronously(new Runnable(){

            @Override
            public void run() {
                Shell parent = shell;
                if (parent == null || parent.isDisposed()) {
                    parent = SWTUtils.getShell();
                }
                MessageDialog messageDialog = new MessageDialog(parent, title, null, message, type, buttonsText, defaultButtonIndex);
                result[0] = messageDialog.open();
            }
        });
        return result[0];
    }

    public static boolean showConfirmMessage(final Shell shell, final String title, final String message) {
        final boolean[] result = new boolean[1];
        SWTUtils.invokeSynchronously(new Runnable(){

            @Override
            public void run() {
                Shell parent = shell;
                if (parent == null || parent.isDisposed()) {
                    parent = SWTUtils.getShell();
                }
                result[0] = MessageDialog.openConfirm((Shell)parent, (String)title, (String)message);
            }
        });
        return result[0];
    }

    public static String showInputDialog(Shell shell, String title, String message, String initialValue, final InputValidator inputValidator, boolean isPassword) {
        IInputValidator ecInputValidator = new IInputValidator(){

            public String isValid(String newText) {
                if (inputValidator != null) {
                    return inputValidator.isValid(newText);
                }
                return null;
            }
        };
        return SWTUtils.showInputDialog(shell, title, message, initialValue, ecInputValidator, isPassword);
    }

    public static String showInputDialog(final Shell shell, final String title, final String message, final String initialValue, final IInputValidator inputValidator, final boolean isPassword) {
        final String[] result = new String[1];
        SWTUtils.invokeSynchronously(new Runnable(){

            @Override
            public void run() {
                Shell parent = shell;
                InputDialog inputDialog = new InputDialog(parent, title, message, initialValue, inputValidator){

                    protected Control createDialogArea(Composite parent) {
                        Control c = super.createDialogArea(parent);
                        if (isPassword) {
                            Text t = this.getText();
                            t.setEchoChar('*');
                        }
                        return c;
                    }
                };
                int open = inputDialog.open();
                if (open == 0) {
                    result[0] = inputDialog.getValue();
                }
            }
        });
        return result[0];
    }

    public static void showMessage(Shell shell, String title, String message, boolean renderHTML, int messageType) {
        SWTUtils.showMessage(shell, title, message, renderHTML, messageType, null);
    }

    public static void showMessage(Shell shell, String title, String message, boolean renderHTML, int messageType, String helpID) {
        SWTUtils.showMessageWithCustomButtonsLabels(shell, title, message, new String[]{messageType == 1 ? IDialogConstants.CLOSE_LABEL : IDialogConstants.OK_LABEL}, 0, renderHTML, messageType, helpID);
    }

    public static int showWarningMessageWithCustomButtonsLabels(Shell shell, String title, String message, String[] buttonsLabels, int defaultButtonIndex, boolean renderHTML, String helpID) {
        return SWTUtils.showMessageWithCustomButtonsLabels(shell, title, message, buttonsLabels, defaultButtonIndex, renderHTML, 4, helpID);
    }

    public static int showMessageWithCustomButtonsLabels(Shell shell, String title, String message, String[] buttonsLabels, int defaultButtonIndex, boolean renderHTML, int messageType, String helpID) {
        return SWTUtils.showMessageWithCustomButtonsLabels(shell, title, message, buttonsLabels, defaultButtonIndex, renderHTML, messageType, helpID, null, null);
    }

    public static int showMessageWithCustomButtonsLabels(final Shell shell, final String title, final String message, final String[] buttonsLabels, final int defaultButtonIndex, final boolean renderHTML, final int messageType, String helpID, String linkLabelText, Runnable runnable) {
        final int[] result = new int[]{-1};
        SWTUtils.invokeSynchronously(new Runnable(){

            @Override
            public void run() {
                Shell parent = shell;
                if (parent == null || parent.isDisposed()) {
                    parent = SWTUtils.getShell();
                }
                final boolean largeMessage = SWTUtils.isLargeMessage(String.valueOf(message));
                MessageDialog dialog = new MessageDialog(parent, title, null, message, messageType, buttonsLabels, defaultButtonIndex){
                    {
                        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
                        if (largeMessage || renderHTML) {
                            this.setShellStyle(67696);
                        }
                    }

                    protected Control createMessageArea(Composite composite) {
                        return SWTUtils.createTextMessageArea(composite, this.getImage(), this.message, largeMessage, renderHTML);
                    }

                    protected Control createCustomArea(Composite parent) {
                        return null;
                    }
                };
                result[0] = dialog.open();
            }
        });
        return result[0];
    }

    private static boolean isLargeMessage(String message) {
        int numberOfLines = 0;
        int currentLineChars = 0;
        for (int i = 0; i < message.length(); ++i) {
            if (message.charAt(i) == '\n') {
                ++numberOfLines;
                currentLineChars = 0;
            } else {
                ++currentLineChars;
            }
            if (currentLineChars < 120) continue;
            ++numberOfLines;
            currentLineChars = 0;
        }
        return numberOfLines > 15;
    }

    private static Control createTextMessageArea(Composite composite, Image image, String message, boolean longMessage, boolean renderHTML) {
        if (image != null && !renderHTML) {
            Label imageLabel = new Label(composite, 0);
            image.setBackground(imageLabel.getBackground());
            imageLabel.setImage(image);
            imageLabel.setLayoutData((Object)new GridData(66));
            composite.addDisposeListener(e -> imageLabel.dispose());
        }
        if (message != null) {
            GridData data = new GridData(4, 4, true, true);
            data.widthHint = 400;
            Control[] widget = new Control[1];
            if (renderHTML) {
                data.heightHint = 200;
                Browser browser = SWTUtils.createBrowser(composite, 0);
                if (browser != null) {
                    browser.setText(message);
                    widget[0] = browser;
                } else {
                    renderHTML = false;
                }
            }
            if (!renderHTML) {
                if (longMessage) {
                    data.heightHint = 200;
                    text = new Text(composite, 586);
                    text.setBackground(composite.getBackground());
                    text.setText(message);
                    widget[0] = text;
                } else {
                    text = new Label(composite, 64);
                    text.setBackground(composite.getBackground());
                    text.setText(message.replaceAll("\r", ""));
                    widget[0] = text;
                    data.horizontalAlignment = 4;
                    data.verticalAlignment = 0;
                    data.widthHint = 400;
                }
            }
            widget[0].setLayoutData((Object)data);
            composite.addDisposeListener(e -> widget[0].dispose());
        }
        return composite;
    }

    public static Shell getShell() {
        final Shell[] shell = new Shell[1];
        SWTUtils.invokeSynchronously(new Runnable(){

            @Override
            public void run() {
                Display display = null;
                Workbench workbench = Workbench.getInstance();
                if (workbench != null) {
                    display = workbench.getDisplay();
                }
                if (display == null) {
                    display = Display.getDefault();
                }
                shell[0] = display.getActiveShell();
            }
        });
        return shell[0];
    }

    public static Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        return label;
    }

    public static Label createImageLabel(Composite parent, Image image, int style) {
        Label label = new Label(parent, style);
        label.setImage(image);
        return label;
    }

    public static Label createImageLabel(Composite parent, Image image) {
        return SWTUtils.createImageLabel(parent, image, 16384);
    }

    public static Label createAnimatedLabel(Composite parent, String animatedImagePath) {
        return new AnimatedGifLabel(parent, IconsLoader.loadAnimatedIcon(animatedImagePath));
    }

    public static Label createWrapLabel(Composite parent, String text) {
        Label label = new Label(parent, 16448);
        label.setText(text);
        return label;
    }

    public static Label createCenterLabel(Composite parent, String text) {
        Label label = new Label(parent, 0x1000000);
        label.setText(text);
        return label;
    }

    public static Label createTitleLabel(Composite parent, String text) {
        return SWTUtils.createTitleLabel(parent, text, true);
    }

    public static Label createTitleLabel(Composite parent, String text, boolean grabHorizontally) {
        return SWTUtils.createTitleLabel(parent, text, grabHorizontally, false, false);
    }

    public static Label createTitleLabel(Composite parent, String text, boolean grabHorizontally, boolean center) {
        return SWTUtils.createTitleLabel(parent, text, grabHorizontally, center, false);
    }

    public static Label createTitleLabel(Composite parent, String text, boolean grabHorizontally, boolean center, boolean bigger) {
        Label label = new Label(parent, center ? 0x1000040 : 16448);
        label.setText(text);
        FontData fontData = label.getFont().getFontData()[0];
        fontData.setStyle(1);
        if (bigger) {
            fontData.setHeight(fontData.getHeight() + 2);
        }
        Font font = new Font((Device)Display.getDefault(), fontData);
        label.setFont(font);
        GridData data = new GridData(center ? 0x1000000 : 4, 0, true, false);
        if (grabHorizontally) {
            data.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        }
        data.verticalIndent = 4;
        label.setLayoutData((Object)data);
        label.addDisposeListener(e -> font.dispose());
        return label;
    }

    public static Label createLabelBold(Composite parent, String text) {
        Label label = new Label(parent, 16448);
        label.setText(text);
        FontData fontData = label.getFont().getFontData()[0];
        fontData.setStyle(1);
        Font font = new Font((Device)Display.getDefault(), fontData);
        label.setFont(font);
        label.addDisposeListener(e -> font.dispose());
        return label;
    }

    public static Label createLabelItalic(Composite parent, String text) {
        Label label = new Label(parent, 16448);
        label.setText(text);
        FontData fontData = label.getFont().getFontData()[0];
        fontData.setStyle(2);
        Font font = new Font((Device)Display.getDefault(), fontData);
        label.setFont(font);
        label.addDisposeListener(e -> font.dispose());
        return label;
    }

    public static Label createGridSeparatorLabel(Composite parent, int span, int verticalAlign, int verticalIndent) {
        Label label = new Label(parent, 0x1000102);
        GridData data = new GridData(4, verticalAlign, true, false);
        data.horizontalSpan = span;
        data.verticalIndent = verticalIndent;
        label.setLayoutData((Object)data);
        return label;
    }

    public static Label createGridSeparatorLabel(Composite parent, int verticalIndent) {
        return SWTUtils.createGridSeparatorLabel(parent, ((GridLayout)parent.getLayout()).numColumns, 0, verticalIndent);
    }

    public static Label createGridSeparatorLabel(Composite parent) {
        return SWTUtils.createGridSeparatorLabel(parent, 7);
    }

    public static org.eclipse.swt.widgets.List createList(Composite parent, int style) {
        return new org.eclipse.swt.widgets.List(parent, 0x300 | style);
    }

    public static Table createTable(Composite parent, int style) {
        Table table = new Table(parent, style);
        return table;
    }

    public static Button createPushButton(Composite parent, String label) {
        return SWTUtils.createPushButton(parent, label, null, false);
    }

    public static Button createPushButton(Composite parent, Image image) {
        return SWTUtils.createPushButton(parent, null, image, false);
    }

    public static Button createPushButtonFlat(Composite parent, Image image) {
        return SWTUtils.createPushButton(parent, null, image, true);
    }

    private static Button createPushButton(Composite parent, String label, Image image, boolean flat) {
        int style = 8;
        if (flat) {
            style = SWTUtils.getPushButtonStyle();
        }
        Button button = new Button(parent, style);
        if (label != null && label.length() > 0) {
            button.setText(label);
        }
        if (image != null) {
            button.setImage(image);
        }
        return button;
    }

    public static Button createRadioButton(Composite parent, String label) {
        return SWTUtils.createRadioButton(parent, label, false);
    }

    public static Button createRadioButton(Composite parent, String label, boolean bold) {
        Button button = new Button(parent, 16400);
        if (label != null) {
            button.setText(label);
            if (bold) {
                FontData fd = button.getFont().getFontData()[0];
                fd.setStyle(1);
                Font boldFont = new Font((Device)parent.getDisplay(), fd);
                button.setFont(boldFont);
                button.addDisposeListener(e -> boldFont.dispose());
            }
        }
        return button;
    }

    public static Button createToggleButton(Composite parent, String label) {
        return SWTUtils.createToggleButton(parent, label, 16384);
    }

    public static Button createToggleButton(Composite parent, String label, int textAlignment) {
        Button button = new Button(parent, 2 | textAlignment);
        if (label != null) {
            button.setText(label);
        }
        return button;
    }

    public static Text createGridTextField(Composite parent) {
        return SWTUtils.createGridTextField(parent, false);
    }

    public static Text createGridTextField(Composite parent, boolean password) {
        int styles = 2052;
        if (password) {
            styles |= 0x400000;
        }
        Text text = new Text(parent, styles);
        GridData data = new GridData(4, 0x1000000, true, false);
        text.setLayoutData((Object)data);
        return text;
    }

    public static Text createGridTextField(Composite parent, int styles, int width, int height) {
        Text text = new Text(parent, styles | 0x800);
        GridData data = new GridData(4, 0x1000000, true, false);
        if (height > 0) {
            data.heightHint = height;
        }
        if (width > 0) {
            data.widthHint = width;
        }
        text.setLayoutData((Object)data);
        return text;
    }

    public static Label createGridMultiLineLabel(Composite parent, int width, int height, int horizontalSpan) {
        Label text = new Label(parent, 64);
        GridData data = new GridData(4, 0x1000000, true, false);
        if (height > 0) {
            data.heightHint = height;
        }
        if (width > 0) {
            data.widthHint = width;
        }
        if (horizontalSpan > 0) {
            data.horizontalSpan = horizontalSpan;
        }
        text.setLayoutData((Object)data);
        return text;
    }

    public static Text createGridTextField(Composite parent, int width, int height) {
        return SWTUtils.createGridTextField(parent, 4, width, height);
    }

    public static StyledText createGridStyledText(Composite parent, int style, int width, int height) {
        StyledText text = new StyledText(parent, style | 0x800);
        GridData data = new GridData(4, 0, true, false);
        if (height > 0) {
            data.heightHint = height;
        }
        if (width > 0) {
            data.widthHint = width;
        }
        text.setLayoutData((Object)data);
        return text;
    }

    public static Combo createCombo(Composite parent, int style) {
        return new Combo(parent, style);
    }

    public static boolean onSWTThread() {
        return Display.getDefault().getThread() == Thread.currentThread();
    }

    public static void invokeSynchronously(Runnable runnable) {
        if (SWTUtils.onSWTThread()) {
            runnable.run();
        } else {
            try {
                Display.getDefault().syncExec(runnable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void asyncExec(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    private static int getPushButtonStyle() {
        if (pushButtonStyle == 0) {
            pushButtonStyle = 0x800008;
        }
        return pushButtonStyle;
    }

    public static Point getAbsoluteLocation(Control control, boolean includeShell) {
        Point abs = null;
        Point original = control.getLocation();
        int x = original.x;
        int y = original.y;
        for (Composite parent = control.getParent(); parent != null; parent = parent.getParent()) {
            x += parent.getLocation().x;
            y += parent.getLocation().y;
            if (!includeShell && parent instanceof Shell) break;
        }
        abs = new Point(x, y);
        return abs;
    }

    public static Composite createSection(Composite parent, String text) {
        return SWTUtils.createSection(parent, text, false, 1, null);
    }

    public static Composite createBoldSection(Composite parent, String text) {
        return SWTUtils.createBoldSection(parent, text, 1);
    }

    public static Composite createBoldSection(Composite parent, String text, int horizontalSpan) {
        return SWTUtils.createSection(parent, text, true, horizontalSpan, null);
    }

    private static Composite createSection(Composite parent, String text, boolean boldText, int horizontalSpan, org.eclipse.swt.graphics.Color background) {
        Composite section = SWTUtils.createGridComposite(parent, 2, 0, 0);
        Label textLabel = boldText ? SWTUtils.createLabelBold(section, text) : SWTUtils.createLabel(section, text);
        Label separatorLabel = SWTUtils.createGridSeparatorLabel(section, 1, 0, 8);
        if (background != null) {
            section.setBackground(background);
            textLabel.setBackground(background);
            separatorLabel.setBackground(background);
        }
        GridData gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = horizontalSpan;
        gridData.verticalIndent = 7;
        section.setLayoutData((Object)gridData);
        return section;
    }

    public static void setEnabled(Composite composite, boolean enable) {
        Control[] children;
        composite.setEnabled(enable);
        for (Control control : children = composite.getChildren()) {
            if (control instanceof Composite) {
                SWTUtils.setEnabled((Composite)control, enable);
                continue;
            }
            control.setEnabled(enable);
        }
    }

    public static void setEnabled(Control control, boolean enable) {
        if (control instanceof Composite) {
            SWTUtils.setEnabled((Composite)control, enable);
        } else {
            control.setEnabled(enable);
        }
    }

    public static void setBackground(Composite composite, org.eclipse.swt.graphics.Color bgColor) {
        Control[] children;
        composite.setBackground(bgColor);
        for (Control control : children = composite.getChildren()) {
            if (control instanceof Button) continue;
            if (control instanceof Composite) {
                SWTUtils.setBackground((Composite)control, bgColor);
                continue;
            }
            control.setBackground(bgColor);
        }
    }

    public static boolean isEnter(int keyCode) {
        return keyCode == 13 || keyCode == 10 || keyCode == 0x1000050;
    }

    public static void setComponentVisible(Control component, boolean visible) {
        boolean oldVisible = component.isVisible();
        boolean relayedOut = false;
        if (oldVisible != visible) {
            component.setVisible(visible);
            relayedOut = true;
        }
        GridData gd = (GridData)component.getLayoutData();
        if (gd.exclude != !visible) {
            gd.exclude = !visible;
            relayedOut = true;
        }
        if (relayedOut) {
            component.getParent().layout(true);
        }
    }

    public static org.eclipse.swt.graphics.Color getSystemColor(final int colorType) {
        final org.eclipse.swt.graphics.Color[] color = new org.eclipse.swt.graphics.Color[1];
        SWTUtils.invokeSynchronously(new Runnable(){

            @Override
            public void run() {
                color[0] = Display.getDefault().getSystemColor(colorType);
            }
        });
        return color[0];
    }

    public static boolean isHighContrastTheme() {
        if (highContrastConfigured) {
            return highContrast;
        }
        SWTUtils.invokeSynchronously(new Runnable(){

            @Override
            public void run() {
                highContrast = Display.getDefault().getHighContrast();
            }
        });
        highContrastConfigured = true;
        return highContrast;
    }

    public static DropHint getDropHint(Tree tree, DropTargetEvent event) {
        String currentHint = DROP_INSIDE;
        TreeItem item = (TreeItem)event.item;
        Object destination = null;
        if (item != null) {
            TreeItem parent;
            destination = item.getData();
            Rectangle bounds = item.getBounds();
            if (bounds != null) {
                Point relativeCursorLocation = tree.toControl(event.x, event.y);
                currentHint = SWTUtils.getDropPointHint(bounds, relativeCursorLocation);
            }
            if (currentHint == DROP_BEFORE && (parent = item.getParentItem()) != null) {
                TreeItem[] items = parent.getItems();
                for (int i = 0; i < items.length; ++i) {
                    if (items[i] != item) continue;
                    if (i > 0) {
                        destination = items[i - 1].getData();
                        currentHint = DROP_AFTER;
                        break;
                    }
                    destination = parent.getData();
                    currentHint = DROP_INSIDE;
                    break;
                }
            }
        }
        return new DropHint(currentHint == DROP_INSIDE, destination);
    }

    public static String getDropPointHint(Rectangle bounds, Point relativeCursorLocation) {
        String currentHint = DROP_INSIDE;
        int div3 = bounds.height / 3;
        if (relativeCursorLocation.y < bounds.y + div3) {
            currentHint = DROP_BEFORE;
        } else if (relativeCursorLocation.y > bounds.y + 2 * div3) {
            currentHint = DROP_AFTER;
        }
        return currentHint;
    }

    public static ImageDescriptor getColorIcon(final Color highlightColor, final int size) {
        return new ImageDescriptor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ImageData getImageData() {
                Image image = new Image((Device)Display.getCurrent(), size, size);
                GC gc = new GC((Drawable)image);
                try {
                    gc.setForeground(new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), 128, 128, 128));
                    gc.drawRectangle(0, 0, size - 1, size - 1);
                    org.eclipse.swt.graphics.Color highlight = new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), highlightColor.getRed(), highlightColor.getGreen(), highlightColor.getBlue());
                    gc.setBackground(highlight);
                    gc.fillRectangle(1, 1, size - 2, size - 2);
                    highlight.dispose();
                }
                finally {
                    gc.dispose();
                }
                ImageData imageData = image.getImageData();
                image.dispose();
                return imageData;
            }
        };
    }

    public static ImageDescriptor createDoubleColorImageIcon(final int size, final Color color1, final Color color2) {
        return new ImageDescriptor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ImageData getImageData() {
                Display display = Display.getCurrent();
                Image image = new Image((Device)display, size, size);
                GC gc = new GC((Drawable)image);
                try {
                    org.eclipse.swt.graphics.Color borderColor = new org.eclipse.swt.graphics.Color((Device)display, 128, 128, 128);
                    org.eclipse.swt.graphics.Color backgroundColor = new org.eclipse.swt.graphics.Color((Device)display, color2.getRed(), color2.getGreen(), color2.getBlue());
                    org.eclipse.swt.graphics.Color topLeftColor = new org.eclipse.swt.graphics.Color((Device)display, color1.getRed(), color1.getGreen(), color1.getBlue());
                    gc.setBackground(backgroundColor);
                    gc.fillRectangle(0, 0, size, size);
                    gc.setForeground(borderColor);
                    gc.drawRectangle(0, 0, size - 1, size - 1);
                    gc.setBackground(topLeftColor);
                    Path triangle = new Path((Device)display);
                    triangle.moveTo(1.0f, 1.0f);
                    triangle.lineTo((float)size - 1.0f, 1.0f);
                    triangle.lineTo(1.0f, (float)size - 1.0f);
                    triangle.close();
                    gc.fillPath(triangle);
                    borderColor.dispose();
                    backgroundColor.dispose();
                    topLeftColor.dispose();
                    triangle.dispose();
                }
                finally {
                    gc.dispose();
                }
                ImageData imageData = image.getImageData();
                image.dispose();
                return imageData;
            }
        };
    }

    public static Control createDropDownButton(Composite parentComposite, Action defaultAction, final List<Action> actions) {
        final MenuManager menuManager = new MenuManager();
        ToolBar toolbar = new ToolBar(parentComposite, 0x800000);
        GridData data = new GridData(0, 0, false, false);
        toolbar.setLayoutData((Object)data);
        ToolBarManager toolbarMng = new ToolBarManager(toolbar);
        toolbarMng.add((IAction)defaultAction);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.removeAll();
                for (int a = 0; a < actions.size(); ++a) {
                    Action action = (Action)actions.get(a);
                    if (action == null) {
                        menuManager.add((IContributionItem)new Separator());
                        continue;
                    }
                    menuManager.add((IAction)action);
                }
            }
        });
        toolbarMng.update(true);
        defaultAction.setMenuCreator(new IMenuCreator(){
            private Menu menu = null;

            public Menu getMenu(Menu parent) {
                return null;
            }

            public Menu getMenu(Control parent) {
                this.dispose();
                this.menu = menuManager.createContextMenu(parent);
                return this.menu;
            }

            public void dispose() {
                if (this.menu != null) {
                    this.menu.dispose();
                }
            }
        });
        parentComposite.addDisposeListener(arg0 -> menuManager.dispose());
        return toolbar;
    }

    public static boolean isValid(Widget widget) {
        return widget != null && !widget.isDisposed();
    }

    public static Text createGridTextFieldWithPlaceholder(Composite parent, int width, int height, String placeholder) {
        Text text = null;
        if (placeholder != null && placeholder.trim().length() > 0) {
            text = new SWTTextFieldWithPlaceholder(parent, 2052, placeholder);
            GridData data = new GridData(4, 0x1000000, true, false);
            if (height > 0) {
                data.heightHint = height;
            }
            if (width > 0) {
                data.widthHint = width;
            }
            text.setLayoutData((Object)data);
        } else {
            text = SWTUtils.createGridTextField(parent, width, height);
        }
        return text;
    }

    public static void setAllDescendantsEnabled(Composite container, boolean isEnabled) {
        Arrays.stream(container.getChildren()).forEach(child -> {
            if (child instanceof Composite) {
                SWTUtils.setAllDescendantsEnabled((Composite)child, isEnabled);
            }
            child.setEnabled(isEnabled);
        });
    }

    public static void scrollToVisible(Composite panel) {
        CompositeInsideScroll scrollContent = SWTUtils.findScrollContentAncestor(panel);
        if (scrollContent != null) {
            ScrolledComposite scrollComposite = scrollContent.getParentScroll();
            int relativeHeigth = SWTUtils.getRelativeHeight(panel, scrollContent);
            Point origin = scrollComposite.getOrigin();
            Rectangle rectArea = scrollComposite.getClientArea();
            int newOriginY = relativeHeigth - rectArea.height;
            scrollComposite.setOrigin(origin.x, Math.max(0, newOriginY));
        }
    }

    private static int getRelativeHeight(Composite c, Composite where) {
        int heigth = c.getLocation().y + c.getBounds().height;
        for (Composite parent = c.getParent(); parent != null && parent != where; parent = parent.getParent()) {
            heigth += parent.getLocation().y;
        }
        return heigth;
    }

    private static CompositeInsideScroll findScrollContentAncestor(Composite c) {
        CompositeInsideScroll ancestor = null;
        while (c != null && !c.isDisposed()) {
            if (c instanceof CompositeInsideScroll) {
                ancestor = (CompositeInsideScroll)c;
                break;
            }
            c = c.getParent();
        }
        return ancestor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Browser createBrowser(Composite parent, int style) {
        try {
            return new Browser(parent, style);
        }
        catch (SWTError e) {
            String browserTypeProperty = "org.eclipse.swt.browser.DefaultType";
            String oldProperty = System.getProperty(browserTypeProperty);
            if (oldProperty != null) {
                try {
                    System.clearProperty(browserTypeProperty);
                    Browser browser = new Browser(parent, style);
                    return browser;
                }
                finally {
                    System.setProperty(browserTypeProperty, oldProperty);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static class DropHint {
        public final boolean asChild;
        public final Object destination;

        private DropHint(boolean asChild, Object destination) {
            this.asChild = asChild;
            this.destination = destination;
        }
    }
}

