/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.utils;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IconsLoader {
    private static final Logger log = LoggerFactory.getLogger(IconsLoader.class);

    public static ImageDescriptor loadIcon(String icon) {
        ImageDescriptor imgIcon = null;
        if (icon != null) {
            URL resource = Thread.currentThread().getContextClassLoader().getResource(icon);
            if (resource != null) {
                try {
                    resource = FileLocator.resolve((URL)resource);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (resource != null) {
                imgIcon = ImageDescriptor.createFromURL((URL)resource);
            }
        }
        return imgIcon;
    }

    public static ImageData[] loadAnimatedIcon(String icon) {
        ImageData[] imageDataArray = null;
        if (icon != null) {
            URL resource = Thread.currentThread().getContextClassLoader().getResource(icon);
            try {
                if (resource != null) {
                    resource = FileLocator.resolve((URL)resource);
                }
                if (resource != null) {
                    ImageLoader loader = new ImageLoader();
                    imageDataArray = loader.load(resource.openStream());
                }
            }
            catch (IOException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return imageDataArray;
    }

    private IconsLoader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

