/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.ui.history;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.eclipse.utils.IconsLoader;
import com.oxygenxml.positron.eclipse.utils.PopupMenuAction;
import com.oxygenxml.positron.plugin.ui.history.LimitedSizeHistoryList;
import com.oxygenxml.positron.plugin.ui.history.StoredObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class HistoryComponent<H extends StoredObject>
extends PopupMenuAction {
    private final Translator messages = Translator.getInstance();
    private LimitedSizeHistoryList<H> historyObjectList;
    private Action clearHistoryAction = new Action(this.messages.getTranslation("Clear_history"), IconsLoader.loadIcon("/images/RemoveAll16.png")){

        public void run() {
            if (this.isEnabled() && MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)HistoryComponent.this.messages.getTranslation("Clear_history"), (String)HistoryComponent.this.messages.getTranslation("Clear_history_confirmation"))) {
                HistoryComponent.this.historyObjectList.clear();
                HistoryComponent.this.refreshHistoryActions();
                HistoryComponent.this.clearHistory();
            }
        }
    };

    public HistoryComponent(int maxItems) {
        super(null, IconsLoader.loadIcon("/images/ChatHistory16.png"));
        this.setToolTipText(this.messages.getTranslation("History"));
        this.historyObjectList = new LimitedSizeHistoryList(maxItems);
        this.refreshHistoryActions();
    }

    public abstract void historyObjectSelected(H var1);

    protected abstract void saveToDisk(H var1);

    protected abstract void clearHistory();

    public void refreshHistoryActions() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                HistoryComponent.this.clearActions();
                List historyObjects = HistoryComponent.this.historyObjectList.getStoredObjects();
                for (StoredObject historyObject : historyObjects) {
                    HistoryComponent.this.addAction(new HistoryAction(HistoryComponent.this, historyObject));
                }
                if (!historyObjects.isEmpty()) {
                    HistoryComponent.this.addAction(null);
                }
                HistoryComponent.this.addAction(HistoryComponent.this.clearHistoryAction);
                HistoryComponent.this.clearHistoryAction.setEnabled(!historyObjects.isEmpty());
            }
        });
    }

    public final void addHistoryObject(H historyObject) {
        this.addHistoryObject(historyObject, true);
    }

    public final void addHistoryObject(H historyObject, boolean saveToDisk) {
        this.historyObjectList.addAtBeginning(historyObject);
        this.refreshHistoryActions();
        if (saveToDisk) {
            this.saveToDisk(historyObject);
        }
    }

    public List<H> getHistoryObjects() {
        return new ArrayList(this.historyObjectList.getStoredObjects());
    }

    private static class HistoryAction
    extends Action {
        private final H historyObject;
        final /* synthetic */ HistoryComponent this$0;

        public HistoryAction(H historyObject) {
            this.this$0 = var1_1;
            super(historyObject.getName());
            this.setToolTipText(historyObject.getDescription());
            this.historyObject = historyObject;
        }

        public void run() {
            this.this$0.historyObjectSelected(this.historyObject);
        }
    }
}

