/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.preferences;

import com.oxygenxml.positron.api.connector.dto.Pair;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.eclipse.preferences.KeyValueTableModel;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import ro.sync.basic.util.PlatformDetector;

public class KeyValueTablePanel
extends Composite {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private Button editButton;
    private Button addButton;
    private Button deleteButton;
    private KeyValueTableModel model;
    private TableViewer table;

    public KeyValueTablePanel(Composite parent, List<Pair<String, String>> initialItems) {
        super(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.table = this.createTable(initialItems);
        this.createButtonsPanel(this);
    }

    public KeyValueTableModel getModel() {
        return this.model;
    }

    public TableViewer getTable() {
        return this.table;
    }

    private TableViewer createTable(List<Pair<String, String>> initialItems) {
        final TableViewer table = new TableViewer((Composite)this, 68364);
        table.getTable().setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 150;
        data.widthHint = 400;
        data.horizontalSpan = 3;
        table.getControl().setLayoutData((Object)data);
        table.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                Pair el = (Pair)element;
                return columnIndex == 0 ? (String)el.getFirst() : (String)el.getSecond();
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        final TableColumn nameColumn = new TableColumn(table.getTable(), 16384);
        nameColumn.setText(TRANSLATOR.getTranslation("Name"));
        final TableColumn valueColumn = new TableColumn(table.getTable(), 16384);
        valueColumn.setText(TRANSLATOR.getTranslation("Value"));
        table.getTable().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int totalSize = KeyValueTablePanel.getSmartWidth(table.getTable());
                nameColumn.setWidth((int)((double)totalSize * 0.3));
                valueColumn.setWidth((int)((double)totalSize * 0.7));
                table.getTable().removeControlListener((ControlListener)this);
            }
        });
        this.model = new KeyValueTableModel(initialItems);
        table.setContentProvider((IContentProvider)this.model);
        table.setInput(initialItems);
        table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean tableHasSelection = !event.getSelection().isEmpty();
                KeyValueTablePanel.this.editButton.setEnabled(tableHasSelection && table.getTable().isEnabled());
                KeyValueTablePanel.this.deleteButton.setEnabled(tableHasSelection && table.getTable().isEnabled());
            }
        });
        return table;
    }

    private static int getSmartWidth(Table t) {
        int width = t.getSize().x;
        ScrollBar sb = t.getVerticalBar();
        if (sb != null) {
            width -= sb.getSize().x;
        }
        if ((width -= PlatformDetector.isMacOS() ? 10 : 3) < 50) {
            width = 50;
        }
        return width;
    }

    private void createButtonsPanel(Composite parent) {
        this.addButton = SWTUtils.createPushButton(parent, TRANSLATOR.getTranslation("Add") + "...");
        this.addButton.setLayoutData((Object)new GridData(131072, 0, true, false));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddOrEditItemDialog dialog = new AddOrEditItemDialog(e.display.getActiveShell(), true, null, null);
                if (dialog.open() == 0) {
                    String key = dialog.getKey();
                    String value = dialog.getValue();
                    boolean itemAlreadyExist = KeyValueTablePanel.this.model.hasKey(key);
                    if (itemAlreadyExist) {
                        KeyValueTablePanel.this.model.editItem(key, key, value);
                    } else {
                        KeyValueTablePanel.this.model.addItem(dialog.getKey(), dialog.getValue());
                    }
                    KeyValueTablePanel.this.table.setInput(new Object());
                }
            }
        });
        this.editButton = SWTUtils.createPushButton(parent, TRANSLATOR.getTranslation("Edit"));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddOrEditItemDialog dialog;
                int selectedRow = KeyValueTablePanel.this.table.getTable().getSelectionIndex();
                if (selectedRow >= 0 && (dialog = new AddOrEditItemDialog(KeyValueTablePanel.this.getShell(), false, (String)KeyValueTablePanel.this.model.getValueAt(selectedRow).getFirst(), (String)KeyValueTablePanel.this.model.getValueAt(selectedRow).getSecond())).open() == 0) {
                    KeyValueTablePanel.this.model.editItem(selectedRow, dialog.getKey(), dialog.getValue());
                    KeyValueTablePanel.this.table.setInput(new Object());
                    KeyValueTablePanel.this.table.setSelection((ISelection)new StructuredSelection(KeyValueTablePanel.this.model.getValueAt(selectedRow)), true);
                }
            }
        });
        this.editButton.setEnabled(false);
        this.deleteButton = SWTUtils.createPushButton(parent, TRANSLATOR.getTranslation("Delete"));
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectedRow = KeyValueTablePanel.this.table.getTable().getSelectionIndex();
                if (selectedRow >= 0) {
                    String key = (String)KeyValueTablePanel.this.model.getValueAt(selectedRow).getFirst();
                    if (MessageDialog.openQuestion((Shell)KeyValueTablePanel.this.getShell(), (String)TRANSLATOR.getTranslation("Delete_Item"), (String)MessageFormat.format(TRANSLATOR.getTranslation("Delete_Item_Message"), key))) {
                        KeyValueTablePanel.this.model.deleteItem(selectedRow);
                        KeyValueTablePanel.this.table.setInput(new Object());
                        if (selectedRow >= KeyValueTablePanel.this.model.getItems().size()) {
                            --selectedRow;
                        }
                        if (selectedRow >= 0) {
                            KeyValueTablePanel.this.table.setSelection((ISelection)new StructuredSelection(KeyValueTablePanel.this.model.getValueAt(selectedRow)), true);
                        }
                    }
                }
            }
        });
        this.deleteButton.setEnabled(false);
    }

    public List<Pair<String, String>> getItems() {
        return this.model.getItems();
    }

    private class AddOrEditItemDialog
    extends Dialog {
        boolean isAddDialog;
        private Text keyTF;
        private Text valueTF;
        private final String oldKey;
        private final String oldValue;
        private String key;
        private String value;

        public AddOrEditItemDialog(Shell parentShell, boolean isAddDialog, String key, String value) {
            super(parentShell);
            this.isAddDialog = false;
            this.isAddDialog = isAddDialog;
            this.setShellStyle(67696);
            this.oldKey = key;
            this.oldValue = value;
        }

        protected Control createDialogArea(Composite parent) {
            Composite content = (Composite)super.createDialogArea(parent);
            Composite mainPanel = SWTUtils.createGridComposite(content, 2, 0, 0);
            GridData gd = new GridData(4, 0, true, false);
            mainPanel.setLayoutData((Object)gd);
            SWTUtils.createLabel(mainPanel, TRANSLATOR.getTranslation("Name") + ":");
            this.keyTF = SWTUtils.createGridTextField(mainPanel, 300, -1);
            SWTUtils.createLabel(mainPanel, TRANSLATOR.getTranslation("Value") + ":");
            this.valueTF = SWTUtils.createGridTextField(mainPanel, 300, -1);
            if (this.oldKey != null) {
                this.keyTF.setText(this.oldKey);
                this.keyTF.setEditable(false);
            }
            if (this.oldValue != null) {
                this.valueTF.setText(this.oldValue);
                this.valueTF.selectAll();
            }
            return content;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            if (this.isAddDialog) {
                this.getButton(0).setText(TRANSLATOR.getTranslation("Add"));
            }
            this.getButton(0).setEnabled(this.oldKey != null && this.oldValue != null);
            ModifyListener updateOkButtonListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddOrEditItemDialog.this.key = AddOrEditItemDialog.this.keyTF.getText();
                    AddOrEditItemDialog.this.value = AddOrEditItemDialog.this.valueTF.getText();
                    AddOrEditItemDialog.this.getButton(0).setEnabled(AddOrEditItemDialog.this.value != null && !AddOrEditItemDialog.this.value.isEmpty() && AddOrEditItemDialog.this.key != null && !AddOrEditItemDialog.this.key.isEmpty());
                }
            };
            this.keyTF.addModifyListener(updateOkButtonListener);
            this.valueTF.addModifyListener(updateOkButtonListener);
        }

        protected void configureShell(Shell newShell) {
            newShell.setText(TRANSLATOR.getTranslation(this.isAddDialog ? "Add_Item" : "Edit_Item"));
            super.configureShell(newShell);
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        protected void okPressed() {
            if (this.oldKey == null || this.oldValue == null) {
                if (KeyValueTablePanel.this.model.hasKey(this.keyTF.getText())) {
                    if (MessageDialog.openQuestion((Shell)this.getShell(), (String)TRANSLATOR.getTranslation("Add_Item"), (String)MessageFormat.format(TRANSLATOR.getTranslation("Replace_Item_Message"), this.keyTF.getText()))) {
                        super.okPressed();
                    }
                } else {
                    super.okPressed();
                }
            } else if (!this.oldValue.equals(this.valueTF.getText())) {
                super.okPressed();
            } else {
                super.cancelPressed();
            }
        }
    }
}

