/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.preferences;

import com.oxygenxml.positron.api.connector.dto.Pair;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredContentProvider;

final class KeyValueTableModel
implements IStructuredContentProvider {
    public static final int KEY_COLUMN = 0;
    public static final int VALUE_COLUMN = 1;
    public static final int NO_OF_COLUMNS = 2;
    private final List<Pair<String, String>> items = new ArrayList<Pair<String, String>>();

    public KeyValueTableModel(List<Pair<String, String>> initialItems) {
        if (initialItems != null) {
            this.items.addAll(initialItems);
        }
    }

    public Pair<String, String> getValueAt(int index) {
        return this.items.get(index);
    }

    public Object[] getElements(Object inputElement) {
        return this.items.toArray();
    }

    public void clear() {
        this.items.clear();
    }

    public void setItems(List<Pair<String, String>> newItems) {
        this.clear();
        this.items.addAll(newItems);
    }

    public void editItem(int index, String newKey, String newValue) {
        this.items.set(index, (Pair<String, String>)new Pair((Object)newKey, (Object)newValue));
    }

    public void editItem(String oldKey, String newKey, String newValue) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((String)this.items.get(i).getFirst()).equals(oldKey)) continue;
            this.editItem(i, newKey, newValue);
            break;
        }
    }

    public void deleteItem(int index) {
        this.items.remove(index);
    }

    public void addItem(String key, String value) {
        this.items.add((Pair<String, String>)new Pair((Object)key, (Object)value));
    }

    public boolean hasKey(String key) {
        return this.items.stream().anyMatch(item -> ((String)item.getFirst()).equals(key));
    }

    public List<Pair<String, String>> getItems() {
        return this.items;
    }
}

