/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.license;

import com.oxygenxml.positron.core.auth.BrowserOpener;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import com.oxygenxml.positron.plugin.license.AskForLicenseDialogInterface;
import com.oxygenxml.positron.plugin.license.LicenseInfoProvider;
import com.oxygenxml.positron.plugin.license.LicenseRemovedCallback;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AskForLicenseDialog
extends Dialog
implements AskForLicenseDialogInterface {
    private final BrowserOpener browserOpener = new BrowserOpener();
    private static final Translator I18N = Translator.getInstance();
    private Text licenseTextArea = null;
    private String licenseText = null;
    private Button removeButton;
    private Text sgnField = null;
    private LicenseRemovedCallback callback;
    private LicenseInfoProvider licenseInfoProvider;

    public AskForLicenseDialog() {
        super(Display.getDefault().getActiveShell());
        this.setShellStyle(67696);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(I18N.getTranslation("Positron_AI_License_Dialog_Title"));
        super.configureShell(newShell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, I18N.getTranslation("Register"), true).setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public boolean show(LicenseInfoProvider licenseInfoProvider, LicenseRemovedCallback callback) {
        this.licenseInfoProvider = licenseInfoProvider;
        this.callback = callback;
        return this.open() == 0;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createObtainLicenseKeyPanel(composite);
        this.createLicenseTextPanel(composite);
        return composite;
    }

    private void createLicenseTextPanel(Composite parent) {
        Composite licenseTextPanel = SWTUtils.createGridComposite(parent, 2, 0, 0);
        GridData data = new GridData(16384, 0, true, false);
        data.verticalIndent = 10;
        licenseTextPanel.setLayoutData((Object)data);
        SWTUtils.createLabel(licenseTextPanel, I18N.getTranslation("Positron_AI_License_Info")).setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        Button pasteButton = SWTUtils.createPushButton(licenseTextPanel, I18N.getTranslation("Paste"));
        pasteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AskForLicenseDialog.this.licenseTextArea.paste();
            }
        });
        pasteButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.licenseTextArea = SWTUtils.createGridTextField(licenseTextPanel, 770, 500, 260);
        ((GridData)this.licenseTextArea.getLayoutData()).horizontalSpan = 2;
        this.licenseTextArea.addModifyListener(e -> {
            this.licenseText = this.licenseTextArea.getText();
            this.getButton(0).setEnabled(!this.licenseText.isEmpty());
        });
        Label currentSGNLabel = SWTUtils.createLabel(licenseTextPanel, I18N.getTranslation("License_Signature_Label") + ":");
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 2;
        currentSGNLabel.setLayoutData((Object)data);
        this.sgnField = SWTUtils.createGridTextField(licenseTextPanel);
        this.sgnField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sgnField.setEditable(false);
        this.sgnField.setForeground(currentSGNLabel.getForeground());
        String licenseSignature = this.licenseInfoProvider.getLicenseSignature();
        this.sgnField.setText(licenseSignature);
        this.removeButton = SWTUtils.createPushButton(licenseTextPanel, I18N.getTranslation("Remove"));
        this.removeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean wasRemoveOperationConfirmed = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)I18N.getTranslation("Remove_License_Dialog_Title"), (String)I18N.getTranslation("Remove_License_Dialog_Question"));
                if (wasRemoveOperationConfirmed) {
                    AskForLicenseDialog.this.sgnField.setText("");
                    AskForLicenseDialog.this.removeButton.setEnabled(false);
                    AskForLicenseDialog.this.callback.licenseRemoved();
                }
            }
        });
        this.removeButton.setEnabled(!licenseSignature.isBlank());
    }

    public String getLicenseText() {
        return this.licenseText;
    }

    private void createObtainLicenseKeyPanel(Composite parent) {
        Composite licenseTextPanel = SWTUtils.createGridComposite(parent, 2, 0, 0);
        licenseTextPanel.setLayoutData((Object)new GridData(4, 0, true, false));
        Label explanationLabel = SWTUtils.createLabel(licenseTextPanel, I18N.getTranslation("Obtain_license_key_in_following_ways") + ":");
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        explanationLabel.setLayoutData((Object)data);
        SWTUtils.createLabel(licenseTextPanel, "- " + I18N.getTranslation("Request_free_trial_license_key")).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button trialButton = SWTUtils.createPushButton(licenseTextPanel, I18N.getTranslation("Request_trial") + "...");
        trialButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AskForLicenseDialog.this.browserOpener.openWebpage("https://www.oxygenxml.com/ai_positron/register.html#trial-ai-positron-enterprise");
            }
        });
        data = new GridData(4, 0x1000000, false, false);
        data.widthHint = 100;
        trialButton.setLayoutData((Object)data);
        SWTUtils.createLabel(licenseTextPanel, "- " + I18N.getTranslation("Purchase_12_Months_Subscription")).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button buyNowButton = SWTUtils.createPushButton(licenseTextPanel, I18N.getTranslation("Buy_now") + "...");
        buyNowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AskForLicenseDialog.this.browserOpener.openWebpage("https://www.oxygenxml.com/ai_positron/buy.html?licenseType=enterprise");
            }
        });
        data = new GridData(4, 0x1000000, false, false);
        data.widthHint = 100;
        buyNowButton.setLayoutData((Object)data);
    }
}

