/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.completion.author;

import com.oxygenxml.positron.core.interactions.DefaultContentInserterForAuthorPage;
import com.oxygenxml.positron.core.interactions.ReadOnlyController;
import com.oxygenxml.positron.eclipse.completion.PreviewUtil;
import com.oxygenxml.positron.utilities.json.InsertMode;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.IOUtil;
import ro.sync.ecss.extensions.api.AuthorCaretListener;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;

public class ContentInserterForAuthorPage
extends DefaultContentInserterForAuthorPage {
    private static final Logger log = LoggerFactory.getLogger(ContentInserterForAuthorPage.class);
    private MultiPageEditorPart compToFocus;
    private AuthorCaretListener caretListener = caretEvent -> this.removeInsertionHighlight();
    private AuthorDocumentController controller;

    public ContentInserterForAuthorPage(AuthorDocumentController controller, WSAuthorEditorPage authorEditorPage, Consumer<String> errorConsumer, ReadOnlyController readOnlyController) {
        super(controller, authorEditorPage, errorConsumer, readOnlyController);
        this.controller = controller;
        WSEditor parentEditor = authorEditorPage.getParentEditor();
        this.compToFocus = (MultiPageEditorPart)parentEditor.getComponent();
        authorEditorPage.addAuthorCaretListener(this.caretListener);
    }

    public int[] insert(int startOffset, int endOffset, String suggestion, List<InsertMode> insertModes, boolean asMarkup, boolean deleteSelection, boolean isCopilotInsert) {
        int[] toRet = new int[]{-1, -1};
        Display.getDefault().syncExec(() -> {
            int[] insertLocation = super.insert(startOffset, endOffset, suggestion, insertModes, asMarkup, deleteSelection, isCopilotInsert);
            toRet[0] = insertLocation[0];
            toRet[1] = insertLocation[1];
            if (this.compToFocus != null) {
                this.compToFocus.setFocus();
            }
        });
        return toRet;
    }

    public int[] replaceSelectionWithSuggestion(String suggestion, boolean asMarkup, int startOffset, int endOffset, boolean isCopilotReplace) {
        int[] toRet = new int[]{-1, -1};
        Display.getDefault().syncExec(() -> {
            int[] replacePosition = super.replaceSelectionWithSuggestion(suggestion, asMarkup, startOffset, endOffset, isCopilotReplace);
            toRet[0] = replacePosition[0];
            toRet[1] = replacePosition[1];
            if (this.compToFocus != null && suggestion != null) {
                this.compToFocus.setFocus();
            }
        });
        return toRet;
    }

    public void cleanUp() {
        super.cleanUp();
        this.authorPage.removeAuthorCaretListener(this.caretListener);
        this.compToFocus = null;
    }

    public boolean previewReplaceSelectionWithSuggestion(String suggestion, boolean interpretingCompletionAsMarkup, int startOffset, int endOffset) {
        AuthorEditorAccess editorAccess = this.authorPage.getAuthorAccess().getEditorAccess();
        boolean wasModified = editorAccess.isModified();
        String originalContent = null;
        try {
            originalContent = IOUtil.read((Reader)editorAccess.createContentReader()).toString();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.replaceSelectionWithSuggestion(suggestion, interpretingCompletionAsMarkup, startOffset, endOffset, false);
        this.doPreview(originalContent, wasModified);
        return false;
    }

    public boolean previewInsert(int startOffset, int endOffset, String suggestion, List<InsertMode> insertModes, boolean asMarkup, boolean deleteSelection) {
        AuthorEditorAccess editorAccess = this.authorPage.getAuthorAccess().getEditorAccess();
        boolean wasModified = editorAccess.isModified();
        String originalContent = null;
        try {
            originalContent = IOUtil.read((Reader)editorAccess.createContentReader()).toString();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.insert(startOffset, endOffset, suggestion, insertModes, asMarkup, deleteSelection, false);
        this.doPreview(originalContent, wasModified);
        return false;
    }

    private void doPreview(String originalContent, boolean wasModified) {
        try {
            AuthorEditorAccess editorAccess = this.authorPage.getAuthorAccess().getEditorAccess();
            String modifiedContent = IOUtil.read((Reader)editorAccess.createContentReader()).toString();
            PreviewUtil.previewChanges(PreviewUtil.getEditedResource(this.authorPage.getParentEditor()), originalContent, modifiedContent, () -> {
                this.controller.getUndoManager().undo();
                if (!wasModified) {
                    editorAccess.setModified(false);
                }
            });
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.controller.getUndoManager().undo();
        }
    }
}

