/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.completion;

import com.oxygenxml.positron.api.connector.AIConnector;
import com.oxygenxml.positron.connector.AIConnectorConfigsManager;
import com.oxygenxml.positron.connector.api.BuiltInAIConnector;
import com.oxygenxml.positron.connector.api.HttpClientExtraConfigProvider;
import com.oxygenxml.positron.core.AICompletionDetailsProvider;
import com.oxygenxml.positron.core.AICompletionProviderResolver;
import com.oxygenxml.positron.core.AIConnectorConfigurationProvider;
import com.oxygenxml.positron.core.ExternalAICompletionDetailsProvider;
import com.oxygenxml.positron.core.OxyHttpClientExtraConfigProvider;
import com.oxygenxml.positron.core.SingleAIConnectorConfigurationProvider;
import com.oxygenxml.positron.core.engines.EnginesManagerProvider;
import com.oxygenxml.positron.core.responses.ResponseFormatsRepository;
import com.oxygenxml.positron.core.tools.ToolsExecutionHandler;
import com.oxygenxml.positron.core.util.IModelsProvider;
import com.oxygenxml.positron.eclipse.completion.DirectConnectionHelper;
import com.oxygenxml.positron.utilities.functions.IFunctionSignaturesRepository;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.FileLocator;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyDetailsProvider;

public class AICompletionProvidersManager
implements AICompletionProviderResolver {
    private ExternalAICompletionDetailsProvider externalAiCompletionDetailsProvider;
    private AIConnectorConfigsManager connectorsManager;
    private List<WSOptionListener> connectorParamsChangedListeners = new ArrayList<WSOptionListener>();
    private AIConnector currentConnector;
    private ProxyDetailsProvider proxyDetailsProvider;

    public AICompletionProvidersManager(ProxyDetailsProvider proxyDetailsProvider, ToolsExecutionHandler toolsExecutor) {
        this.proxyDetailsProvider = proxyDetailsProvider;
        this.connectorsManager = AIConnectorConfigsManager.getInstance();
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        ResponseFormatsRepository responseFormatsRepository = new ResponseFormatsRepository();
        this.loadConnector();
        Map<String, Object> resolvedParametersForConnector = this.getResolvedParametersForConnector(this.getCurrentConnector());
        this.currentConnector.setResolvedParameters(resolvedParametersForConnector);
        this.externalAiCompletionDetailsProvider = new ExternalAICompletionDetailsProvider((AIConnectorConfigurationProvider)new SingleAIConnectorConfigurationProvider(() -> this.currentConnector, proxyDetailsProvider, (IModelsProvider)EnginesManagerProvider.getInstance().getEnginesManager())){

            public URL resolve(URL url) {
                try {
                    return FileLocator.resolve((URL)url);
                }
                catch (IOException e) {
                    return url;
                }
            }
        };
        this.externalAiCompletionDetailsProvider.setToolsExecutionHandler(toolsExecutor);
        this.externalAiCompletionDetailsProvider.setFunctionSignaturesRepository((IFunctionSignaturesRepository)toolsExecutor.getToolsExecutor());
        this.externalAiCompletionDetailsProvider.setResponseFormatsRepository(responseFormatsRepository);
        optionsStorage.addOptionListener(new WSOptionListener("oxygen.positron.plugin.direct.connector"){

            public void optionValueChanged(WSOptionChangedEvent arg0) {
                AICompletionProvidersManager.this.loadConnector();
                AICompletionProvidersManager.this.updateConnectorParamsListeners();
            }
        });
        this.connectorsManager.getConnectorTypes().forEach(connector -> {
            Map<String, Object> resolvedParams = this.getResolvedParametersForConnector((AIConnector)connector);
            connector.setResolvedParameters(resolvedParams);
        });
        this.updateConnectorParamsListeners();
    }

    private void loadConnector() {
        this.currentConnector = this.getCurrentConnector();
        this.currentConnector.setResolvedParameters(this.getResolvedParametersForConnector(this.currentConnector));
        if (this.currentConnector instanceof BuiltInAIConnector) {
            ((BuiltInAIConnector)this.currentConnector).setHttpClientExtraConfigProvider((HttpClientExtraConfigProvider)new OxyHttpClientExtraConfigProvider(this.proxyDetailsProvider));
        }
    }

    private void updateConnectorParamsListeners() {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        for (WSOptionListener listener : this.connectorParamsChangedListeners) {
            optionsStorage.removeOptionListener(listener);
        }
        AIConnector newConnector = this.getCurrentConnector();
        newConnector.getParametersList().forEach(param -> {
            String paramOptionId = DirectConnectionHelper.computeOptionIdentifier(newConnector, param);
            WSOptionListener newListener = new WSOptionListener(paramOptionId){

                public void optionValueChanged(WSOptionChangedEvent event) {
                    AICompletionProvidersManager.this.loadConnector();
                }
            };
            optionsStorage.addOptionListener(newListener);
            this.connectorParamsChangedListeners.add(newListener);
        });
    }

    public AICompletionDetailsProvider getCurrentCompletionProvider() {
        return this.externalAiCompletionDetailsProvider;
    }

    private AIConnector getCurrentConnector() {
        String selectedConnectorId = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getOption("oxygen.positron.plugin.direct.connector", "open-ai-connector");
        Optional<AIConnector> connector = this.getConnector(selectedConnectorId);
        if (connector.isEmpty()) {
            connector = this.getConnector("open-ai-connector");
        }
        return connector.get();
    }

    private Optional<AIConnector> getConnector(String id) {
        return this.connectorsManager.getConnectorTypes().stream().filter(aiConnector -> id.equals(aiConnector.getConnectorId())).findFirst();
    }

    private Map<String, Object> getResolvedParametersForConnector(AIConnector connector) {
        HashMap<String, Object> resolvedParams = new HashMap<String, Object>();
        connector.getParametersList().forEach(param -> resolvedParams.put(param.getId(), DirectConnectionHelper.getValueForParam(connector, param, false, true)));
        return resolvedParams;
    }

    public AICompletionDetailsProvider getCompletionProviderForModel(AIActionDetails action, String imposedModel) {
        return this.getCurrentCompletionProvider();
    }
}

