/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.chat.favorites;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class AddFavoriteDialog
extends Dialog {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private String favoriteName;
    private boolean shouldStartNewChat;
    private final WSOptionsStorage optionsManager = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();

    public AddFavoriteDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(TRANSLATOR.getTranslation("Add_to_favorites"));
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComposite = (Composite)super.createDialogArea(parent);
        Composite content = SWTUtils.createGridComposite(mainComposite, 2, 0, 5);
        SWTUtils.createLabel(content, TRANSLATOR.getTranslation("Name") + ":");
        final Text favoriteNameField = SWTUtils.createGridTextField(content, 300, -1);
        final Button shouldStartNewChatButton = SWTUtils.createCheckBox(content, TRANSLATOR.getTranslation("Start_New_Chat"));
        this.shouldStartNewChat = Boolean.parseBoolean(this.optionsManager.getOption("oxygen.positron.plugin.favorite.prompts.start.new.chat.default", String.valueOf(Boolean.TRUE)));
        shouldStartNewChatButton.setSelection(this.shouldStartNewChat);
        shouldStartNewChatButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddFavoriteDialog.this.shouldStartNewChat = shouldStartNewChatButton.getSelection();
            }
        });
        GridData data = new GridData(4, 0, true, false);
        data.horizontalSpan = 2;
        data.verticalIndent = 10;
        shouldStartNewChatButton.setLayoutData((Object)data);
        favoriteNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddFavoriteDialog.this.favoriteName = favoriteNameField.getText();
                AddFavoriteDialog.this.getButton(0).setEnabled(!AddFavoriteDialog.this.favoriteName.isBlank());
            }
        });
        return content;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, TRANSLATOR.getTranslation("Add"), true).setToolTipText(TRANSLATOR.getTranslation("Add_to_favorites"));
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        super.okPressed();
        this.optionsManager.setOption("oxygen.positron.plugin.favorite.prompts.start.new.chat.default", String.valueOf(this.shouldStartNewChat));
    }

    public boolean shouldStartNewChat() {
        return this.shouldStartNewChat;
    }

    public String getFavoriteName() {
        return this.favoriteName;
    }
}

