/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.chat;

import com.google.common.base.Optional;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.eclipse.chat.ChatMessageNavigationWidget;
import com.oxygenxml.positron.eclipse.chat.EditableMessagePanel;
import com.oxygenxml.positron.eclipse.utils.CompositeInsideScroll;
import com.oxygenxml.positron.eclipse.utils.IconsLoader;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import com.oxygenxml.positron.plugin.chat.ChatMessageNavigationLevel;
import com.oxygenxml.positron.plugin.chat.ChatMessageResponseWithActionsPanelInterface;
import com.oxygenxml.positron.plugin.chat.MessageUpdater;
import com.oxygenxml.positron.plugin.chat.actions.BranchNavigator;
import java.util.function.Supplier;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class EditableMessageTopSubPanel
extends Composite {
    private MessageUpdater messageUpdater;
    private EditableMessagePanel parentComponent;
    private ToolItem editMessageButton;
    private Image editChatImage = IconsLoader.loadIcon("/images/EditChat16.png").createImage();
    private SourceViewer messageContentTextArea;
    private Button submitEditButton;
    private Button cancelEditButton;
    private Composite submitAndCancelEditPanel;
    private String messageBeforeStartingEdit;
    private boolean isMessageBeingEdited;
    private ChatMessageNavigationWidget chatMessageNavigationWidget;

    public EditableMessageTopSubPanel(final EditableMessagePanel parent, final MessageUpdater messageUpdater, String roleLabelText) {
        super((Composite)parent, 0);
        this.parentComponent = parent;
        this.messageUpdater = messageUpdater;
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        SWTUtils.createLabelBold(this, roleLabelText).setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.chatMessageNavigationWidget = new ChatMessageNavigationWidget(this, new Supplier<BranchNavigator>(){

            @Override
            public BranchNavigator get() {
                return new BranchNavigator(){

                    public void right() {
                        messageUpdater.selectSiblingMessage((ChatMessageResponseWithActionsPanelInterface)parent, true);
                    }

                    public void left() {
                        messageUpdater.selectSiblingMessage((ChatMessageResponseWithActionsPanelInterface)parent, false);
                    }
                };
            }
        });
        GridData data = new GridData(131072, 0x1000000, true, false);
        this.chatMessageNavigationWidget.setLayoutData(data);
        ToolBar tb = new ToolBar((Composite)this, 0x800000);
        tb.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.editMessageButton = new ToolItem(tb, 8);
        this.editMessageButton.setImage(this.editChatImage);
        this.editMessageButton.setToolTipText(Translator.getInstance().getTranslation("Edit"));
        this.editMessageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Optional<EditableMessagePanel> messageThatWasBeingEdited = EditableMessageTopSubPanel.this.getMessageThatWasBeingEdited();
                if (messageThatWasBeingEdited.isPresent()) {
                    ((EditableMessagePanel)((Object)messageThatWasBeingEdited.get())).cancelEdit();
                }
                EditableMessageTopSubPanel.this.isMessageBeingEdited = true;
                EditableMessageTopSubPanel.this.messageBeforeStartingEdit = EditableMessageTopSubPanel.this.messageContentTextArea.getDocument().get();
                EditableMessageTopSubPanel.this.submitAndCancelEditPanel = EditableMessageTopSubPanel.this.createSubmitAndCancelEditPanel();
                EditableMessageTopSubPanel.this.messageContentTextArea.setEditable(true);
                Display.getDefault().asyncExec(() -> {
                    EditableMessageTopSubPanel.this.refreshGUI();
                    EditableMessageTopSubPanel.this.messageContentTextArea.getTextWidget().setFocus();
                });
            }
        });
    }

    public void dispose() {
        this.editChatImage.dispose();
        super.dispose();
    }

    public void updateUiForLevels(ChatMessageNavigationLevel navigationLevel, boolean enabled) {
        this.chatMessageNavigationWidget.updateUiForLevels(navigationLevel, enabled);
        this.editMessageButton.setEnabled(enabled);
    }

    private Composite createSubmitAndCancelEditPanel() {
        Composite buttonsPanel = SWTUtils.createGridComposite(this.parentComponent, 2, 0, 5);
        buttonsPanel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.submitEditButton = SWTUtils.createPushButton(buttonsPanel, Translator.getInstance().getTranslation("Submit"));
        this.submitEditButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.submitEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String editedText = EditableMessageTopSubPanel.this.messageContentTextArea.getDocument().get().trim();
                EditableMessageTopSubPanel.this.messageUpdater.submitEditedMessage((ChatMessageResponseWithActionsPanelInterface)EditableMessageTopSubPanel.this.parentComponent, editedText);
                EditableMessageTopSubPanel.this.refreshGUI();
                EditableMessageTopSubPanel.this.isMessageBeingEdited = false;
            }
        });
        this.cancelEditButton = SWTUtils.createPushButton(buttonsPanel, Translator.getInstance().getTranslation("Cancel"));
        this.cancelEditButton.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.cancelEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditableMessageTopSubPanel.this.cancelEditing();
                EditableMessageTopSubPanel.this.isMessageBeingEdited = false;
            }
        });
        SWTUtils.setBackground(buttonsPanel, this.parentComponent.getBackground());
        this.refreshGUI();
        return buttonsPanel;
    }

    public void cancelEditing() {
        this.messageContentTextArea.getDocument().set(this.messageBeforeStartingEdit);
        this.messageContentTextArea.setEditable(false);
        this.submitAndCancelEditPanel.dispose();
        this.submitAndCancelEditPanel = null;
        this.refreshGUI();
    }

    public String toString() {
        return this.chatMessageNavigationWidget.toString();
    }

    public boolean isMessageBeingEdited() {
        return this.isMessageBeingEdited;
    }

    private Optional<EditableMessagePanel> getMessageThatWasBeingEdited() {
        Control[] components;
        Optional toReturn = Optional.absent();
        for (Control component : components = this.parentComponent.getParent().getChildren()) {
            EditableMessagePanel editableMessagePanel;
            if (!(component instanceof EditableMessagePanel) || !(editableMessagePanel = (EditableMessagePanel)component).isMessageBeingEdited()) continue;
            toReturn = Optional.of((Object)((Object)editableMessagePanel));
            break;
        }
        return toReturn;
    }

    private void refreshGUI() {
        if (!this.parentComponent.isDisposed()) {
            ((CompositeInsideScroll)this.parentComponent.getParent()).forceLayout();
        }
    }

    public void setMessageContentTextArea(SourceViewer messageContentTextArea) {
        this.messageContentTextArea = messageContentTextArea;
    }
}

