/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.chat;

import com.oxygenxml.positron.eclipse.chat.EditableMessageTopSubPanel;
import com.oxygenxml.positron.eclipse.chat.MessagePanel;
import com.oxygenxml.positron.plugin.chat.ChatMessage;
import com.oxygenxml.positron.plugin.chat.ChatMessageResponseWithActionsPanelInterface;
import com.oxygenxml.positron.plugin.chat.MessageUpdater;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditableMessagePanel
extends MessagePanel {
    private static final Logger log = LoggerFactory.getLogger(EditableMessagePanel.class);
    private EditableMessageTopSubPanel editableMessageTopSubPanel;

    public EditableMessagePanel(Composite parent, ChatMessage chatMessage, MessageUpdater updater) {
        super(parent, chatMessage, updater);
        log.info("This is editable...");
        this.editableMessageTopSubPanel.setMessageContentTextArea(this.messageContentTextArea);
    }

    @Override
    protected Control createTopSubComponent() {
        this.editableMessageTopSubPanel = new EditableMessageTopSubPanel(this, this.messageUpdater, this.getRoleLabel());
        return this.editableMessageTopSubPanel;
    }

    public void cancelEdit() {
        if (this.editableMessageTopSubPanel != null) {
            Display.getDefault().syncExec(() -> this.editableMessageTopSubPanel.cancelEditing());
        }
    }

    public void setEditableMessageToolbarEnabled(boolean enabled) {
        if (this.editableMessageTopSubPanel != null) {
            Display.getDefault().syncExec(() -> this.editableMessageTopSubPanel.updateUiForLevels(this.messageUpdater.computeNavigationLevel((ChatMessageResponseWithActionsPanelInterface)this), enabled));
        }
    }

    public boolean isMessageBeingEdited() {
        return this.editableMessageTopSubPanel != null && this.editableMessageTopSubPanel.isMessageBeingEdited();
    }
}

