/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.chat;

import com.oxygenxml.positron.core.actions.ActionInteractor;
import com.oxygenxml.positron.core.actions.types.ReplaceCapableActionInteractor;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.eclipse.chat.ChatResponseActionsPanel;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import com.oxygenxml.positron.eclipse.utils.SwingActionWithSWTActionWrapper;
import com.oxygenxml.positron.plugin.chat.ChatMessageResponseWithActionsPanelInterface;
import com.oxygenxml.positron.plugin.chat.ChatScrollUpdater;
import com.oxygenxml.positron.plugin.chat.MessageUpdater;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.text.BadLocationException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public abstract class ChatMessageResponseWithActionsPanel
extends Composite
implements ChatMessageResponseWithActionsPanelInterface {
    private static final Logger log = LoggerFactory.getLogger(ChatMessageResponseWithActionsPanel.class);
    private static final String CANNOT_EXECUTE_ACTION_REASON = "Cannot execute action. Reason: ";
    private static final PluginWorkspace PLUGIN_WS = PluginWorkspaceProvider.getPluginWorkspace();
    private static final Translator TRANSLATOR = Translator.getInstance();

    public ChatMessageResponseWithActionsPanel(Composite parent) {
        super(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 5;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 0, true, false));
        Display.getDefault().asyncExec(() -> {
            Optional<Color> backgroundColor = this.getBackgroundColor();
            if (backgroundColor.isPresent()) {
                Color bgColor = backgroundColor.get();
                SWTUtils.setBackground(this, bgColor);
            }
        });
    }

    protected Optional<Color> getBackgroundColor() {
        return Optional.ofNullable(Display.getDefault().getSystemColor(25));
    }

    private void updateMenuActions(ActionInteractor actionInteractor) {
        ArrayList<AbstractAction> contextualActions = new ArrayList<AbstractAction>();
        if (actionInteractor != null) {
            boolean isAIResponseIdenticalToInputToBeReplaced = false;
            if (actionInteractor instanceof ReplaceCapableActionInteractor) {
                isAIResponseIdenticalToInputToBeReplaced = ((ReplaceCapableActionInteractor)actionInteractor).isAIResponseIdenticalToInput();
            }
            if (!isAIResponseIdenticalToInputToBeReplaced) {
                if (actionInteractor.canModifyDocument()) {
                    contextualActions.add(this.createInsertOrReplaceAction(actionInteractor));
                }
                if (actionInteractor.canPreviewDocumentModifications()) {
                    contextualActions.add(this.createPreviewAction(actionInteractor));
                }
            }
        }
        contextualActions.add(this.createCopyAction());
        this.setAdditionalMenuActions(contextualActions);
    }

    private AbstractAction createCopyAction() {
        SwingActionWithSWTActionWrapper copyAction = new SwingActionWithSWTActionWrapper(TRANSLATOR.getTranslation("Edit_Copy"), "/images/Copy16.png"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(ChatMessageResponseWithActionsPanel.this.getChatMessageContent()), null);
            }
        };
        ((AbstractAction)copyAction).putValue("ShortDescription", TRANSLATOR.getTranslation("Copy_to_clipboard"));
        return copyAction;
    }

    private AbstractAction createPreviewAction(final ActionInteractor actionInteractor) {
        SwingActionWithSWTActionWrapper previewAction = new SwingActionWithSWTActionWrapper(TRANSLATOR.getTranslation("Preview")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    actionInteractor.previewDocumentModifications(ChatMessageResponseWithActionsPanel.this.getChatMessageContent());
                }
                catch (BadLocationException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                    PLUGIN_WS.showErrorMessage(ChatMessageResponseWithActionsPanel.CANNOT_EXECUTE_ACTION_REASON + ex.getMessage());
                }
            }
        };
        ((AbstractAction)previewAction).putValue("ShortDescription", actionInteractor.getPreviewChangeDescription());
        return previewAction;
    }

    private AbstractAction createInsertOrReplaceAction(final ActionInteractor actionInteractor) {
        SwingActionWithSWTActionWrapper insertOrReplaceAction = new SwingActionWithSWTActionWrapper(actionInteractor.getActionChangeType(), actionInteractor.getActionChangeIconPath()){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    actionInteractor.applyChangesToDocument(ChatMessageResponseWithActionsPanel.this.getChatMessageContent());
                }
                catch (BadLocationException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                    PLUGIN_WS.showErrorMessage(ChatMessageResponseWithActionsPanel.CANNOT_EXECUTE_ACTION_REASON + ex.getMessage());
                }
            }
        };
        ((AbstractAction)insertOrReplaceAction).putValue("ShortDescription", actionInteractor.getActionChangeDescription());
        return insertOrReplaceAction;
    }

    public void updateResponseAccessActions(ActionInteractor actionInteractor, String message, MessageUpdater messageUpdater, ChatScrollUpdater scrollUpdater) {
        this.updateMenuActions(actionInteractor);
        ChatResponseActionsPanel responsePanel = new ChatResponseActionsPanel(actionInteractor, message, this, messageUpdater);
        this.layout();
        Display.getDefault().asyncExec(() -> SWTUtils.scrollToVisible(responsePanel));
    }
}

