/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.chat;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.eclipse.utils.IconsLoader;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import com.oxygenxml.positron.plugin.chat.ChatMessageNavigationLevel;
import com.oxygenxml.positron.plugin.chat.actions.BranchNavigator;
import java.util.function.Supplier;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ChatMessageNavigationWidget
extends Composite {
    private Label messageIndexLabel;
    private boolean currentNextPrevButtonsEnabled;
    private static final Translator TRANSLATOR = Translator.getInstance();
    private ToolItem nextEditButton;
    private Image nextImage = IconsLoader.loadIcon("/images/RightArrow16.png").createImage();
    private ToolItem previousEditButton;
    private Image previousImage = IconsLoader.loadIcon("/images/LeftArrow16.png").createImage();

    public ChatMessageNavigationWidget(Composite parent, final Supplier<BranchNavigator> branchNavigator) {
        super(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        ToolBar prevTB = new ToolBar((Composite)this, 0x800000);
        prevTB.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        this.previousEditButton = new ToolItem(prevTB, 8);
        this.previousEditButton.setImage(this.previousImage);
        this.previousEditButton.setToolTipText(TRANSLATOR.getTranslation("Previous"));
        this.previousEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((BranchNavigator)branchNavigator.get()).left();
            }
        });
        this.messageIndexLabel = SWTUtils.createLabel(this, "0 / 0");
        this.messageIndexLabel.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        ToolBar nextTB = new ToolBar((Composite)this, 0x800000);
        nextTB.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        this.nextEditButton = new ToolItem(nextTB, 8);
        this.nextEditButton.setImage(this.nextImage);
        this.nextEditButton.setToolTipText(TRANSLATOR.getTranslation("Next"));
        this.nextEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((BranchNavigator)branchNavigator.get()).right();
            }
        });
    }

    public void updateUiForLevels(ChatMessageNavigationLevel navigationLevel, boolean enabled) {
        if (this.currentNextPrevButtonsEnabled != enabled) {
            this.currentNextPrevButtonsEnabled = enabled;
            int currentLevel = navigationLevel.getCurrentLevel();
            int maxLevel = navigationLevel.getMaxLevel();
            if (maxLevel == 1) {
                this.setNavigationWidgetVisible(false);
            } else {
                this.setNavigationWidgetVisible(true);
                this.messageIndexLabel.setText(String.format("%d / %d", currentLevel, maxLevel));
                if (enabled) {
                    this.previousEditButton.setEnabled(currentLevel != 1);
                    this.nextEditButton.setEnabled(currentLevel != maxLevel);
                } else {
                    this.previousEditButton.setEnabled(false);
                    this.nextEditButton.setEnabled(false);
                }
            }
        }
    }

    public void setNavigationWidgetVisible(boolean visible) {
        this.previousEditButton.setEnabled(visible);
        this.messageIndexLabel.setVisible(visible);
        this.nextEditButton.setEnabled(visible);
        this.setVisible(visible);
    }

    public void dispose() {
        this.nextImage.dispose();
        this.previousImage.dispose();
        super.dispose();
    }
}

