/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.chat;

import com.oxygenxml.positron.actions.ParamExpanderUIInterface;
import com.oxygenxml.positron.actions.ParamExpanderUIProvider;
import com.oxygenxml.positron.core.AIActionsProvider;
import com.oxygenxml.positron.core.AICompletionDetailsProvider;
import com.oxygenxml.positron.core.AICompletionDetailsProviderFactory;
import com.oxygenxml.positron.core.AICompletionProviderResolver;
import com.oxygenxml.positron.core.actions.MessagePresenter;
import com.oxygenxml.positron.core.actions.ReloadActionsListener;
import com.oxygenxml.positron.core.actions.loader.AdditionalActionsProvider;
import com.oxygenxml.positron.core.chat.ChatInteractor;
import com.oxygenxml.positron.core.engines.EnginesManagerProvider;
import com.oxygenxml.positron.core.engines.IEnginesManager;
import com.oxygenxml.positron.core.interactions.IDocumentCreator;
import com.oxygenxml.positron.core.interactions.IUserInputProvider;
import com.oxygenxml.positron.core.progress.OperationProgressPresenter;
import com.oxygenxml.positron.core.tools.internal.FilesValidator;
import com.oxygenxml.positron.core.tools.internal.TreeAccess;
import com.oxygenxml.positron.core.tools.internal.TreeAccessProvider;
import com.oxygenxml.positron.core.tools.internal.ValidateContentHelperImpl;
import com.oxygenxml.positron.core.util.InvokeActionHelperImpl;
import com.oxygenxml.positron.core.util.PositronOptionsUtil;
import com.oxygenxml.positron.eclipse.Translator;
import com.oxygenxml.positron.eclipse.actions.ECParamExpanderUI;
import com.oxygenxml.positron.eclipse.actions.SWTUiComponentsInteractor;
import com.oxygenxml.positron.eclipse.chat.ChatPanel;
import com.oxygenxml.positron.eclipse.chat.ECMessagePresenter;
import com.oxygenxml.positron.eclipse.chat.project.ECProjectHelper;
import com.oxygenxml.positron.eclipse.completion.AICompletionProvidersManager;
import com.oxygenxml.positron.eclipse.completion.author.CompletionImplementationProviderForAuthorPage;
import com.oxygenxml.positron.eclipse.completion.text.CompletionImplementationProviderForTextPage;
import com.oxygenxml.positron.eclipse.engine.ECEnterpriseEnginesManager;
import com.oxygenxml.positron.eclipse.functions.ECToolsExecutionHandler;
import com.oxygenxml.positron.eclipse.license.AskForLicenseDialog;
import com.oxygenxml.positron.eclipse.recordexamples.StartRecordingDialog;
import com.oxygenxml.positron.eclipse.tools.ECTreeAccess;
import com.oxygenxml.positron.eclipse.utils.NeverShowThisDialog;
import com.oxygenxml.positron.eclipse.view.PositronAssistantView;
import com.oxygenxml.positron.functions.AIFunctionBase;
import com.oxygenxml.positron.functions.SaxonAIFunctionExecutor;
import com.oxygenxml.positron.plugin.EditorChangeListenerBase;
import com.oxygenxml.positron.plugin.EnablePositronController;
import com.oxygenxml.positron.plugin.assist.EmbeddedAssistantInstaller;
import com.oxygenxml.positron.plugin.chat.favorites.NewChatStarter;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.framework.CatalogUtils;
import com.oxygenxml.positron.plugin.license.DirectConnectionLicenseManager;
import com.oxygenxml.positron.plugin.recordexamples.EditorRecorder;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelper;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.InvokeActionHelper;
import com.oxygenxml.positron.utilities.functions.InvokeActionHelperProvider;
import com.oxygenxml.positron.utilities.functions.ValidateContentHelper;
import com.oxygenxml.positron.utilities.functions.ValidateContentHelperProvider;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.workspace.api.eclipse.EclipsePluginWorkspace;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.AuthorCaretListener;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.listeners.WSEditorChangeListener;
import ro.sync.exml.workspace.api.listeners.WSEditorListener;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyConnectionInfo;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyDetailsProvider;

public class ChatConfigurator {
    private static final Logger log = LoggerFactory.getLogger(ChatConfigurator.class);
    private static com.oxygenxml.positron.core.plugin.Translator TRANSLATOR = Translator.getInstance();
    private ECToolsExecutionHandler toolsExecutor;
    private AICompletionProvidersManager aiCompletionProviderManager;
    private CompletionActionsManager completionActionsManager;
    private final EmbeddedAssistantInstaller embeddedAssistantInstaller = new EmbeddedAssistantInstaller();
    private Boolean positronEnabledCurrentState;
    private static ChatConfigurator instance = null;
    private ChatPanel chatPanel;
    private EclipsePluginWorkspace pluginWorkspace;
    private PositronAssistantView positronView;

    public static ChatConfigurator getInstance() {
        if (instance == null) {
            instance = new ChatConfigurator();
        }
        return instance;
    }

    private ChatConfigurator() {
    }

    public void setChatPanel(ChatPanel chatPanel) {
        this.chatPanel = chatPanel;
        if (this.pluginWorkspace != null && this.positronView != null) {
            this.doConfigure(this.positronView, chatPanel, this.pluginWorkspace);
        }
    }

    public void setPositronView(PositronAssistantView positronView) {
        this.positronView = positronView;
        if (this.pluginWorkspace != null && this.chatPanel != null) {
            this.doConfigure(positronView, this.chatPanel, this.pluginWorkspace);
        }
    }

    public void setPluginWorkspace(EclipsePluginWorkspace pluginWorkspace) {
        this.pluginWorkspace = pluginWorkspace;
        if (this.chatPanel != null && this.positronView != null) {
            this.doConfigure(this.positronView, this.chatPanel, pluginWorkspace);
        }
    }

    private void doConfigure(final PositronAssistantView positronView, final ChatPanel chatPanel, final EclipsePluginWorkspace pluginWorkspace) {
        log.debug("Do configure");
        FunctionsAndRAGHelperProvider.setProjectRAGHelper((FunctionsAndRAGHelper)new ECProjectHelper());
        ParamExpanderUIProvider.setParamExpanderUI((ParamExpanderUIInterface)new ECParamExpanderUI());
        TreeAccessProvider.setTreeAccess((TreeAccess)new ECTreeAccess());
        DirectConnectionLicenseManager.setAskForLicensDialogProvider(() -> new AskForLicenseDialog());
        final EditorChangeListener editorChangeListener = new EditorChangeListener((PluginWorkspace)pluginWorkspace);
        pluginWorkspace.addEditorChangeListener((WSEditorChangeListener)editorChangeListener, 0);
        pluginWorkspace.getOptionsStorage().addOptionListener(new WSOptionListener("oxygen.positron.plugin.retrieval.sandbox.rag"){

            public void optionValueChanged(WSOptionChangedEvent event) {
                positronView.selectionChanged(editorChangeListener.hasSelection());
            }
        });
        ProxyDetailsProvider proxyDetailsProvider = new ProxyDetailsProvider(){

            public ProxyConnectionInfo getProxyConnectionInfo(URL url) {
                IProxyData[] proxyDatas = ProxyManager.getProxyManager().getProxyDataForHost(url.toExternalForm());
                String protocol = url.getProtocol();
                if (proxyDatas != null && proxyDatas.length != 0) {
                    IProxyData iData = proxyDatas[0];
                    for (IProxyData iProxyData : proxyDatas) {
                        if (!protocol.equalsIgnoreCase(iProxyData.getType())) continue;
                        iData = iProxyData;
                        break;
                    }
                    final IProxyData finalData = iData;
                    return new ProxyConnectionInfo(){

                        public String getUsername() {
                            return finalData.getUserId();
                        }

                        public int getPort() {
                            return finalData.getPort();
                        }

                        public String getPassword() {
                            return finalData.getPassword();
                        }

                        public String getHost() {
                            return finalData.getHost();
                        }
                    };
                }
                return null;
            }
        };
        this.toolsExecutor = new ECToolsExecutionHandler();
        ECEnterpriseEnginesManager enginesManager = new ECEnterpriseEnginesManager();
        EnginesManagerProvider.getInstance().setEnginesManager((IEnginesManager)enginesManager);
        this.aiCompletionProviderManager = new AICompletionProvidersManager(proxyDetailsProvider, this.toolsExecutor);
        this.completionActionsManager = new CompletionActionsManager((PluginWorkspace)pluginWorkspace, (MessagePresenter)new ECMessagePresenter(positronView.getOperationsStatusPresenter()), (ChatInteractor)chatPanel, (AICompletionProviderResolver)this.aiCompletionProviderManager, (OperationProgressPresenter)positronView.getOperationsStatusPresenter(), new AdditionalActionsProvider(), new IUserInputProvider(){

            public String askUserForInput(String dialogTitle, String dialogDescription, String hintText, String okButtonText, String initialContent, boolean selectInitialContent) {
                return SWTUiComponentsInteractor.getPromptFromUser(chatPanel.getShell(), dialogTitle, dialogDescription, hintText, okButtonText, initialContent, selectInitialContent);
            }
        }, new IDocumentCreator(){

            public URL createNewEditor(String extension, String contentType, String content) {
                return SWTUiComponentsInteractor.createNewEditor(extension, contentType, content);
            }
        }, null);
        this.completionActionsManager.addReloadActionListener(new ReloadActionsListener(){

            public void actionsReloaded() {
                ChatConfigurator.this.embeddedAssistantInstaller.refreshActions();
            }
        });
        EnablePositronController enablePositronController = new EnablePositronController(){

            public void reconfigurePositronUIComponents() {
                ChatConfigurator.this.reconfigurePositronUIComponents((PluginWorkspace)pluginWorkspace);
            }
        };
        positronView.initPositronPanel((PluginWorkspace)pluginWorkspace, proxyDetailsProvider, this.completionActionsManager, chatPanel, enablePositronController);
        this.chatPanel.updateCompletionDetailsProvider(this.aiCompletionProviderManager.getCurrentCompletionProvider());
        NewChatStarter chatStarter = () -> Display.getDefault().asyncExec(() -> {
            chatPanel.clearChat();
            chatPanel.showView(true);
        });
        chatPanel.getFavoritesManager().setNewChatCreator(chatStarter);
        this.embeddedAssistantInstaller.setNewChatCreator(chatStarter);
        chatPanel.setCompletionActionsManager(this.completionActionsManager);
        AIFunctionBase.setOpenAiFunctionExecutor((SaxonAIFunctionExecutor)new SaxonAIFunctionExecutor(){

            protected boolean showConfirmDialog(int requestsNumberToNotify) {
                boolean[] b = new boolean[1];
                Display.getDefault().syncExec(() -> {
                    NeverShowThisDialog dialog = new NeverShowThisDialog(Display.getDefault().getActiveShell(), TRANSLATOR.getTranslation("XPath_functions_usage_information"), MessageFormat.format(TRANSLATOR.getTranslation("XPath_functions_sent_requests"), requestsNumberToNotify), 3);
                    b[0] = dialog.open() == 0;
                    pluginWorkspace.getOptionsStorage().setOption("oxygen.positron.plugin.never.ask.again.functions.requests", String.valueOf(dialog.getNeverShowThisAgain()));
                });
                return b[0];
            }
        });
        AICompletionDetailsProviderFactory complDetailsProviderFactory = new AICompletionDetailsProviderFactory(){

            public AICompletionDetailsProvider retrieveCompletionDetailsProvider(AIActionDetails action, Map<String, Object> parameters) throws IOException {
                return ChatConfigurator.this.aiCompletionProviderManager.getCurrentCompletionProvider();
            }

            public List<AIActionDetails> getAIActionDetails(Map<String, Object> parameters) throws IOException {
                return ChatConfigurator.this.completionActionsManager.getCompletionActionsDetails();
            }

            public List<AIActionDetails> getAIAgentDetails(Map<String, Object> parameters) throws IOException {
                return null;
            }
        };
        InvokeActionHelperProvider.setInvokeActionHelper((InvokeActionHelper)new InvokeActionHelperImpl(complDetailsProviderFactory, (AIActionsProvider)this.completionActionsManager));
        EditorRecorder.setStartRecordingDialogProvider(() -> new StartRecordingDialog());
        if (FilesValidator.allowsValidationWithCustomContent()) {
            ValidateContentHelperProvider.setInvokeActionHelper((ValidateContentHelper)new ValidateContentHelperImpl());
        }
        this.reconfigurePositronUIComponents((PluginWorkspace)pluginWorkspace);
        CatalogUtils.registerActionsJSONSchemaURIResolver((PluginWorkspace)pluginWorkspace);
        log.debug("Configured...");
    }

    private void reconfigurePositronUIComponents(PluginWorkspace pluginWorkspaceAccess) {
        if (PositronOptionsUtil.isPositronEnabled()) {
            if (this.positronEnabledCurrentState == null || !this.positronEnabledCurrentState.booleanValue()) {
                this.enablePositron(pluginWorkspaceAccess);
            }
        } else if (this.positronEnabledCurrentState == null || this.positronEnabledCurrentState.booleanValue()) {
            this.disablePositron(pluginWorkspaceAccess);
        }
        this.positronEnabledCurrentState = PositronOptionsUtil.isPositronEnabled();
    }

    private void disablePositron(PluginWorkspace pluginWorkspaceAccess) {
    }

    private void enablePositron(PluginWorkspace pluginWorkspaceAccess) {
    }

    private class EditorChangeListener
    extends EditorChangeListenerBase {
        private CompletionImplementationProviderForAuthorPage authorCompletionImplProvider;
        private CompletionImplementationProviderForTextPage textPageCompletionImplProvider;
        private Map<String, WSEditorListener> addedEditorListeners;
        private AuthorCaretListener authorCaretListener;
        private CaretListener textCaretListener;

        private EditorChangeListener(PluginWorkspace pluginWorkspace) {
            super(pluginWorkspace);
            this.addedEditorListeners = new HashMap<String, WSEditorListener>();
        }

        protected void doHook(WSAuthorEditorPage authorEditorPage) {
            AuthorDocumentController controller = authorEditorPage.getAuthorAccess().getDocumentController();
            this.authorCompletionImplProvider = new CompletionImplementationProviderForAuthorPage(controller, authorEditorPage);
            ChatConfigurator.this.positronView.setCompletionImplementationProvider(this.authorCompletionImplProvider);
            ChatConfigurator.this.toolsExecutor.setDocumentContentExtractor(this.authorCompletionImplProvider.getPrefixExtractor());
            if (PositronOptionsUtil.isPositronEnabled()) {
                this.authorCaretListener = caretEvent -> {
                    boolean isContentSelected = authorEditorPage.hasSelection();
                    ChatConfigurator.this.positronView.selectionChanged(isContentSelected);
                };
                authorEditorPage.addAuthorCaretListener(this.authorCaretListener);
            }
        }

        protected void doHook(WSTextEditorPage textEditorPage) {
            this.textPageCompletionImplProvider = new CompletionImplementationProviderForTextPage(textEditorPage);
            ChatConfigurator.this.positronView.setCompletionImplementationProvider(this.textPageCompletionImplProvider);
            ChatConfigurator.this.toolsExecutor.setDocumentContentExtractor(this.textPageCompletionImplProvider.getPrefixExtractor());
            if (PositronOptionsUtil.isPositronEnabled()) {
                StyledText jta = (StyledText)textEditorPage.getTextComponent();
                this.textCaretListener = caretEvent -> ChatConfigurator.this.positronView.selectionChanged(jta.getSelection().x != jta.getSelection().y);
                jta.addCaretListener(this.textCaretListener);
            }
        }

        protected void doUnhook(WSAuthorEditorPage authorEditorPage) {
            if (this.authorCompletionImplProvider != null) {
                this.authorCompletionImplProvider.getCompletionInserter().cleanUp();
                this.authorCompletionImplProvider.getPrefixExtractor().cleanUp();
                this.authorCompletionImplProvider = null;
            }
            if (this.authorCaretListener != null) {
                authorEditorPage.removeAuthorCaretListener(this.authorCaretListener);
            }
            ChatConfigurator.this.positronView.setCompletionImplementationProvider(null);
            ChatConfigurator.this.toolsExecutor.setDocumentContentExtractor(null);
        }

        protected void doUnhook(WSTextEditorPage hookedPage) {
            if (this.textPageCompletionImplProvider != null) {
                this.textPageCompletionImplProvider.getCompletionInserter().cleanUp();
                this.textPageCompletionImplProvider.getPrefixExtractor().cleanUp();
                this.textPageCompletionImplProvider = null;
            }
            if (this.textCaretListener != null) {
                StyledText jta = (StyledText)hookedPage.getTextComponent();
                jta.removeCaretListener(this.textCaretListener);
            }
            ChatConfigurator.this.positronView.setCompletionImplementationProvider(null);
            ChatConfigurator.this.toolsExecutor.setDocumentContentExtractor(null);
        }

        public void editorOpened(URL editorLocation) {
            final WSEditor editor = this.pluginWorkspaceAccess.getEditorAccess(editorLocation, 0);
            if (editor != null) {
                boolean isLocalJsonOrTextEditor;
                String editorContentType = this.pluginWorkspaceAccess.getUtilAccess().getContentType(editorLocation.toExternalForm());
                boolean bl = isLocalJsonOrTextEditor = URLUtil.isFromLocalDrive((URL)editorLocation) && editorContentType != null && (editorContentType.toLowerCase().contains("json") || "text/plain".equals(editorContentType) || "text/markdown".equals(editorContentType));
                if (isLocalJsonOrTextEditor) {
                    WSEditorListener wsEditorListener = new WSEditorListener(){

                        public void editorSaved(int operationType) {
                            ChatConfigurator.this.positronView.getAssistantController().localFileSaved(editor.getEditorLocation());
                        }
                    };
                    editor.addEditorListener(wsEditorListener);
                    this.addedEditorListeners.put(editor.getEditorLocation().toExternalForm(), wsEditorListener);
                }
            }
        }

        public boolean editorAboutToBeClosed(URL editorLocation) {
            WSEditor editor = this.pluginWorkspaceAccess.getEditorAccess(editorLocation, 0);
            if (editor != null && this.addedEditorListeners.containsKey(editorLocation.toExternalForm())) {
                editor.removeEditorListener(this.addedEditorListeners.get(editorLocation.toExternalForm()));
            }
            return super.editorAboutToBeClosed(editorLocation);
        }

        private boolean hasSelection() {
            boolean hasSelection = false;
            if (this.authorCompletionImplProvider != null) {
                hasSelection = this.authorCompletionImplProvider.getPrefixExtractor().hasSelection();
            } else if (this.textPageCompletionImplProvider != null) {
                hasSelection = this.textPageCompletionImplProvider.getPrefixExtractor().hasSelection();
            }
            return hasSelection;
        }
    }
}

