/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.actions;

import com.oxygenxml.positron.actions.dialog.GenerateNewDocumentContentHandler;
import com.oxygenxml.positron.actions.dialog.SessionStorage;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import com.oxygenxml.workspace.api.eclipse.OxygenEclipseUIComponentsFactory;
import java.util.Optional;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SWTPromptUserDialog
extends Dialog
implements GenerateNewDocumentContentHandler {
    private final String currentTitle;
    private SourceViewer text;
    private final String hintText;
    private static final String FALLBACK_TITLE = "Generate Document";
    private static final String FALLBACK_DESCRIPTION = "Generate a new document from the content provided below.";
    private String okButtonText;
    private String textContent;
    private String initialContent;
    private boolean selectInitialContent;

    public SWTPromptUserDialog(Shell parentShell, String dialogTitle, String dialogDescription, String hintButtonText, String okButtonText) {
        super(parentShell);
        this.setShellStyle(67696);
        this.okButtonText = okButtonText;
        this.currentTitle = Optional.ofNullable(dialogTitle).orElse(FALLBACK_TITLE);
        this.hintText = String.format("%s\n" + hintButtonText, Optional.ofNullable(dialogDescription).orElse(FALLBACK_DESCRIPTION));
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.currentTitle);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = (Composite)super.createDialogArea(parent);
        content.setLayout((Layout)new GridLayout(1, false));
        SWTUtils.createGridMultiLineLabel(content, 500, -1, 1).setText(this.hintText);
        this.text = OxygenEclipseUIComponentsFactory.createSourceViewer((Composite)content, (String)"text/xml", (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)true);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 500;
        data.heightHint = 200;
        this.text.getTextWidget().setLayoutData((Object)data);
        this.text.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SWTPromptUserDialog.this.updateOkButtonState();
            }
        });
        Display.getDefault().asyncExec(() -> {
            String last = SessionStorage.getInstance().getValue("key.user.input.generate.file" + this.currentTitle.hashCode());
            if (last != null) {
                this.text.getDocument().set(last);
                this.text.getTextWidget().selectAll();
            } else if (this.initialContent != null && !this.initialContent.trim().isEmpty()) {
                this.text.getDocument().set(this.initialContent);
                if (this.selectInitialContent) {
                    this.text.getTextWidget().selectAll();
                }
            }
            this.text.refresh();
            this.updateOkButtonState();
        });
        return content;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.okButtonText, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void showDialog(String initialContent, boolean selectInitialContent) {
        this.initialContent = initialContent;
        this.selectInitialContent = selectInitialContent;
        this.open();
    }

    protected void okPressed() {
        this.textContent = this.text.getDocument().get();
        SessionStorage.getInstance().setValue("key.user.input.generate.file" + this.currentTitle.hashCode(), this.textContent);
        super.okPressed();
    }

    public String getUserInput() {
        return this.textContent;
    }

    private void updateOkButtonState() {
        String content = this.text.getDocument().get();
        this.getButton(0).setEnabled(content != null && !content.trim().isEmpty());
    }
}

