/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.actions;

import com.oxygenxml.positron.actions.ParamExpanderUIInterface;
import com.oxygenxml.positron.actions.RecentlyUsedActionsOptionsStorageUtil;
import com.oxygenxml.positron.core.actions.ParamsExpander;
import com.oxygenxml.positron.core.actions.PositronActionConfigurationResult;
import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.eclipse.utils.ComboWithViewer;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import com.oxygenxml.positron.eclipse.utils.StringLabelProvider;
import com.oxygenxml.positron.utilities.json.ActionParam;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class ECParamExpanderUI
implements ParamExpanderUIInterface {
    public synchronized PositronActionConfigurationResult configureAction(PositronAIActionBase action, List<ActionParam> actionParams, boolean wasConfigurationStartedByActionExecution) {
        HashMap<String, Set<String>> chosenValsTotal = new HashMap<String, Set<String>>();
        ParamDialog pd = new ParamDialog(SWTUtils.getShell(), action, actionParams, chosenValsTotal);
        PositronActionConfigurationResult result = PositronActionConfigurationResult.CANCELLED;
        if (pd.open() == 0) {
            result = PositronActionConfigurationResult.DONE;
            ParamsExpander.storeActionParams((String)action.getActionDetails().getId(), chosenValsTotal);
            if (!wasConfigurationStartedByActionExecution) {
                action.actionPerformed(false);
            } else {
                RecentlyUsedActionsOptionsStorageUtil.addToRecentlyUsedInfoAboutActionThatStartsWithConfiguration((String)action.getActionDetails().getId(), chosenValsTotal);
            }
        }
        return result;
    }

    private class ParamDialog
    extends Dialog {
        private String actionName;
        private String actionID;
        private List<ActionParam> actionParams;
        private Map<String, Set<String>> chosenValsTotal;

        public ParamDialog(Shell parent, PositronAIActionBase action, List<ActionParam> actionParams, Map<String, Set<String>> chosenValsTotal) {
            super(parent);
            this.chosenValsTotal = new HashMap<String, Set<String>>();
            this.actionParams = actionParams;
            this.chosenValsTotal = chosenValsTotal;
            this.actionName = action.getActionDetails().getShortDescription();
            this.actionID = action.getActionDetails().getId();
        }

        protected void configureShell(Shell newShell) {
            newShell.setText(this.actionName);
            super.configureShell(newShell);
        }

        protected int getShellStyle() {
            return 66800;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Group mainPanel = SWTUtils.createGridGroup(composite, 0, 2);
            mainPanel.setLayoutData((Object)new GridData(4, 0, true, false));
            for (ActionParam actionParam : this.actionParams) {
                this.buildParamUI((Composite)mainPanel, this.actionID, this.chosenValsTotal, actionParam);
            }
            return composite;
        }

        private void buildParamUI(Composite mainPanel, String actionID, Map<String, Set<String>> chosenValsTotal, ActionParam actionParam) {
            String[] vals = actionParam.getAlternateValues();
            if (vals == null) {
                vals = new String[]{};
            }
            String[] labels = actionParam.getAlternateValueLabels();
            LinkedHashSet<String> chosenVals = new LinkedHashSet<String>();
            chosenValsTotal.put(actionParam.getName(), chosenVals);
            LinkedHashSet<String> initialValuesSet = new LinkedHashSet<String>();
            String initialVals = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getOption("oxygen.positron.plugin." + actionID + "###---####" + actionParam.getName(), "");
            if (!initialVals.isEmpty()) {
                initialValuesSet.addAll(Arrays.asList(initialVals.split("###---####")));
                chosenVals.addAll(initialValuesSet);
            }
            String labelVal = actionParam.getLabel() != null ? actionParam.getLabel() : actionParam.getName();
            SWTUtils.createLabel(mainPanel, labelVal + ":");
            String choiceType = actionParam.getChoiceType();
            if ("editable-combo-choice".equals(choiceType)) {
                this.createEditableComboBox(mainPanel, vals, chosenVals);
            } else {
                for (int i = 0; i < vals.length; ++i) {
                    this.createButton(mainPanel, actionParam, vals[i], labels != null && labels.length > i ? labels[i] : vals[i], chosenVals, initialValuesSet);
                }
            }
        }

        private void createEditableComboBox(Composite parent, String[] vals, final Set<String> chosenVals) {
            final ComboWithViewer comboBox = new ComboWithViewer(parent, 4);
            GridData data = new GridData(4, 0, true, false);
            data.widthHint = 300;
            data.heightHint = -1;
            comboBox.setLayoutData(data);
            comboBox.getComboViewer().setLabelProvider((IBaseLabelProvider)new StringLabelProvider());
            comboBox.getComboViewer().setContentProvider((IContentProvider)new ArrayContentProvider());
            comboBox.getComboViewer().setInput((Object)vals);
            Iterator<String> chosenActionsIterator = chosenVals.iterator();
            if (chosenActionsIterator.hasNext()) {
                comboBox.getComboViewer().setSelection((ISelection)new StructuredSelection((Object)chosenActionsIterator.next()), true);
            } else if (comboBox.getItemCount() > 0) {
                comboBox.select(0);
                chosenVals.clear();
                chosenVals.add(comboBox.getItem(0));
            }
            comboBox.getComboViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    chosenVals.clear();
                    if (!event.getSelection().isEmpty()) {
                        chosenVals.add((String)comboBox.getComboViewer().getStructuredSelection().getFirstElement());
                    }
                }
            });
            comboBox.addModifyListener(e -> {
                chosenVals.clear();
                chosenVals.add(comboBox.getText());
            });
        }

        private Button createButton(Composite parent, ActionParam actionParam, final String value, String label, final Set<String> chosenVals, Set<String> initialValuesSet) {
            Button button;
            if ("single-choice".equals(actionParam.getChoiceType())) {
                button = SWTUtils.createRadioButton(parent, label);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        chosenVals.clear();
                        chosenVals.add(value);
                    }
                });
            } else {
                button = SWTUtils.createCheckBox(parent, label);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (button.getSelection()) {
                            chosenVals.add(value);
                        } else {
                            chosenVals.remove(value);
                        }
                    }
                });
            }
            if (initialValuesSet.contains(value) || "single-choice".equals(actionParam.getChoiceType()) && initialValuesSet.isEmpty() && value != null && value.equals(actionParam.getValue())) {
                button.setSelection(true);
            }
            return button;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, Translator.getInstance().getTranslation("Save_and_execute"), true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }
}

