/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.actions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.oxygenxml.positron.actions.AIActionsUtil;
import com.oxygenxml.positron.actions.RecentlyUsedActionsOptionsStorageUtil;
import com.oxygenxml.positron.core.actions.ReloadActionsListener;
import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.interactions.ContentInserter;
import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.eclipse.recordexamples.InstructionsSaver;
import com.oxygenxml.positron.eclipse.utils.IconsLoader;
import com.oxygenxml.positron.eclipse.utils.PopupMenuAction;
import com.oxygenxml.positron.plugin.chat.ChatImporterExporter;
import com.oxygenxml.positron.plugin.chat.ChatModel;
import com.oxygenxml.positron.plugin.chat.actions.importexport.ImportExportChatUtil;
import com.oxygenxml.positron.plugin.chat.history.UnknownActionToImportException;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.recordexamples.EditorRecorder;
import com.oxygenxml.positron.plugin.recordexamples.InstructionsWithExamples;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.FileSystemUtil;
import ro.sync.basic.io.IOUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.basic.xml.encoding.EncodingDetectorInterface;
import ro.sync.ecss.extensions.api.CancelledByUserException;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.xml.encoding.EncodingDetector;

public class AIActionsPopup
extends PopupMenuAction
implements ReloadActionsListener {
    private static final Logger log = LoggerFactory.getLogger(AIActionsPopup.class);
    private static final Translator TRANSLATOR = Translator.getInstance();
    private CompletionActionsManager completionActionsManager;
    private Action recordChangesAction;
    private Action exportChatAction;
    private Action importChatAction;
    private ChatImporterExporter chatImportExportHelper;

    public AIActionsPopup() {
        super(TRANSLATOR.getTranslation("Actions"), null);
    }

    public void initPopup(CompletionActionsManager completionActionsManager, PluginWorkspace pluginWS, InstructionsSaver instructionsSaver, ChatImporterExporter chatImportExportHelper) {
        this.completionActionsManager = completionActionsManager;
        this.completionActionsManager.addReloadActionListener((ReloadActionsListener)this);
        this.chatImportExportHelper = chatImportExportHelper;
        this.recordChangesAction = this.createRecordChangesAction(pluginWS, instructionsSaver);
        this.exportChatAction = this.createExportConversationAction();
        this.exportChatAction.setEnabled(false);
        if (chatImportExportHelper != null) {
            chatImportExportHelper.setChatPanelMessagesVisibilityListener(areMesagesShown -> this.exportChatAction.setEnabled(areMesagesShown));
        }
        this.importChatAction = this.createImportConversationAction();
    }

    @Override
    public List<Object> repopulateActionsList(List<Object> existingActions) {
        existingActions.clear();
        if (this.completionActionsManager != null) {
            List completionActions = this.completionActionsManager.getCompletionActions();
            Map groupedActions = AIActionsUtil.groupActionByCategory((List)completionActions);
            if (!groupedActions.isEmpty()) {
                for (String category : groupedActions.keySet()) {
                    MenuManager categoryMenu = new MenuManager(category);
                    existingActions.add(categoryMenu);
                    List actionsList = (List)groupedActions.get(category);
                    for (PositronAIActionBase action : actionsList) {
                        Action actionItem = this.createActionMenuItem(action);
                        categoryMenu.add((IAction)actionItem);
                    }
                }
                existingActions.add(null);
            }
            existingActions.add(this.recordChangesAction);
            this.addRecentUsedActions(existingActions, completionActions);
        }
        existingActions.add(null);
        existingActions.add(this.exportChatAction);
        existingActions.add(this.importChatAction);
        return existingActions;
    }

    private Action createImportConversationAction() {
        return new Action(TRANSLATOR.getTranslation("Import_Conversation") + "..."){

            public void run() {
                String[] extensions = new String[]{"json"};
                File chooseFile = PluginWorkspaceProvider.getPluginWorkspace().chooseFile(TRANSLATOR.getTranslation("Import_Conversation"), extensions, TRANSLATOR.getTranslation("Import_Conversation_Filter_Description"));
                if (chooseFile == null) {
                    return;
                }
                try {
                    EncodingDetectorInterface encodingDetector = EncodingDetector.getInstance();
                    String contentType = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().getContentType(URLUtil.correct((File)chooseFile).toString());
                    String javaEncoding = encodingDetector.getJavaEncodingFromContentType(contentType);
                    Charset charset = Charset.forName(javaEncoding);
                    if ("json".equals(FileSystemUtil.getExtension((String)chooseFile.getName()))) {
                        String importConversationFileContent = Files.readString(Paths.get(chooseFile.toURI()), charset);
                        ChatModel newChatModelFromJSON = ImportExportChatUtil.newChatModelFromJSON((String)importConversationFileContent, (CompletionActionsManager)AIActionsPopup.this.completionActionsManager);
                        AIActionsPopup.this.chatImportExportHelper.importChat(newChatModelFromJSON);
                    }
                }
                catch (JsonProcessingException e1) {
                    AIActionsPopup.this.showErrorDialogToUser((IOException)((Object)e1), TRANSLATOR.getTranslation("Import_Conversation"), TRANSLATOR.getTranslation("Import_Conversation_JSON_Error"));
                }
                catch (UnknownActionToImportException e1) {
                    String formattedMessage = MessageFormat.format(TRANSLATOR.getTranslation("Import_Conversation_Action_Not_Found_Error"), e1.getInvalidActionID());
                    AIActionsPopup.this.showErrorDialogToUser((IOException)((Object)e1), TRANSLATOR.getTranslation("Import_Conversation"), formattedMessage);
                }
                catch (IOException e1) {
                    AIActionsPopup.this.showErrorDialogToUser(e1, TRANSLATOR.getTranslation("Import_Conversation"), TRANSLATOR.getTranslation("Import_Conversation_Error"));
                }
            }
        };
    }

    private Action createExportConversationAction() {
        return new Action(TRANSLATOR.getTranslation("Export_Conversation") + "..."){

            public void run() {
                String[] extensions = new String[]{"json"};
                try {
                    File exportFile = PluginWorkspaceProvider.getPluginWorkspace().chooseFile(TRANSLATOR.getTranslation("Export_Conversation"), extensions, TRANSLATOR.getTranslation("Export_Conversation_Filter_Description"), true);
                    if (exportFile != null) {
                        String exportedChatModel = ImportExportChatUtil.serializeChatModelAsJSON((ChatModel)AIActionsPopup.this.chatImportExportHelper.getChatModel());
                        IOUtil.saveInURLWithUTF8((URL)exportFile.toURI().toURL(), (String)exportedChatModel);
                        PluginWorkspaceProvider.getPluginWorkspace().open(exportFile.toURI().toURL(), "Text");
                    }
                }
                catch (IOException e1) {
                    AIActionsPopup.this.showErrorDialogToUser(e1, TRANSLATOR.getTranslation("Export_Conversation"), TRANSLATOR.getTranslation("Export_Conversation_Error"));
                }
            }
        };
    }

    private Action createActionMenuItem(final PositronAIActionBase action) {
        AIActionDetails actionDetails = action.getActionDetails();
        Action actionItem = new Action(actionDetails.getTitle()){

            public void run() {
                try {
                    action.actionPerformed(false);
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
        };
        actionItem.setToolTipText(actionDetails.getDescription());
        return actionItem;
    }

    private void addRecentUsedActions(List<Object> existingActions, List<PositronAIActionBase> completionActions) {
        List<Action> recentlyUsedActions;
        String[] recentlyUsedIDs = RecentlyUsedActionsOptionsStorageUtil.getRecentlyUsedActionsData();
        if (completionActions != null && recentlyUsedIDs != null && recentlyUsedIDs.length > 0 && !(recentlyUsedActions = this.createRecentlyUsedMenuItems(completionActions, recentlyUsedIDs)).isEmpty()) {
            existingActions.add(null);
            MenuManager categoryMenu = new MenuManager(TRANSLATOR.getTranslation("Recently_used"));
            existingActions.add(categoryMenu);
            for (Action action : recentlyUsedActions) {
                categoryMenu.add((IAction)action);
            }
            existingActions.add(new Action(TRANSLATOR.getTranslation("Clear_history") + "...", IconsLoader.loadIcon("/images/RemoveAll16.png")){

                public void run() {
                    RecentlyUsedActionsOptionsStorageUtil.clearRecentlyUsedActionsData();
                }
            });
        }
    }

    List<Action> createRecentlyUsedMenuItems(List<PositronAIActionBase> completionActions, String[] recentlyUsedInfo) {
        ArrayList<Action> actions = new ArrayList<Action>();
        block0: for (int i = 0; i < recentlyUsedInfo.length; ++i) {
            if (recentlyUsedInfo[i].contains("%#%#%")) {
                String[] split = recentlyUsedInfo[i].split("%#%#%");
                String actionId = split[0];
                String actionParams = split[1];
                if (!"action.translate.to.lang".equals(actionId)) continue;
                this.createRecentlyUsedMenuItemForTranslationToSelectedLang(completionActions, actions, actionId, actionParams);
                continue;
            }
            String recentlyUsedActionID = recentlyUsedInfo[i];
            if (recentlyUsedActionID == null) continue;
            for (PositronAIActionBase action : completionActions) {
                boolean foundActionCorrespondingToRecentlyUsedID = action.getActionDetails() != null && recentlyUsedActionID.equals(action.getActionDetails().getId());
                if (!foundActionCorrespondingToRecentlyUsedID) continue;
                Action menuItem = this.createActionMenuItem(action);
                actions.add(menuItem);
                continue block0;
            }
        }
        return actions;
    }

    private void createRecentlyUsedMenuItemForTranslationToSelectedLang(List<PositronAIActionBase> completionActions, List<Action> actionMenuItems, String actionId, String actionParams) {
        String[] paranNameAndLang = actionParams.split("=");
        if (paranNameAndLang.length < 2) {
            return;
        }
        String langParamValue = paranNameAndLang[1];
        for (PositronAIActionBase action : completionActions) {
            AIActionDetails actionDetails = action.getActionDetails();
            if (actionDetails == null || !actionId.equals(actionDetails.getId())) continue;
            try {
                PositronAIActionBase clone = action.clone();
                clone.setActionCustomizer(null);
                AIActionDetails cloneActionDetails = clone.getActionDetails();
                cloneActionDetails.getExpandParams().forEach(p -> {
                    if ("translationLanguage".equals(p.getName())) {
                        p.setValue(langParamValue);
                    }
                });
                clone.reconfigureTooltip();
                Action menuItem = this.createActionMenuItem(clone);
                menuItem.setText(langParamValue);
                actionMenuItems.add(menuItem);
            }
            catch (CloneNotSupportedException e) {
                log.warn("Could not clone action: " + actionDetails.getId() + " " + actionDetails.getExpandParams(), (Throwable)e);
            }
            break;
        }
    }

    public void setCompletionImplementation(ContentInserter completionInserter, DocumentContentInteractor prefixExtractor) {
        this.completionActionsManager.setCompletionImplementation(completionInserter, prefixExtractor);
    }

    public Map<String, List<PositronAIActionBase>> getCompletionActions() {
        return AIActionsUtil.groupActionByCategory((List)this.completionActionsManager.getCompletionActions());
    }

    private Action createRecordChangesAction(final PluginWorkspace pluginWorkspaceAccess, final InstructionsSaver instructionsSaver) {
        Action action = new Action(TRANSLATOR.getTranslation("Record_changes_action_name"), IconsLoader.loadIcon("/images/StartRecording16.png")){

            public void run() {
                EditorRecorder editorRecorder = EditorRecorder.getInstance();
                if (editorRecorder.isRunning()) {
                    InstructionsWithExamples prompt = editorRecorder.stopRecording();
                    try {
                        instructionsSaver.saveAsChosenByUser(prompt);
                    }
                    catch (CancelledByUserException e) {
                        log.debug("The user decided not to save the prompt.");
                    }
                    catch (IOException e) {
                        pluginWorkspaceAccess.showErrorMessage("An error has occured when trying to save the prompt: " + e.getMessage(), (Throwable)e);
                    }
                } else {
                    editorRecorder.startRecording();
                }
                this.setText(AIActionsPopup.this.getPromptBuilderActionName());
                this.setToolTipText(AIActionsPopup.this.getPromptBuilderActionTooltipText());
                this.setImageDescriptor(AIActionsPopup.this.getPromptBuilderActionIcon());
            }
        };
        action.setToolTipText(this.getPromptBuilderActionTooltipText());
        return action;
    }

    private String getPromptBuilderActionName() {
        return TRANSLATOR.getTranslation(EditorRecorder.getInstance().isRunning() ? "Stop_recording_action_name" : "Record_changes_action_name");
    }

    private String getPromptBuilderActionTooltipText() {
        return TRANSLATOR.getTranslation(EditorRecorder.getInstance().isRunning() ? "Stop_recording_tooltip_message" : "Record_changes_tooltip_message");
    }

    private ImageDescriptor getPromptBuilderActionIcon() {
        return IconsLoader.loadIcon(EditorRecorder.getInstance().isRunning() ? "/images/StopRecording16.png" : "/images/StartRecording16.png");
    }

    protected void showErrorDialogToUser(IOException originalException, String dialogTitle, String customErrorMessage) {
        if (log.isDebugEnabled()) {
            log.debug(originalException.getMessage(), (Throwable)originalException);
        }
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)TRANSLATOR.getTranslation("Error"), (String)customErrorMessage);
    }

    public void actionsReloaded() {
    }
}

