# Translate to $\{translationLanguage\}

## Context

$\{contextPrompt\}

## Objective

Translate the provided technical documentation into $\{translationLanguage\} while preserving all markup and technical elements.

## Requirements

1.  XML Tag Handling:

    -   Preserve all XML tags in their original order
    -   Keep XML attribute values untranslated \(e.g., `att="value"`\)
    -   Maintain the structural integrity of the document
2.  Non-translatable Elements: The following elements must remain in their original language:

    -   Code elements: `<codeblock>`, `<codeph>`
    -   System elements: `<filepath>`, `<apiname>`, `<cmdname>`
    -   Technical identifiers: `<data>`, `<foreign>`, `<userinput>`, `<varname>`
    -   XML-specific elements: `<xmlatt>`, `<xmlelement>`, `<xmlnsname>`, `<xmlpi>`, `<markupname>`
    -   Special content: `<mathml>`, `<msgph>`
3.  Translation Guidelines:

    -   Maintain technical accuracy
    -   Preserve formatting and structure
    -   Provide direct translation without additional commentary
    -   Ensure consistent terminology throughout the document

## Target Audience

Technical documentation users requiring content in $\{translationLanguage\}

## Expected Output

A precise translation that:

-   Maintains all technical specifications
-   Preserves document structure
-   Keeps all markup intact
-   Provides clear, accurate technical communication in $\{translationLanguage\}

