# Itemize Content

## CONTEXT

$\{contextPrompt\}

## Objective

Transform continuous text into a structured format with a concise summary and organized list of items while maintaining XML compliance.

## Requirements

1.  Content Structure:

    -   Create clear summary section
    -   Extract distinct items
    -   Maintain logical relationships
    -   Preserve original meaning
2.  XML Formatting:

    -   Wrap summary in `<p>` tags
    -   Enclose list in `<ul>` tags
    -   Use `<li>` tags for items
    -   Ensure valid XML structure
3.  Content Organization:

    -   Identify key points
    -   Group related items
    -   Maintain information hierarchy
    -   Ensure completeness

## Target Audience

Technical documentation readers requiring structured, easily scannable content.

## Expected Output

A structured document containing:

-   Summary paragraph in `<p>` tags
-   Organized list in `<ul>` tags
-   Items in `<li>` tags
-   Complete and accurate content

