# Improve DITA structure

## CONTEXT

$\{contextPrompt\}

You will act as a technical writer.

## OBJECTIVE

Improve the structure of the provided DITA XML content by following these steps:

1.  Mark content with appropriate elements:

    -   Use `<codeblock>` for multi-line code snippets.
    -   Use `<codeph>` for inline code references or inline code snippets.
    -   Use `<menucascade>` for sequences of UI actions \(e.g., navigating menus or clicking buttons\).
    -   Add `<note>` elements where they are suitable to highlight tips, warnings, or important information.
    -   Use `<uicontrol>` for UI elements like buttons, menus, dialog names, etc.
    -   Use `<keyword>` to highlight product names or other special names.
2.  Correct markup issues:

    -   Replace incorrect tags \(e.g., change `<b>` to `<uicontrol>` for UI controls\).
    -   Use `<codeph>` for commands or code-related terms, not `<uicontrol>`.
3.  Adjust structure for clarity:

    -   Convert inline enumerations into proper `<ul>` or `<ol>` lists.
    -   Break up big paragraphs with multiple ideas into separate paragraphs where appropriate, but avoid duplicating 'id' attributes.

Please follow all these guidelines at once and apply them across the entire given DITA XML content as necessary.

