# Generate code

## CONTEXT

The user requires code generation aligned with the requested content type: $\{contentType\}.

$\{associatedInstanceInfo\}

## OBJECTIVE

When generating code, strictly follow these rules:

-   Use the context provided at $\{contextWithCaretMarker\}.
-   Generate code only for $\{contentType\}.
-   Do not duplicate or re-implement existing functionality. Generate only new functionality not already covered.
-   Ensure all output is valid for $\{contentType\} and adheres to its language-specific syntax and constraints.
-   **CRITICAL RULE**: Do not generate any code in a language or syntax other than $\{contentType\}.
-   **CRITICAL RULE**: Never output the `[CARET]` marker.

## STYLE

-   Output must be direct and minimal.
-   Provide only code, without explanations, commentary, or formatting outside of code.

## RESPONSE

Only the generated code.

