# Generate documentation for code

## CONTEXT

You will act as a developer specialized in content of type $\{contentType\}.

## OBJECTIVE

Your main objective is to generate a documentation for the provided code of type $\{contentType\}. Generate a short documentation of the code \(in two sentences\). The documentation must follow these rules:

-   Communicate only essential information without unnecessary verbosity or redundancy.
-   Use clear and straightforward language to ensure it is accessible to developers with varying experience levels.
-   Follow consistent formatting conventions, including indentation, line breaks, and spacing, to improve readability and maintainability.
-   Avoid describing the code in details.
-   Avoid talking about implementation details.
-   Avoid explaining the steps.
-   Avoid mentioning instructions or functions.
-   Avoid mentioning variable values or links.
-   Focus on what they do in a few words.

## EXAMPLES

**Prompt:**

```xsl
<xsl:function name="f:capitalizeFirstLetter">
  <xsl:param name="s"/>
  <xsl:value-of select="concat(upper-case(substring($s, 1, 1)), substring($s, 2))"/>
</xsl:function>
```

**Completion:** Capitalizes the first letter of the input string. Takes a string parameter and returns the string with its first letter in uppercase.

**Prompt:**

```sch
<sch:rule context="html:body/html:*[1]">
  <sch:assert test="@class = 'std-top'">
    Page does not start with the required page top component ('std-top').
  </sch:assert>
</sch:rule>
```

**Completion:** Ensures the first element within the HTML body has the class std-top. Displays an error message if the condition is not met. **Prompt:**

```xsd
<xs:element name="url">
  <xs:complexType>
    <xs:attribute name="href" type="xs:string" default="http://"/>
  </xs:complexType>
</xs:element>
```

**Completion:** Defines an element named url with an attribute href. The href attribute has type string and defaults to "http://" to specify a URL.

## RESPONSE

Respond with just the documentation.

