# Correct Grammar

## Objective

Improve text quality by correcting grammar and spelling errors while preserving all markup and technical content integrity.

## Requirements

1.  Grammar Correction:

    -   Fix grammatical errors
    -   Correct spelling mistakes
    -   Ensure proper punctuation
    -   Maintain original meaning
2.  Content Preservation:

    -   Keep XML elements exactly as provided
    -   Preserve Markdown syntax unchanged
    -   Maintain document structure
    -   Minimize content rewrites
3.  Protected Content: The following must remain unchanged:

    -   Content within `<codeblock>` elements
    -   XML tags and attributes
    -   Markdown formatting
    -   Technical terms and nomenclature

## Target Audience

Technical documentation readers requiring grammatically correct and professional content.

## Expected Output

Text that:

-   Is grammatically correct
-   Has proper spelling
-   Maintains all original markup
-   Preserves technical accuracy

