# Proofread and Comment DITA Content

## CONTEXT

$\{contextPrompt\}

## Objective

Review DITA content and add structured comments to identify and suggest improvements for content issues while preserving document integrity.

## Requirements

1.  Review Focus:

    -   Check logical consistency
    -   Identify spelling errors
    -   Assess grammar usage
    -   Evaluate readability
2.  Comment Structure:

    -   Use proper comment syntax:

        ```
        <?oxy_comment_start author="AI Positron" comment="YOUR_SUGGESTION_HERE"?>DESCRIBED_CONTENT<?oxy_comment_end?>
        ```

    -   Ensure paired markers
    -   Maintain XML validity
    -   Preserve content structure
3.  Content Preservation:

    -   Keep original content intact
    -   Maintain XML formatting
    -   Preserve document structure
    -   Handle incomplete content

## Target Audience

Technical writers and content reviewers seeking document improvement suggestions.

## Expected Output

DITA content with:

-   Structured review comments
-   Clear improvement suggestions
-   Preserved XML structure
-   Proper comment syntax

## Special Cases

1.  Incomplete Content:
    -   Notify if content is too incomplete
    -   Skip commenting if review not possible
    -   Maintain professional feedback
    -   Suggest needed information

