<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main"
    xmlns:pic="http://schemas.openxmlformats.org/drawingml/2006/picture"
    xmlns:a="http://schemas.openxmlformats.org/drawingml/2006/main"
    xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships"
    exclude-result-prefixes="xs pic r a"
    version="1.0">
    <xsl:output method="text"/>
    
    <!-- Parameter to control whether to expand images into ${attach(...)} placeholders -->
    <xsl:param name="expandImages" select="'true'"/>

    <xsl:template match="text()">
        <xsl:text> </xsl:text>
        <xsl:value-of select="normalize-space(.)"/>
    </xsl:template>

    <xsl:template match="*">
        <xsl:apply-templates select="node()"/>
    </xsl:template>

    <xsl:template match="w:tc//w:p">
        <xsl:apply-templates select="node()"/>
    </xsl:template>

    <xsl:template match="w:p|w:document|w:body|w:table|w:tr|w:row">
        <xsl:text>
</xsl:text>
        <xsl:apply-templates select="node()"/>
    </xsl:template>

    <!-- Process drawing nodes to extract image placeholders -->
    <xsl:template match="w:drawing">
        <xsl:apply-templates select="node()"/>
    </xsl:template>

    <!-- Ignore formatting and other unnecessary nodes -->
    <xsl:template match="w:pPr|w:rPr|w:bookmarkStart|w:proofErr|w:br|w:bookmarkEnd|w:sectPr|w:lastRenderedPageBreak|w:tblPr|w:tblGrid|w:trPr|w:tcPr|w:sheetViews|w:sheetView|w:sheetFormatPr|w:dimension|w:extLst|w:pageMargins|w:instrText"/>

    <xsl:template match="w:p[w:pPr[w:pStyle[starts-with(@w:val, 'TOC')]]]"/>

    <!-- Handle images: only use a:blip with r:embed (relationship ID) -->
    <xsl:template match="a:blip[@r:embed]">
        <xsl:if test="$expandImages = 'true'">
            <xsl:value-of select="concat('${attach(', normalize-space(@r:embed), ')}')"/>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>