/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util.attach;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLInfo;
import ro.sync.basic.util.URLUtil;

public class SelectionAttachmentUtil {
    private static final Logger log = LoggerFactory.getLogger(SelectionAttachmentUtil.class);
    public static final String SELECTION_CHIP_CUSTOM_URL = "selection://aipositron/selection";

    private SelectionAttachmentUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static URL getSelectionURL() {
        URL selectionURL;
        block2: {
            try {
                selectionURL = new URL(SELECTION_CHIP_CUSTOM_URL);
            }
            catch (MalformedURLException e) {
                selectionURL = URLUtil.convertToURL((String)SELECTION_CHIP_CUSTOM_URL);
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)e, (Throwable)e);
            }
        }
        return selectionURL;
    }

    public static boolean isSelectionURL(URL url) {
        return url != null && "selection".equals(url.getProtocol());
    }

    public static boolean isSelectionURL(String systemID) {
        return systemID != null && systemID.startsWith("selection://");
    }

    public static URL setContentQueryParam(String textContent) {
        block3: {
            if (textContent != null && !textContent.isEmpty()) {
                try {
                    URLInfo urlInfo = new URLInfo(SelectionAttachmentUtil.getSelectionURL());
                    urlInfo.addCustomQueryParam("content", textContent);
                    return urlInfo.getURL(true, true, true);
                }
                catch (MalformedURLException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)e, (Throwable)e);
                }
            }
        }
        return SelectionAttachmentUtil.getSelectionURL();
    }

    public static String getContentQueryParam(URL url) {
        String content;
        block3: {
            content = null;
            try {
                String contentQueryParam;
                URLInfo info = new URLInfo(url);
                LinkedHashMap customQueryParameters = info.getCustomQueryParameters();
                if (customQueryParameters != null && (contentQueryParam = (String)customQueryParameters.get("content")) != null) {
                    content = SelectionAttachmentUtil.decodeURIComponent(contentQueryParam);
                }
            }
            catch (MalformedURLException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)e, (Throwable)e);
            }
        }
        return content;
    }

    public static String decodeURIComponent(String string) {
        block3: {
            if (string != null) {
                try {
                    return new URLCodec().decode(string);
                }
                catch (DecoderException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)e, (Throwable)e);
                }
            }
        }
        return string;
    }
}

