/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util.attach;

import com.oxygenxml.positron.api.connector.dto.ImageUrl;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageContent;
import com.oxygenxml.positron.api.connector.dto.MessageImageUrlWithResolutionContent;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.Pair;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManager;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManagerProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.SecurityUtils;
import com.oxygenxml.positron.core.util.attach.ImageAttachmentsFilter;
import com.oxygenxml.positron.core.util.attach.InvalidAttachmentException;
import com.oxygenxml.positron.core.util.attach.PrivateChatAttachmentContentResolver;
import com.oxygenxml.positron.core.util.attach.SelectionAttachmentUtil;
import com.oxygenxml.positron.core.util.attach.SessionIdSetter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.text.PDFTextStripper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ro.sync.basic.io.IOUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.xml.encoding.EncodingDetector;

public class MessageAttachmentUtils {
    private static final String COULD_NOT_OBTAIN_IMAGE_CONTENT_FROM_URL = "Could not obtain image content from URL: ";
    public static final String ATTACH_EDITOR_VARIABLE_START = "${attach(";
    public static final Pattern ATTACH_PATTERN = Pattern.compile("\\$\\{attach\\((.*?)\\)\\}");

    private MessageAttachmentUtils() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static MessageImageUrlWithResolutionContent createImageAttachmentMessageContent(String src) throws IOException {
        return MessageAttachmentUtils.createImageAttachmentMessageContent(src, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MessageImageUrlWithResolutionContent createImageAttachmentMessageContent(String src, SessionIdSetter sessionIdSetter, PrivateChatAttachmentContentResolver localAttachmentsContentResolver) throws IOException {
        ImageDetails imageDetails = null;
        if (MessageAttachmentUtils.isBase64OpenAIAcceptedImg(src)) {
            Pair<Integer, Integer> resolution = MessageAttachmentUtils.getImageResolutionFromBase64Representation(src);
            imageDetails = new ImageDetails(resolution, src);
            return new MessageImageUrlWithResolutionContent(new ImageUrl(imageDetails.base64Representation), imageDetails.resolution);
        } else if (localAttachmentsContentResolver != null && PrivateChatAttachmentContentResolver.isChatAttachment(src)) {
            byte[] content = localAttachmentsContentResolver.getContent(sessionIdSetter.getSessionId(), src);
            if (content == null) throw new IOException(COULD_NOT_OBTAIN_IMAGE_CONTENT_FROM_URL + URLUtil.clearUserInfo((String)src));
            imageDetails = MessageAttachmentUtils.getImageDetails(src, content);
            return new MessageImageUrlWithResolutionContent(new ImageUrl(imageDetails.base64Representation), imageDetails.resolution);
        } else {
            URL url = MessageAttachmentUtils.getUrlFromSrcValue(src);
            if (sessionIdSetter != null) {
                url = sessionIdSetter.setSessionId(url);
            }
            imageDetails = MessageAttachmentUtils.getImageDetails(url);
        }
        return new MessageImageUrlWithResolutionContent(new ImageUrl(imageDetails.base64Representation), imageDetails.resolution);
    }

    private static boolean isBase64OpenAIAcceptedImg(String s) {
        return s.startsWith("data:image/png;base64") || s.startsWith("data:image/jpg;base64") || s.startsWith("data:image/gif;base64") || s.startsWith("data:image/webp;base64");
    }

    private static ImageDetails getImageDetails(URL url) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        URLConnection openConnection = url.openConnection();
        if (openConnection != null) {
            try (InputStream is = openConnection.getInputStream();){
                int n;
                byte[] byteChunk = new byte[1024];
                while ((n = is.read(byteChunk)) > 0) {
                    outputStream.write(byteChunk, 0, n);
                }
            }
        } else {
            throw new IOException(COULD_NOT_OBTAIN_IMAGE_CONTENT_FROM_URL + URLUtil.clearUserInfo((URL)url));
        }
        return MessageAttachmentUtils.getImageDetails(url.toExternalForm(), outputStream.toByteArray());
    }

    private static ImageDetails getImageDetails(String imageUrlAsString, byte[] imageAsByteArray) throws IOException {
        String base64String = Base64.getEncoder().encodeToString(imageAsByteArray);
        String extension = URLUtil.getExtension((String)imageUrlAsString);
        if ("jpg".equals(extension)) {
            extension = "jpeg";
        }
        String imageType = "data:image/" + extension + ";base64,";
        String imgBase64Representation = imageType + base64String;
        BufferedImage img = ImageIO.read(new ByteArrayInputStream(imageAsByteArray));
        if (img != null) {
            Pair imgResolution = new Pair((Object)img.getWidth(), (Object)img.getHeight());
            return new ImageDetails((Pair<Integer, Integer>)imgResolution, imgBase64Representation);
        }
        throw new IOException(COULD_NOT_OBTAIN_IMAGE_CONTENT_FROM_URL + URLUtil.clearUserInfo((String)imageUrlAsString));
    }

    private static Pair<Integer, Integer> getImageResolutionFromBase64Representation(String base64Str) throws IOException {
        base64Str = base64Str.substring(base64Str.indexOf(44) + 1);
        byte[] imgBytes = Base64.getDecoder().decode(base64Str);
        BufferedImage img = ImageIO.read(new ByteArrayInputStream(imgBytes));
        return new Pair((Object)img.getWidth(), (Object)img.getHeight());
    }

    public static URL getUrlFromSrcValue(String srcAttrVal) throws MalformedURLException {
        URL url;
        try {
            url = new URL(srcAttrVal);
        }
        catch (MalformedURLException e) {
            File file = new File(srcAttrVal);
            if (file.isAbsolute()) {
                url = URLUtil.correct((File)file);
            }
            if (PluginWorkspaceProvider.getPluginWorkspace() != null) {
                try {
                    WSEditor editor = PluginWorkspaceProvider.getPluginWorkspace().getCurrentEditorAccess(0);
                    URL editorLocation = editor.getEditorLocation();
                    url = new URL(editorLocation, file.toString());
                }
                catch (UnsupportedOperationException ex) {
                    throw e;
                }
            }
            throw e;
        }
        return url;
    }

    public static List<Message> expandAttachments(List<Message> messages) throws CannotComputeCompletionDetailsException {
        return MessageAttachmentUtils.expandAttachments(messages, null, null);
    }

    public static List<Message> expandAttachments(List<Message> messages, SessionIdSetter webAuthorSessionSetter, PrivateChatAttachmentContentResolver localAttachmentsContentResolver) throws CannotComputeCompletionDetailsException {
        ArrayList<Message> expandedMessages = new ArrayList<Message>(messages.size());
        for (Message message : messages) {
            boolean messageExpanded = false;
            List mcList = message.getContent();
            if (mcList != null) {
                ArrayList<MessageContent> expandedList = new ArrayList<MessageContent>();
                for (int i = 0; i < mcList.size(); ++i) {
                    MessageContent mc = (MessageContent)mcList.get(i);
                    if (mc instanceof MessageTextContent) {
                        MessageTextContent mtc = (MessageTextContent)mc;
                        String text = mtc.getText();
                        boolean currentMessageModified = false;
                        if (text != null && text.contains(ATTACH_EDITOR_VARIABLE_START)) {
                            Matcher matcher = ATTACH_PATTERN.matcher(text);
                            while (matcher.find()) {
                                MessageAttachmentUtils.attachMessagePart(expandedList, matcher, webAuthorSessionSetter, localAttachmentsContentResolver);
                            }
                            StringBuffer sb = new StringBuffer();
                            matcher.appendTail(sb);
                            text = sb.toString();
                            currentMessageModified = true;
                        }
                        if (currentMessageModified) {
                            if (!text.isEmpty()) {
                                expandedList.add((MessageContent)new MessageTextContent(text));
                            }
                            messageExpanded = true;
                            continue;
                        }
                        expandedList.add(mc);
                        continue;
                    }
                    expandedList.add(mc);
                }
                if (messageExpanded) {
                    message = new Message(message.getRole(), expandedList);
                }
            }
            expandedMessages.add(message);
        }
        return expandedMessages;
    }

    public static void checkAttachments(Collection<Message> messages, ImageAttachmentsFilter filter, SessionIdSetter webAuthorSessionIdSetter) throws InvalidAttachmentException {
        for (Message message : messages) {
            List mcList = message.getContent();
            if (mcList == null) continue;
            for (int i = 0; i < mcList.size(); ++i) {
                MessageContent mc = (MessageContent)mcList.get(i);
                if (!(mc instanceof MessageTextContent)) continue;
                MessageAttachmentUtils.checkAttachments(((MessageTextContent)mc).getText(), filter, webAuthorSessionIdSetter);
            }
        }
    }

    private static void checkAttachments(String messageText, ImageAttachmentsFilter filter, SessionIdSetter webAuthorSessionIdSetter) throws InvalidAttachmentException {
        if (messageText == null || !messageText.contains(ATTACH_EDITOR_VARIABLE_START)) {
            return;
        }
        Matcher matcher = ATTACH_PATTERN.matcher(messageText);
        while (matcher.find()) {
            StringBuffer sb = new StringBuffer();
            matcher.appendReplacement(sb, "");
            String filePath = matcher.group(1);
            try {
                if (filePath.isEmpty() || MessageAttachmentUtils.isBase64OpenAIAcceptedImg(filePath)) continue;
                URL url = MessageAttachmentUtils.getUrlFromSrcValue(filePath);
                if (webAuthorSessionIdSetter != null) {
                    url = webAuthorSessionIdSetter.setSessionId(url);
                }
                filter.accept(url);
            }
            catch (MalformedURLException malformedURLException) {}
        }
    }

    private static void attachMessagePart(List<MessageContent> expandedList, Matcher matcher, SessionIdSetter sessionIdSetter, PrivateChatAttachmentContentResolver localAttachmentsContentResolver) throws CannotComputeCompletionDetailsException {
        String filePath;
        StringBuffer sb = new StringBuffer();
        matcher.appendReplacement(sb, "");
        String str = sb.toString();
        if (!str.isEmpty()) {
            str = str.replace("#################attachments#################", "");
            expandedList.add((MessageContent)new MessageTextContent(str));
        }
        if (!(filePath = matcher.group(1)).isEmpty()) {
            if (SelectionAttachmentUtil.isSelectionURL(filePath)) {
                String contentQueryParam = SelectionAttachmentUtil.getContentQueryParam(URLUtil.convertToURL((String)filePath));
                if (contentQueryParam != null) {
                    expandedList.add((MessageContent)new MessageTextContent(contentQueryParam));
                }
            } else {
                MessageAttachmentUtils.expandNonSelectionAttachments(expandedList, sessionIdSetter, localAttachmentsContentResolver, filePath);
            }
        }
    }

    private static void expandNonSelectionAttachments(List<MessageContent> expandedList, SessionIdSetter sessionIdSetter, PrivateChatAttachmentContentResolver localAttachmentsContentResolver, String filePath) throws CannotComputeCompletionDetailsException {
        block14: {
            AiIgnoreManager aiIgnoreChecker = AiIgnoreManagerProvider.getAiIgnoreChecker();
            if (aiIgnoreChecker != null && aiIgnoreChecker.isIgnoredFromAiIgnoreFile(URLUtil.convertToURL((String)filePath))) {
                String msg = MessageFormat.format(Translator.getInstance().getTranslation("Access_denied_to_File_is_not_AI_accessible"), URLUtil.filterPasswords((String)filePath));
                throw new CannotComputeCompletionDetailsException(msg);
            }
            try {
                expandedList.add((MessageContent)MessageAttachmentUtils.createImageAttachmentMessageContent(filePath, sessionIdSetter, localAttachmentsContentResolver));
            }
            catch (IOException e) {
                boolean noContentExtracted;
                boolean addedContent;
                block13: {
                    addedContent = false;
                    noContentExtracted = false;
                    try {
                        if (localAttachmentsContentResolver != null && PrivateChatAttachmentContentResolver.isChatAttachment(filePath)) {
                            byte[] content = localAttachmentsContentResolver.getContent(sessionIdSetter.getSessionId(), filePath);
                            if (content == null) break block13;
                            try {
                                List<MessageContent> messagesContent = MessageAttachmentUtils.getTextContent(filePath, new ByteArrayInputStream(content));
                                if (messagesContent != null && !messagesContent.isEmpty()) {
                                    expandedList.addAll(messagesContent);
                                    addedContent = true;
                                } else {
                                    noContentExtracted = true;
                                }
                                break block13;
                            }
                            catch (Throwable ex) {
                                if (e instanceof IOException) {
                                    throw e;
                                }
                                throw new IOException("Could not convert content to text:" + e.getMessage(), e);
                            }
                        }
                        List<MessageContent> messagesContent = MessageAttachmentUtils.getTextContent(filePath, sessionIdSetter);
                        if (messagesContent != null && !messagesContent.isEmpty()) {
                            expandedList.addAll(messagesContent);
                            addedContent = true;
                        } else {
                            noContentExtracted = true;
                        }
                    }
                    catch (IOException ex) {
                        e = ex;
                    }
                }
                if (addedContent) break block14;
                throw new CannotComputeCompletionDetailsException((noContentExtracted ? "Could not extract content: " : "Cannot attach file: ") + URLUtil.filterPasswords((String)filePath), e);
            }
        }
    }

    public static List<MessageContent> getTextContent(String referenceAttrValue, SessionIdSetter sessionIdSetter) throws IOException {
        List<MessageContent> list;
        block10: {
            URL url = MessageAttachmentUtils.getUrlFromSrcValue(referenceAttrValue);
            if (sessionIdSetter != null) {
                url = sessionIdSetter.setSessionId(url);
            }
            URLConnection openConnection = url.openConnection();
            InputStream is = openConnection.getInputStream();
            try {
                list = MessageAttachmentUtils.getTextContent(url.toString(), is);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new IOException("Could not convert content to text:" + e.getMessage(), e);
                }
            }
            is.close();
        }
        return list;
    }

    private static List<MessageContent> getTextContent(String filePath, InputStream is) throws Exception {
        if (filePath.endsWith(".pdf")) {
            return MessageAttachmentUtils.getPDFText(filePath, is);
        }
        if (filePath.endsWith(".docx")) {
            return MessageAttachmentUtils.getDocxText(filePath, is);
        }
        if (filePath.endsWith(".pptx")) {
            return MessageAttachmentUtils.getPPTxText(filePath, is);
        }
        InputStreamReader reader = EncodingDetector.getInstance().createReader(is, URLUtil.getDescription((String)filePath), null, "UTF-8", new ArrayList());
        if (reader == null) {
            throw new IOException("Cannot retrieve content for attached path: " + URLUtil.clearUserInfo((String)filePath));
        }
        ArrayList<MessageContent> messageContents = new ArrayList<MessageContent>(1);
        messageContents.add((MessageContent)new MessageTextContent(MessageAttachmentUtils.addFileURLMarkers(filePath, IOUtil.read((Reader)reader).toString())));
        return messageContents;
    }

    private static String addFileURLMarkers(String url, String text) {
        if (url != null && !url.isEmpty()) {
            String attachURL;
            Object textWithMarkers = "";
            URL clearedUserInfo = URLUtil.clearUserInfo((String)url);
            String string = attachURL = clearedUserInfo != null ? clearedUserInfo.toExternalForm() : url;
            if (attachURL != null) {
                textWithMarkers = (String)textWithMarkers + "\n--Inline attached content URL: \"" + attachURL + "\"\n";
            }
            textWithMarkers = (String)textWithMarkers + "--inline-attached-content-start--\n";
            text = textWithMarkers = (String)textWithMarkers + "\n" + (String)text + "\n--inline-attached-content-end--\n";
        }
        return text;
    }

    private static List<MessageContent> getDocxText(String filePath, InputStream is) throws IOException, TransformerFactoryConfigurationError, TransformerException, CannotComputeCompletionDetailsException {
        ArrayList<MessageContent> mcs = new ArrayList<MessageContent>();
        Map<String, byte[]> zipEntries = MessageAttachmentUtils.readAllZipEntries(is);
        for (Map.Entry<String, byte[]> e : zipEntries.entrySet()) {
            String entryName = e.getKey();
            String fileName = URLUtil.extractFileName((String)entryName);
            if (!fileName.startsWith("document") || !fileName.endsWith(".xml") || !entryName.contains("word/")) continue;
            mcs.addAll(MessageAttachmentUtils.processDocxDocumentEntry(entryName, e.getValue(), filePath, zipEntries));
            break;
        }
        return mcs;
    }

    private static List<MessageContent> processDocxDocumentEntry(String entryName, byte[] documentXmlBytes, String filePath, Map<String, byte[]> zipEntries) throws IOException, TransformerException, CannotComputeCompletionDetailsException {
        ArrayList<MessageContent> mcs = new ArrayList<MessageContent>();
        String fileName = URLUtil.extractFileName((String)entryName);
        String baseRoot = entryName.contains("/") ? entryName.substring(0, entryName.indexOf(47) + 1) : "";
        String relsPath = baseRoot + "_rels/" + fileName + ".rels";
        Map<Object, Object> relsMap = new HashMap();
        if (zipEntries.containsKey(relsPath)) {
            try {
                relsMap = MessageAttachmentUtils.parseRelationships(zipEntries.get(relsPath));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String text = MessageAttachmentUtils.extractTextFromDocxOrPPTxXML(documentXmlBytes, true);
        Matcher attachMatcher = ATTACH_PATTERN.matcher(text);
        StringBuffer processedTextBuf = new StringBuffer();
        while (attachMatcher.find()) {
            String entryPath;
            String found;
            String inner = attachMatcher.group(1);
            Object replacementInner = inner;
            if (!inner.contains(":")) {
                String target = null;
                target = relsMap != null && relsMap.containsKey(inner) ? (String)relsMap.get(inner) : inner;
                if (target != null) {
                    String entryPath2 = MessageAttachmentUtils.normalizePath(baseRoot, target);
                    replacementInner = "jar:" + filePath + "!/" + entryPath2;
                }
            }
            if (((String)replacementInner).startsWith("jar:") && ((String)replacementInner).contains("!/") && (found = MessageAttachmentUtils.findBestEntryForJar(entryPath = ((String)replacementInner).substring(((String)replacementInner).indexOf("!/") + 2), baseRoot, zipEntries)) != null) {
                replacementInner = "jar:" + filePath + "!/" + found;
            }
            attachMatcher.appendReplacement(processedTextBuf, Matcher.quoteReplacement(ATTACH_EDITOR_VARIABLE_START + (String)replacementInner + ")}"));
        }
        attachMatcher.appendTail(processedTextBuf);
        text = processedTextBuf.toString();
        List<MessageContent> inlined = MessageAttachmentUtils.inlineImagesFromZip(text, baseRoot, zipEntries);
        if (inlined != null && !inlined.isEmpty()) {
            return inlined;
        }
        mcs.addAll(MessageAttachmentUtils.expandTextWithMarkers(filePath, text));
        return mcs;
    }

    private static List<MessageContent> expandTextWithMarkers(String filePath, String text) throws CannotComputeCompletionDetailsException {
        String textWithMarkers = MessageAttachmentUtils.addFileURLMarkers(filePath, text);
        ArrayList<Message> tempMessages = new ArrayList<Message>();
        tempMessages.add(new Message(RoleType.USER, (MessageContent)new MessageTextContent(textWithMarkers)));
        List<Message> expandedMessages = MessageAttachmentUtils.expandAttachments(tempMessages, null, null);
        if (expandedMessages.size() == 1) {
            return expandedMessages.get(0).getContent();
        }
        ArrayList<MessageContent> fallback = new ArrayList<MessageContent>();
        fallback.add((MessageContent)new MessageTextContent(textWithMarkers));
        return fallback;
    }

    private static String extractTextFromDocxOrPPTxXML(byte[] documentXmlBytes, boolean expandImages) throws IOException, TransformerException {
        byte[] bytes = documentXmlBytes;
        StringWriter sw = new StringWriter();
        try (InputStream is = MessageAttachmentUtils.class.getResourceAsStream("/extract-docx-pptx-text.xsl");){
            StreamResult res = new StreamResult(sw);
            TransformerFactory factory = TransformerFactory.newInstance();
            try {
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                // empty catch block
            }
            Transformer tr = factory.newTransformer(new StreamSource(is));
            tr.setParameter("expandImages", expandImages ? "true" : "false");
            StreamSource src = new StreamSource(new ByteArrayInputStream(bytes));
            tr.transform(src, res);
            sw.close();
        }
        return sw.toString();
    }

    private static byte[] readZipEntryBytes(ZipInputStream zis) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int read = zis.read(buffer, 0, buffer.length);
        while (read > -1) {
            baos.write(buffer, 0, read);
            read = zis.read(buffer, 0, buffer.length);
        }
        baos.close();
        byte[] bytes = baos.toByteArray();
        return bytes;
    }

    private static Map<String, byte[]> readAllZipEntries(InputStream is) throws IOException {
        LinkedHashMap<String, byte[]> zipEntries = new LinkedHashMap<String, byte[]>();
        try (ZipInputStream zis = new ZipInputStream(is);){
            ZipEntry nextEntry = null;
            while ((nextEntry = zis.getNextEntry()) != null) {
                if (nextEntry.isDirectory()) continue;
                String entryName = nextEntry.getName();
                byte[] bytes = MessageAttachmentUtils.readZipEntryBytes(zis);
                zipEntries.put(entryName, bytes);
            }
        }
        return zipEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MessageContent> getPDFText(String filePath, InputStream is) throws Exception {
        byte[] bytes = IOUtil.readBytes((InputStream)is);
        PDDocument pdDoc = null;
        Class<PDFParser> parserClass = PDFParser.class;
        Constructor parserConstructor = parserClass.getConstructor(Class.forName("org.apache.pdfbox.io.RandomAccessRead"));
        try {
            Class<?> rarClass = Class.forName("org.apache.pdfbox.io.RandomAccessBuffer");
            Object buf = rarClass.getConstructor(byte[].class).newInstance(new Object[]{bytes});
            Object parser = parserConstructor.newInstance(buf);
            parser.getClass().getMethod("parse", new Class[0]).invoke(parser, new Object[0]);
            COSDocument cosDoc = (COSDocument)parser.getClass().getMethod("getDocument", new Class[0]).invoke(parser, new Object[0]);
            pdDoc = new PDDocument(cosDoc);
        }
        catch (Throwable th) {
            Class<?> rarClass = Class.forName("org.apache.pdfbox.io.RandomAccessReadBuffer");
            Object rarBuffer = rarClass.getConstructor(byte[].class).newInstance(new Object[]{bytes});
            Object parser = parserConstructor.newInstance(rarBuffer);
            pdDoc = (PDDocument)parser.getClass().getMethod("parse", new Class[0]).invoke(parser, new Object[0]);
        }
        PDFTextStripper pdfStripper = new PDFTextStripper();
        ArrayList<MessageContent> mcs = new ArrayList<MessageContent>();
        try {
            String text = pdfStripper.getText(pdDoc);
            mcs.add((MessageContent)new MessageTextContent(MessageAttachmentUtils.addFileURLMarkers(filePath, text)));
            Collection<byte[]> imagesFromResources = MessageAttachmentUtils.getImagesFromPDF(pdDoc).values();
            for (byte[] imageBytes : imagesFromResources) {
                ImageDetails imageDetails = MessageAttachmentUtils.getImageDetails("image.png", imageBytes);
                mcs.add((MessageContent)new MessageImageUrlWithResolutionContent(new ImageUrl(imageDetails.base64Representation), imageDetails.resolution));
            }
        }
        finally {
            pdDoc.close();
        }
        return mcs;
    }

    private static Map<String, byte[]> getImagesFromPDF(PDDocument document) throws NoSuchAlgorithmException {
        LinkedHashMap<String, byte[]> images = new LinkedHashMap<String, byte[]>();
        PDPageTree iter = document.getPages();
        for (PDPage page : iter) {
            images.putAll(MessageAttachmentUtils.getImagesFromResources(page.getResources()));
        }
        return images;
    }

    private static Map<String, byte[]> getImagesFromResources(PDResources resources) throws NoSuchAlgorithmException {
        LinkedHashMap<String, byte[]> images = new LinkedHashMap<String, byte[]>();
        Iterable iter = resources.getXObjectNames();
        for (COSName xObjectName : iter) {
            try {
                PDXObject xObject = resources.getXObject(xObjectName);
                if (!(xObject instanceof PDImageXObject)) continue;
                BufferedImage image = ((PDImageXObject)xObject).getImage();
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    ImageIO.write((RenderedImage)image, "png", baos);
                    byte[] byteArray = baos.toByteArray();
                    images.put(SecurityUtils.hash(byteArray), byteArray);
                }
            }
            catch (IOException iOException) {}
        }
        return images;
    }

    private static List<MessageContent> getPPTxText(String filePath, InputStream is) throws IOException, TransformerFactoryConfigurationError, TransformerException {
        ArrayList<MessageContent> mcs = new ArrayList<MessageContent>();
        try (ZipInputStream zis = new ZipInputStream(is);){
            ZipEntry nextEntry = null;
            while ((nextEntry = zis.getNextEntry()) != null) {
                String entryName = nextEntry.getName();
                String fileName = URLUtil.extractFileName((String)entryName);
                if (!fileName.startsWith("slide") || !fileName.endsWith(".xml") || fileName.contains("Layout") || fileName.contains("Master")) continue;
                byte[] slideBytes = MessageAttachmentUtils.readZipEntryBytes(zis);
                String text = MessageAttachmentUtils.extractTextFromDocxOrPPTxXML(slideBytes, false);
                mcs.add((MessageContent)new MessageTextContent(MessageAttachmentUtils.addFileURLMarkers(filePath, text)));
            }
        }
        return mcs;
    }

    private static Map<String, String> parseRelationships(byte[] relsBytes) throws Exception {
        HashMap<String, String> rels = new HashMap<String, String>();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(relsBytes);){
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(bais);
            NodeList relNodes = doc.getElementsByTagNameNS("http://schemas.openxmlformats.org/package/2006/relationships", "Relationship");
            for (int i = 0; i < relNodes.getLength(); ++i) {
                Element rel = (Element)relNodes.item(i);
                String id = rel.getAttribute("Id");
                String target = rel.getAttribute("Target");
                if (id == null || id.isEmpty() || target == null || target.isEmpty()) continue;
                rels.put(id, target);
            }
        }
        return rels;
    }

    private static String normalizePath(String baseRoot, String target) {
        String base;
        if (target == null) {
            return "";
        }
        String string = base = baseRoot == null ? "" : baseRoot;
        while (target.startsWith("./")) {
            target = target.substring(2);
        }
        ArrayList<String> parts = new ArrayList<String>();
        if (!base.isEmpty()) {
            for (String p : base.split("/")) {
                if (p == null || p.isEmpty()) continue;
                parts.add(p);
            }
        }
        for (String p : target.split("/")) {
            if (p == null || p.isEmpty()) continue;
            if (p.equals("..")) {
                if (parts.isEmpty()) continue;
                parts.remove(parts.size() - 1);
                continue;
            }
            if (p.equals(".")) continue;
            parts.add(p);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.size(); ++i) {
            sb.append((String)parts.get(i));
            if (i >= parts.size() - 1) continue;
            sb.append('/');
        }
        return sb.toString();
    }

    private static String findBestEntryForJar(String entryPath, String baseRoot, Map<String, byte[]> zipEntries) {
        ArrayList<Object> candidates = new ArrayList<Object>();
        candidates.add(entryPath);
        if (baseRoot != null && !baseRoot.isEmpty() && entryPath.startsWith(baseRoot)) {
            candidates.add(entryPath.substring(baseRoot.length()));
        }
        if (baseRoot != null && !baseRoot.isEmpty()) {
            candidates.add(baseRoot + entryPath);
        }
        String fileName = entryPath.contains("/") ? entryPath.substring(entryPath.lastIndexOf(47) + 1) : entryPath;
        candidates.add("media/" + fileName);
        for (String string : candidates) {
            if (!zipEntries.containsKey(string)) continue;
            return string;
        }
        return null;
    }

    private static boolean isSupportedImageExtension(String extension) {
        if (extension == null) {
            return false;
        }
        String lowerExt = extension.toLowerCase();
        return "png".equals(lowerExt) || "jpg".equals(lowerExt) || "jpeg".equals(lowerExt) || "gif".equals(lowerExt) || "webp".equals(lowerExt);
    }

    private static List<MessageContent> inlineImagesFromZip(String text, String baseRoot, Map<String, byte[]> zipEntries) throws CannotComputeCompletionDetailsException {
        String tail;
        ArrayList<Object> result = new ArrayList<Object>();
        Matcher matcher = ATTACH_PATTERN.matcher(text);
        int lastEnd = 0;
        boolean foundAnyImage = false;
        boolean errorExpandingImageRef = false;
        while (matcher.find() && !errorExpandingImageRef) {
            block12: {
                String between;
                if (matcher.start() > lastEnd && (between = text.substring(lastEnd, matcher.start())) != null && !between.isEmpty()) {
                    result.add(new MessageTextContent(between));
                }
                String inner = matcher.group(1);
                String entryKey = null;
                try {
                    if (inner != null && inner.startsWith("jar:") && inner.contains("!/")) {
                        String entryPath = inner.substring(inner.indexOf("!/") + 2);
                        entryKey = MessageAttachmentUtils.findBestEntryForJar(entryPath, baseRoot, zipEntries);
                    } else {
                        entryKey = MessageAttachmentUtils.findBestEntryForJar(inner, baseRoot, zipEntries);
                    }
                }
                catch (Exception e) {
                    errorExpandingImageRef = true;
                    break;
                }
                if (entryKey == null) {
                    errorExpandingImageRef = true;
                    break;
                }
                byte[] entryBytes = zipEntries.get(entryKey);
                if (entryBytes == null) {
                    errorExpandingImageRef = true;
                    break;
                }
                String extension = URLUtil.getExtension((String)entryKey);
                if (MessageAttachmentUtils.isSupportedImageExtension(extension)) {
                    try {
                        ImageDetails imageDetails = MessageAttachmentUtils.getImageDetails(entryKey, entryBytes);
                        result.add(new MessageImageUrlWithResolutionContent(new ImageUrl(imageDetails.base64Representation), imageDetails.resolution));
                        foundAnyImage = true;
                        break block12;
                    }
                    catch (IOException ioe) {
                        errorExpandingImageRef = true;
                        break;
                    }
                }
                errorExpandingImageRef = true;
                break;
            }
            lastEnd = matcher.end();
        }
        if (!errorExpandingImageRef && lastEnd < text.length() && (tail = text.substring(lastEnd)) != null && !tail.isEmpty()) {
            result.add(new MessageTextContent(tail));
        }
        return !errorExpandingImageRef && foundAnyImage ? result : null;
    }

    public static final class ImageDetails {
        private Pair<Integer, Integer> resolution;
        private String base64Representation;

        public ImageDetails(Pair<Integer, Integer> resolution, String base64Representation) {
            this.resolution = resolution;
            this.base64Representation = base64Representation;
        }
    }
}

