/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util.attach;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.attach.ImageAttachmentsFilter;
import com.oxygenxml.positron.core.util.attach.InvalidAttachmentException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;

class ImageReaderAttachmentFilter
implements ImageAttachmentsFilter {
    private static final Logger log = LoggerFactory.getLogger(ImageReaderAttachmentFilter.class);

    ImageReaderAttachmentFilter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(URL resource) throws InvalidAttachmentException {
        boolean oldUseCache = ImageIO.getUseCache();
        boolean isValidAttachment = false;
        URLConnection openConnection = null;
        InputStream inputStream = null;
        ImageIO.setUseCache(false);
        try {
            openConnection = URLUtil.openConnection((URL)resource);
            inputStream = openConnection.getInputStream();
            ImageInputStream imageStream = ImageIO.createImageInputStream(inputStream);
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageStream);
            isValidAttachment = iterator.hasNext();
        }
        catch (IOException ex) {
            log.debug((Object)ex, (Throwable)ex);
        }
        finally {
            block14: {
                ImageIO.setUseCache(oldUseCache);
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        if (!log.isDebugEnabled()) break block14;
                        log.debug((Object)e, (Throwable)e);
                    }
                }
            }
            URLUtil.disconnect((URLConnection)openConnection);
        }
        if (!isValidAttachment) {
            throw new InvalidAttachmentException(Translator.getInstance().getTranslation("Invalid_Attachment_Message"));
        }
    }
}

