/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.positron.core.util.TextUtils;
import java.util.regex.Pattern;

public class XMLDocumentResponseTypeDetector {
    private static final Pattern XML_FRAGMENT_PATTERN = Pattern.compile("(?s)^<[a-zA-Z_][a-zA-Z0-9_\\-.:]*(?:\\s+[^>]*)?/?>.*");

    private XMLDocumentResponseTypeDetector() {
        throw new IllegalStateException("Cannot be instantiated");
    }

    private static boolean contains(String response, String toSearch) {
        return !TextUtils.isNullOrBlank(response) && response.indexOf(toSearch) >= 0;
    }

    @VisibleForTesting
    static boolean hasDoctype(String response) {
        return XMLDocumentResponseTypeDetector.contains(response, "<!DOCTYPE");
    }

    @VisibleForTesting
    static boolean hasSchemaLocation(String response) {
        return XMLDocumentResponseTypeDetector.contains(response, "schemaLocation");
    }

    @VisibleForTesting
    static boolean hasXmlModel(String response) {
        return XMLDocumentResponseTypeDetector.contains(response, "<?xml-model");
    }

    @VisibleForTesting
    static boolean hasXmlDeclaration(String response) {
        return XMLDocumentResponseTypeDetector.contains(response, "<?xml version");
    }

    @VisibleForTesting
    static boolean hasNoNamespaceSchemaLocation(String response) {
        return XMLDocumentResponseTypeDetector.contains(response, "noNamespaceSchemaLocation");
    }

    public static boolean isLikelyCompleteDocument(String responseMessage, String contentType) {
        String response = TextUtils.extractInsertionContentFromResponse(responseMessage, contentType);
        if (response == null || response.isEmpty()) {
            return false;
        }
        String trimmed = response.trim();
        if (trimmed.isEmpty() || !trimmed.startsWith("<")) {
            return false;
        }
        boolean hasXmlDecl = XMLDocumentResponseTypeDetector.hasXmlDeclaration(trimmed);
        if (hasXmlDecl && !trimmed.startsWith("<?xml version")) {
            return false;
        }
        boolean hasDoctype = XMLDocumentResponseTypeDetector.hasDoctype(trimmed);
        boolean hasXmlModel = XMLDocumentResponseTypeDetector.hasXmlModel(trimmed);
        boolean hasSchemaLoc = XMLDocumentResponseTypeDetector.hasSchemaLocation(trimmed);
        boolean hasNoNamespaceSchemaLoc = XMLDocumentResponseTypeDetector.hasNoNamespaceSchemaLocation(trimmed);
        return hasDoctype || hasXmlDecl || hasXmlModel || hasSchemaLoc || hasNoNamespaceSchemaLoc;
    }

    public static boolean containsXMLFragment(String response, String contentType) {
        String content = TextUtils.extractInsertionContentFromResponse(response, contentType);
        if (content == null || content.isEmpty()) {
            return false;
        }
        String trimmedContent = content.trim();
        return XML_FRAGMENT_PATTERN.matcher(trimmedContent).matches();
    }
}

