/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import com.oxygenxml.positron.core.interactions.ContentInserter;
import com.oxygenxml.positron.core.interactions.DocumentDetailsProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.document.TextUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.util.UtilAccess;

public class TextUtils {
    private static final Logger log = LoggerFactory.getLogger(TextUtils.class);
    private static final String MARKDOWN_CODEBLOCK_MARKER = "markdown";
    private static final Logger logger = LoggerFactory.getLogger((String)TextUtils.class.getName());
    private static final String CODEBLOCK_MD_SYNTAX = "```";
    private static final Pattern HEADER_PATTERN = Pattern.compile("^(\\s*)#");
    private static final Pattern OL_PATTERN = Pattern.compile("^(\\s*)(\\d*)(\\s*)\\.");
    private static final Pattern UL_PATTERN = Pattern.compile("^(\\s*)\\-");
    private static final Pattern BLOCK_QUOTE = Pattern.compile("^(\\s*)\\>");
    private static final Pattern BLOCK_SPACES_QUOTE = Pattern.compile("^ {4}");
    private static final List<String> POSSIBLE_MARKDOWN_SYMBOLS = Arrays.asList("`", "](", "![");
    private static final List<Pattern> POSSIBLE_MARKDOWN_PATTERNS = Arrays.asList(HEADER_PATTERN, OL_PATTERN, UL_PATTERN, BLOCK_QUOTE, BLOCK_SPACES_QUOTE);
    private static final Map<String, String> THINKING_TAG_MAPPINGS = new HashMap<String, String>();

    private TextUtils() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String filterMessageStatusText(String message) {
        if (message == null) {
            message = "";
        }
        String text = TextUtil.getSomeTextConsideringWordBounds((String)message, (int)50);
        return TextUtil.normalizeAndCollapseWhitespace((String)text);
    }

    public static boolean isNullOrBlank(String text) {
        return text == null || text.isBlank();
    }

    public static String extractInsertionContentFromResponseForURL(String content, String url) {
        String contentType = TextUtils.getContentType(url);
        return TextUtils.extractInsertionContentFromResponse(content, contentType);
    }

    public static String getContentType(String url) {
        UtilAccess utilAccess;
        PluginWorkspace pw = PluginWorkspaceProvider.getPluginWorkspace();
        String contentType = null;
        if (pw != null && (utilAccess = pw.getUtilAccess()) != null) {
            contentType = utilAccess.getContentType(url);
        }
        return contentType;
    }

    public static String extractInsertionContentFromResponseForInserter(String content, ContentInserter contentInserter) {
        Optional optionalCT = Optional.ofNullable(contentInserter).flatMap(DocumentDetailsProvider::getContentType);
        String contentType = null;
        if (optionalCT.isPresent()) {
            contentType = (String)optionalCT.get();
        }
        return TextUtils.extractInsertionContentFromResponse(content, contentType);
    }

    public static String extractInsertionContentFromResponseForCurrentEditor(String content) {
        WSEditor currentEditor;
        String contentType = null;
        PluginWorkspace pw = PluginWorkspaceProvider.getPluginWorkspace();
        if (pw != null && (currentEditor = pw.getCurrentEditorAccess(0)) != null) {
            contentType = currentEditor.getContentType();
        }
        return TextUtils.extractInsertionContentFromResponse(content, contentType);
    }

    public static String extractInsertionContentFromResponse(String content, String editorContentType) {
        if (content != null) {
            content = TextUtils.removeThinkingInfo(content);
            content = TextUtils.unwrapMarkdownCodeBlocks(content, editorContentType);
        }
        return content;
    }

    private static String unwrapMarkdownCodeBlocks(String originalContent, String editorContentType) {
        int lastMarkIndex;
        String extractedCode = "";
        boolean isMarkdownEditor = "text/markdown".equals(editorContentType);
        if (originalContent != null && (lastMarkIndex = originalContent.lastIndexOf(CODEBLOCK_MD_SYNTAX)) != -1) {
            int firstMarkIndex = -1;
            firstMarkIndex = isMarkdownEditor ? originalContent.lastIndexOf("```markdown", lastMarkIndex - CODEBLOCK_MD_SYNTAX.length()) : originalContent.lastIndexOf(CODEBLOCK_MD_SYNTAX, lastMarkIndex - CODEBLOCK_MD_SYNTAX.length());
            if (firstMarkIndex != -1) {
                int firstMarkEOLIndex = originalContent.indexOf(10, firstMarkIndex);
                firstMarkEOLIndex = firstMarkEOLIndex == -1 ? firstMarkIndex + CODEBLOCK_MD_SYNTAX.length() : ++firstMarkEOLIndex;
                if (firstMarkEOLIndex != -1 && firstMarkEOLIndex < lastMarkIndex) {
                    extractedCode = originalContent.substring(firstMarkEOLIndex, lastMarkIndex);
                }
            }
        }
        return extractedCode.length() == 0 ? originalContent : extractedCode;
    }

    private static String removeThinkingInfo(String content) {
        for (Map.Entry<String, String> tags : THINKING_TAG_MAPPINGS.entrySet()) {
            int tEndIndex;
            int tIndex = ((String)content).indexOf(tags.getKey());
            if (tIndex == -1 || (tEndIndex = ((String)content).indexOf(tags.getValue())) == -1 || tEndIndex <= tIndex) continue;
            content = ((String)content).substring(0, tIndex) + ((String)content).substring(tEndIndex + tags.getValue().length());
            content = ((String)content).trim();
        }
        return content;
    }

    private static boolean isSplittableChar(char ch, char[] nonSplittableChars) {
        if (nonSplittableChars == null) {
            return true;
        }
        for (int i = 0; i < nonSplittableChars.length; ++i) {
            if (ch != nonSplittableChars[i]) continue;
            return false;
        }
        return true;
    }

    public static String getSplittedText(String text, int maxColumnsNumber, char[] nonSplittableChars, boolean trimText) {
        if (text == null) {
            return null;
        }
        int current = 0;
        int lastSpaceOrNonAlphaIndex = -1;
        int lineIndex = 0;
        char lastSpaceOrNonAlpaha = '\u0000';
        if (trimText) {
            text = text.trim();
        }
        int len = text.length();
        StringBuilder buffer = new StringBuilder();
        while (current < len) {
            char ch = text.charAt(current);
            if (logger.isDebugEnabled()) {
                logger.debug("Char: {}", (Object)Character.valueOf(ch));
            }
            if (Character.isWhitespace(ch) || !Character.isLetterOrDigit(ch) && TextUtils.isSplittableChar(ch, nonSplittableChars)) {
                lastSpaceOrNonAlphaIndex = lineIndex;
                lastSpaceOrNonAlpaha = ch;
                if (logger.isDebugEnabled()) {
                    logger.debug("Storing the space index: {}", (Object)Character.valueOf(lastSpaceOrNonAlpaha));
                }
            }
            if (ch == '\n') {
                if (lineIndex > 0) {
                    lineIndex = -1;
                    lastSpaceOrNonAlphaIndex = -1;
                    if (current + 1 < len && text.charAt(current + 1) == '\r') {
                        ++current;
                    }
                    buffer.append(ch);
                }
            } else if (ch == '\r') {
                if (lineIndex > 0) {
                    lineIndex = -1;
                    lastSpaceOrNonAlphaIndex = -1;
                    if (current + 1 < len && text.charAt(current + 1) == '\n') {
                        ++current;
                    }
                    buffer.append('\n');
                }
            } else if (lineIndex == maxColumnsNumber - 1) {
                if (lastSpaceOrNonAlphaIndex == lineIndex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Last space at the end of a line.");
                    }
                    if (!Character.isWhitespace(lastSpaceOrNonAlpaha)) {
                        buffer.append(ch);
                    }
                    lineIndex = -1;
                    lastSpaceOrNonAlphaIndex = -1;
                    buffer.append('\n');
                } else if (lastSpaceOrNonAlphaIndex != -1) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("The last space index: {}", (Object)lastSpaceOrNonAlphaIndex);
                    }
                    lineIndex = maxColumnsNumber - lastSpaceOrNonAlphaIndex - 1;
                    if (logger.isDebugEnabled()) {
                        logger.debug("The line index: {}", (Object)lineIndex);
                        logger.debug("The char at line index: {}", (Object)Character.valueOf(buffer.charAt(buffer.length() - lineIndex)));
                    }
                    lastSpaceOrNonAlphaIndex = -1;
                    if (Character.isWhitespace(lastSpaceOrNonAlpaha)) {
                        buffer.setCharAt(buffer.length() - lineIndex, '\n');
                    } else {
                        buffer.insert(buffer.length() - lineIndex, '\n');
                    }
                    buffer.append(ch);
                    --lineIndex;
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("No space in line.");
                    }
                    lineIndex = -1;
                    lastSpaceOrNonAlphaIndex = -1;
                    buffer.append(ch);
                    buffer.append('\n');
                }
            } else {
                buffer.append(ch);
            }
            ++lineIndex;
            if (logger.isDebugEnabled()) {
                logger.debug("LineIndex: {} Buf: {}", (Object)lineIndex, (Object)buffer);
            }
            ++current;
        }
        String lineSep = System.getProperty("line.separator");
        if (lineSep != null) {
            int sepIndex = buffer.indexOf("\n");
            while (sepIndex != -1) {
                buffer.replace(sepIndex, sepIndex + 1, lineSep);
                if (sepIndex + lineSep.length() >= buffer.length()) break;
                sepIndex = buffer.indexOf("\n", sepIndex + lineSep.length());
            }
        }
        return buffer.toString();
    }

    public static String removeMarkup(String text) {
        return text.replaceAll("\\<.*?\\>", "");
    }

    public static String getDetectedContentType(String text) {
        String detectedCT = null;
        String trimmedText = text.trim();
        if (trimmedText.startsWith("<")) {
            detectedCT = "text/html";
        } else if (trimmedText.startsWith("{") || trimmedText.startsWith("[")) {
            detectedCT = "text/json";
        } else {
            boolean possibleMD = false;
            if (POSSIBLE_MARKDOWN_SYMBOLS.stream().anyMatch(text::contains)) {
                possibleMD = true;
            } else {
                String[] lines;
                for (String line : lines = text.split("\n")) {
                    if (!POSSIBLE_MARKDOWN_PATTERNS.stream().anyMatch(pattern -> pattern.matcher(line).find())) continue;
                    possibleMD = true;
                    break;
                }
            }
            if (possibleMD) {
                detectedCT = "text/markdown";
            }
        }
        return detectedCT;
    }

    public static String addLineNumbering(String content) {
        BufferedReader br = new BufferedReader(new StringReader(content));
        int lineCounter = 0;
        String line = null;
        StringBuilder contentWithLines = new StringBuilder();
        try {
            while ((line = br.readLine()) != null) {
                contentWithLines.append(++lineCounter).append(":").append(line).append("\n");
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return content;
        }
        return contentWithLines.toString();
    }

    public static String getContentAroundCaretInternal(Document document, int offset, int maxNumberOfChars, boolean includeCaret) throws BadLocationException {
        int caretPositionInContent;
        int documentSize = document.getLength();
        int halfWindow = maxNumberOfChars / 2;
        int startOffset = documentSize <= maxNumberOfChars ? 0 : (offset <= halfWindow ? 0 : (offset + halfWindow >= documentSize ? documentSize - maxNumberOfChars : offset - halfWindow));
        int length = Math.min(maxNumberOfChars, documentSize - startOffset);
        String content = document.getText(startOffset, length);
        if (includeCaret && (caretPositionInContent = offset - startOffset) >= 0 && caretPositionInContent <= content.length()) {
            content = new StringBuilder(content).insert(caretPositionInContent, "[CARET]").toString();
        }
        return content;
    }

    public static String trimMatchingPrefix(String suggestion, String currentLineText) {
        if (suggestion != null && currentLineText != null && !currentLineText.isBlank()) {
            String trimmedSuggestion = suggestion.trim();
            String trimmedCurrentLine = currentLineText.trim();
            for (int i = 0; i < trimmedCurrentLine.length(); ++i) {
                String suffix = trimmedCurrentLine.substring(i);
                if (!trimmedSuggestion.startsWith(suffix)) continue;
                String result = trimmedSuggestion.substring(suffix.length());
                return result;
            }
        }
        return suggestion;
    }

    static {
        THINKING_TAG_MAPPINGS.put("<think>", "</think>");
        THINKING_TAG_MAPPINGS.put("<thinking>", "</thinking>");
    }
}

