/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import com.oxygenxml.positron.core.util.OutlineComponentsUtil;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlineNamespacesUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)OutlineNamespacesUtil.class.getName());

    private static List<?> getAllNamespacesInfo() {
        List namespaceList = null;
        if (OutlineComponentsUtil.checkGetComponentsProviderAvailable()) {
            Object componentsProvider = OutlineComponentsUtil.getComponentsProvider();
            URL locationUrl = OutlineComponentsUtil.getCurrentDocumentLocationURL();
            try {
                Method getAllNamespaces = componentsProvider.getClass().getMethod("getAllNamespaces", URL.class);
                Object allComponentsInfo = getAllNamespaces.invoke(componentsProvider, locationUrl);
                if (allComponentsInfo instanceof List) {
                    namespaceList = (List)allComponentsInfo;
                }
            }
            catch (NoClassDefFoundError | NoSuchMethodException e) {
                logger.debug(e);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return namespaceList;
    }

    public static String buildNamespaceOutline() {
        List<?> allNamespacesInfo = OutlineNamespacesUtil.getAllNamespacesInfo();
        if (allNamespacesInfo != null) {
            return allNamespacesInfo.stream().map(componentInfo -> {
                try {
                    return OutlineNamespacesUtil.createStringComponent(componentInfo);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).filter(Objects::nonNull).collect(Collectors.joining("\n"));
        }
        return "";
    }

    private static String createStringComponent(Object namespaceInfo) throws Exception {
        Method getName;
        Object nameValue;
        StringBuilder outlineComponentBuilder = new StringBuilder();
        Class<?> iNamespaceInfo = Class.forName("ro.sync.exml.workspace.api.componentscollector.INamespaceInfo");
        if (iNamespaceInfo.isInstance(namespaceInfo) && (nameValue = (getName = iNamespaceInfo.getDeclaredMethod("getPrefix", new Class[0])).invoke(namespaceInfo, new Object[0])) != null) {
            outlineComponentBuilder.append(nameValue).append("=");
            Method getType = iNamespaceInfo.getDeclaredMethod("getURI", new Class[0]);
            Object typeValue = getType.invoke(namespaceInfo, new Object[0]);
            if (typeValue != null) {
                outlineComponentBuilder.append(typeValue).append(" ");
            }
        }
        return outlineComponentBuilder.toString();
    }
}

