/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import com.oxygenxml.positron.utilities.functions.IComponent;
import com.oxygenxml.positron.utilities.functions.IXSLComponent;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.page.text.xml.WSXMLTextEditorPage;

public class OutlineComponentsUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)OutlineComponentsUtil.class.getName());

    public static boolean checkGetComponentsProviderAvailable() {
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        try {
            Method getComponentsProvider = pluginWorkspace.getClass().getDeclaredMethod("getComponentsProvider", new Class[0]);
            if (getComponentsProvider != null) {
                return true;
            }
        }
        catch (Exception e) {
            logger.debug((Throwable)e);
        }
        return false;
    }

    static Object getComponentsProvider() {
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        Object componentsProvider = null;
        if (pluginWorkspace != null) {
            try {
                Method getComponentsProvider;
                WSEditor editor = pluginWorkspace.getCurrentEditorAccess(0);
                if (editor != null && (getComponentsProvider = pluginWorkspace.getClass().getDeclaredMethod("getComponentsProvider", new Class[0])) != null) {
                    componentsProvider = getComponentsProvider.invoke((Object)pluginWorkspace, new Object[0]);
                }
            }
            catch (NoClassDefFoundError | NoSuchMethodException e) {
                logger.debug(e);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return componentsProvider;
    }

    static URL getCurrentDocumentLocationURL() {
        WSEditor editor;
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        URL locationUrl = null;
        if (pluginWorkspace != null && (editor = pluginWorkspace.getCurrentEditorAccess(0)) != null) {
            locationUrl = editor.getEditorLocation();
        }
        return locationUrl;
    }

    private static List<?> getAllComponentsInfo() {
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        List componentList = null;
        if (pluginWorkspace != null) {
            try {
                WSEditor editor = pluginWorkspace.getCurrentEditorAccess(0);
                if (editor != null) {
                    URL locationUrl = editor.getEditorLocation();
                    Method getComponentsProvider = pluginWorkspace.getClass().getDeclaredMethod("getComponentsProvider", new Class[0]);
                    if (getComponentsProvider != null) {
                        Object componentsProvider = getComponentsProvider.invoke((Object)pluginWorkspace, new Object[0]);
                        Method getAllComponents = componentsProvider.getClass().getMethod("getAllComponents", URL.class);
                        Object allComponentsInfo = getAllComponents.invoke(componentsProvider, locationUrl);
                        if (allComponentsInfo instanceof List) {
                            componentList = (List)allComponentsInfo;
                        }
                    }
                }
            }
            catch (NoClassDefFoundError | NoSuchMethodException e) {
                logger.debug(e);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return componentList;
    }

    public static String buildComponentOutline() {
        List<?> allComponentsInfo = OutlineComponentsUtil.getAllComponentsInfo();
        if (allComponentsInfo != null) {
            return allComponentsInfo.stream().map(componentInfo -> OutlineComponentsUtil.createStringComponent(componentInfo)).filter(Objects::nonNull).collect(Collectors.joining("\n"));
        }
        return "";
    }

    private static String createStringComponent(Object componentInfo) {
        try {
            StringBuilder outlineComponentBuilder = new StringBuilder();
            Class<?> iComponentInfo = Class.forName("ro.sync.exml.workspace.api.componentscollector.IComponentInfo");
            Class<?> ixslComponentInfo = Class.forName("ro.sync.exml.workspace.api.componentscollector.IXSLComponentInfo");
            if (iComponentInfo.isInstance(componentInfo)) {
                Method getName = iComponentInfo.getDeclaredMethod("getName", new Class[0]);
                Object nameValue = getName.invoke(componentInfo, new Object[0]);
                outlineComponentBuilder.append("Name:").append(nameValue != null ? nameValue : "null").append(" ");
                Method getType = iComponentInfo.getDeclaredMethod("getType", new Class[0]);
                Object typeValue = getType.invoke(componentInfo, new Object[0]);
                outlineComponentBuilder.append("Type:").append(typeValue != null ? typeValue : "null").append(" ");
                if (ixslComponentInfo.isInstance(componentInfo)) {
                    Method getMatch = ixslComponentInfo.getDeclaredMethod("getMatch", new Class[0]);
                    Object matchValue = getMatch.invoke(componentInfo, new Object[0]);
                    outlineComponentBuilder.append("Match:").append(matchValue != null ? matchValue : "null").append(" ");
                    Method getMode = ixslComponentInfo.getDeclaredMethod("getMode", new Class[0]);
                    Object modeValue = getMode.invoke(componentInfo, new Object[0]);
                    outlineComponentBuilder.append("Mode:").append(modeValue != null ? modeValue : "null").append(" ");
                }
                Method getAnnontation = iComponentInfo.getDeclaredMethod("getAnnotation", new Class[0]);
                String annotationValue = (String)getAnnontation.invoke(componentInfo, new Object[0]);
                outlineComponentBuilder.append("Annotation:").append(annotationValue != null ? annotationValue.substring(0, Math.min(200, annotationValue.length())) : "null").append(" ");
            }
            return outlineComponentBuilder.toString();
        }
        catch (Exception e) {
            logger.debug((Throwable)e);
            return null;
        }
    }

    public static String findComponent(IComponent componentToFind) {
        List<?> allComponentsInfo = OutlineComponentsUtil.getAllComponentsInfo();
        if (allComponentsInfo != null) {
            return allComponentsInfo.stream().map(componentInfo -> OutlineComponentsUtil.matchComponent(componentInfo, componentToFind)).filter(Objects::nonNull).collect(Collectors.joining("\n"));
        }
        return "";
    }

    private static String matchComponent(Object componentInfo, IComponent component) {
        block5: {
            try {
                Class<?> iComponentInfo = Class.forName("ro.sync.exml.workspace.api.componentscollector.IComponentInfo");
                Class<?> ixslComponentInfo = Class.forName("ro.sync.exml.workspace.api.componentscollector.IXSLComponentInfo");
                if (!iComponentInfo.isInstance(componentInfo)) break block5;
                Method getType = iComponentInfo.getDeclaredMethod("getType", new Class[0]);
                Method getName = iComponentInfo.getDeclaredMethod("getName", new Class[0]);
                if (component.getType() != null && !component.getType().equals(getType.invoke(componentInfo, new Object[0])) || component.getName() != null && !component.getName().equals(getName.invoke(componentInfo, new Object[0]))) break block5;
                if (ixslComponentInfo.isInstance(componentInfo)) {
                    IXSLComponent ixslComponent = (IXSLComponent)component;
                    Method getMatch = ixslComponentInfo.getDeclaredMethod("getMatch", new Class[0]);
                    Method getMode = ixslComponentInfo.getDeclaredMethod("getMode", new Class[0]);
                    if ((ixslComponent.getMatch() == null || ixslComponent.getMatch().equals(getMatch.invoke(componentInfo, new Object[0]))) && (ixslComponent.getMode() == null || ixslComponent.getMode().equals(getMode.invoke(componentInfo, new Object[0])))) {
                        return OutlineComponentsUtil.getTextForComponent(componentInfo, iComponentInfo);
                    }
                    break block5;
                }
                return OutlineComponentsUtil.getTextForComponent(componentInfo, iComponentInfo);
            }
            catch (ClassNotFoundException e) {
                logger.debug((Throwable)e);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return null;
    }

    private static String getTextForComponent(Object componentInfo, Class<?> iComponentInfo) {
        try {
            Method getStartOffset = iComponentInfo.getDeclaredMethod("getStartOffset", new Class[0]);
            Method getEndOffset = iComponentInfo.getDeclaredMethod("getEndOffset", new Class[0]);
            Method getSystemId = iComponentInfo.getDeclaredMethod("getSystemId", new Class[0]);
            PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
            WSEditor editor = pluginWorkspace.getCurrentEditorAccess(0);
            if (editor != null && editor.getCurrentPage() instanceof WSXMLTextEditorPage && editor.getEditorLocation().toString().equals((String)getSystemId.invoke(componentInfo, new Object[0]))) {
                int startOffset = (Integer)getStartOffset.invoke(componentInfo, new Object[0]);
                int endOffset = (Integer)getEndOffset.invoke(componentInfo, new Object[0]);
                if (startOffset > 0 && endOffset > 0 || startOffset != endOffset) {
                    return ((JTextArea)((WSXMLTextEditorPage)editor.getCurrentPage()).getTextComponent()).getText(startOffset, endOffset - startOffset);
                }
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.debug((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return null;
    }
}

