/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.aiignore.OperationCancelledByAiIgnoreException;
import com.oxygenxml.positron.core.interactions.AuthorContextInfo;
import com.oxygenxml.positron.core.interactions.ContextInfo;
import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.AuthorDocumentModel;
import com.oxygenxml.positron.core.util.AuthorDocumentModelCreator;
import com.oxygenxml.positron.core.util.HrefInfoResolver;
import com.oxygenxml.positron.core.util.attach.ImageAttachmentsFilter;
import com.oxygenxml.positron.core.util.attach.InvalidAttachmentException;
import com.oxygenxml.positron.utilities.exceptions.AccessDeniedException;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelper;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.ActionType;
import com.oxygenxml.positron.utilities.json.AdditionalInfo;
import com.oxygenxml.positron.utilities.json.InputContext;
import com.oxygenxml.positron.utilities.json.InputType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.IOUtil;
import ro.sync.ecss.dita.HrefInfo;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class ContextExtractorUtil {
    private static final Logger log = LoggerFactory.getLogger(ContextExtractorUtil.class);
    private static final String ATTACHMENT_VAR_TEMPLATE = "${attach(%s)}";
    private static final Translator I18N = Translator.getInstance();

    private ContextExtractorUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static ContextInfo computeContext(AIActionDetails details, DocumentContentInteractor prefixExtractor, ImageAttachmentsFilter attachmentsFilter, AuthorDocumentModelCreator authorDocumentControllerCreator, HrefInfoResolver hrefInfoResolver) throws CannotComputeCompletionDetailsException, BadLocationException, OperationCancelledByAiIgnoreException {
        ContextInfo contextInfo = null;
        if (prefixExtractor != null) {
            contextInfo = ContextExtractorUtil.getTextToProcessInternal(details, prefixExtractor, attachmentsFilter, authorDocumentControllerCreator, hrefInfoResolver);
            ContextExtractorUtil.handleActionsThatRequireSelection(details, contextInfo);
        } else if (ActionType.SHOW_RESPONSE == details.getComputedType() && details.getInputType() == null) {
            contextInfo = ContextInfo.EMPTY_CONTEXT_INFO;
        } else {
            throw new CannotComputeCompletionDetailsException("Action only available when a document is open. Please open a document to use this feature.");
        }
        return contextInfo;
    }

    private static void handleActionsThatRequireSelection(AIActionDetails details, ContextInfo contextInfo) throws CannotComputeCompletionDetailsException {
        boolean isActionThatRequiresSelection = ContextExtractorUtil.isActionThatRequiresSelection(details);
        if (contextInfo.isEmpty() && isActionThatRequiresSelection) {
            throw new CannotComputeCompletionDetailsException("There is no selection in the editor. Please select text before invoking the action.");
        }
    }

    private static boolean isActionThatRequiresSelection(AIActionDetails details) {
        String actionId = details.getId();
        return (actionId == null || !actionId.startsWith("pseudoaction.chat.message.")) && !"pseudoaction.copilot.rewrite.content.based.on.instructions".equals(actionId) && !"pseudoaction.ai.autocompletion.xslt".equals(actionId) && details.getComputedType() != ActionType.INSERT_SCHEMA_AWARE && details.getInputContext() != InputContext.NONE;
    }

    private static ContextInfo getTextToProcessInternal(AIActionDetails details, DocumentContentInteractor prefixExtractor, ImageAttachmentsFilter attachmentsFilter, AuthorDocumentModelCreator authorDocumentControllerCreator, HrefInfoResolver hrefInfoResolver) throws CannotComputeCompletionDetailsException, BadLocationException, OperationCancelledByAiIgnoreException {
        ContextInfo toReturn = null;
        boolean obtainEntireTextIncludingMarkup = details.getInputType() == null || details.getInputType() == InputType.MARKUP;
        ActionType actionType = details.getComputedType();
        if (ActionType.GENERATE_CONTENT_FROM_CONTEXT == actionType) {
            toReturn = prefixExtractor.getCurrentContextInfo(obtainEntireTextIncludingMarkup, details.getInputContext(), true);
            if (toReturn.isEmpty()) {
                try {
                    String usableContent = prefixExtractor.computePromptTextFromCaret(prefixExtractor.getCaretOffset());
                    toReturn = new ContextInfo(usableContent, prefixExtractor.getCaretOffset(), prefixExtractor.getCaretOffset());
                }
                catch (BadLocationException usableContent) {}
            }
        } else if (ActionType.INSERT_SUGGESTION_FOR_LEFT_CONTENT == actionType) {
            try {
                int maxNoOfChars = 6000 - details.getContextLength();
                toReturn = new ContextInfo(prefixExtractor.computeUserInputFromDocument(prefixExtractor.getCaretOffset(), maxNoOfChars), prefixExtractor.getCaretOffset(), prefixExtractor.getCaretOffset());
            }
            catch (BadLocationException e) {
                throw new CannotComputeCompletionDetailsException(e.getMessage(), e);
            }
        } else if (ActionType.REPLACE_SELECTION_BASED_ON_IMAGE_ANALYSIS == actionType) {
            toReturn = ContextExtractorUtil.getSelectedImageContextInfo(prefixExtractor, attachmentsFilter, obtainEntireTextIncludingMarkup, authorDocumentControllerCreator, hrefInfoResolver);
        } else if (ActionType.GENERATE_DOCUMENTATION_DRAFT == actionType) {
            toReturn = prefixExtractor.getEntireDocumentContent(obtainEntireTextIncludingMarkup);
        } else if (ActionType.UPDATE_ENTIRE_DOCUMENT_BASED_ON_IMAGES == actionType) {
            toReturn = ContextExtractorUtil.newContextWithImageAttachmentsAsEditorVariables(prefixExtractor, attachmentsFilter, authorDocumentControllerCreator, hrefInfoResolver);
        } else if (details.getId() != null && details.getId().startsWith("pseudoaction.chat.message.") || "pseudoaction.copilot.rewrite.content.based.on.instructions".equals(details.getId())) {
            toReturn = prefixExtractor.getCurrentContextInfo(obtainEntireTextIncludingMarkup, details.getInputContext(), true);
        } else if (ActionType.SHOW_RESPONSE == actionType || ActionType.INSERT_SCHEMA_AWARE == actionType || ActionType.REPLACE_SELECTION == actionType) {
            toReturn = ContextExtractorUtil.getInputContentFromActionDetails(details, prefixExtractor);
            if (toReturn == null) {
                InputContext inputContext = details.getInputContext();
                if (inputContext == null && ActionType.INSERT_SCHEMA_AWARE == actionType) {
                    inputContext = InputContext.AUTO_SELECTION_DOCUMENT;
                }
                toReturn = prefixExtractor.getCurrentContextInfo(obtainEntireTextIncludingMarkup, inputContext, true);
            }
        } else {
            toReturn = prefixExtractor.getCurrentContextInfo(obtainEntireTextIncludingMarkup, details.getInputContext(), true);
        }
        return toReturn;
    }

    private static ContextInfo getSelectedImageContextInfo(DocumentContentInteractor contentExtractor, ImageAttachmentsFilter attachmentsFilter, boolean obtainEntireTextIncludingMarkup, AuthorDocumentModelCreator authorDocModelCreator, HrefInfoResolver hrefInfoResolver) throws BadLocationException, CannotComputeCompletionDetailsException, OperationCancelledByAiIgnoreException {
        ContextInfo imageInfo = null;
        ContextInfo contextInfo = contentExtractor.getCurrentContextInfo(obtainEntireTextIncludingMarkup, InputContext.SELECTION, true);
        String originalUsableContent = contextInfo.getUsableContent();
        if (originalUsableContent != null && !originalUsableContent.isEmpty()) {
            try {
                AuthorDocumentModel documentModel;
                AuthorNode[] imageNodes;
                List<URL> authorImageRefs = ContextExtractorUtil.getImageReferencesFromAuthorPage(contextInfo, hrefInfoResolver);
                if (authorImageRefs != null && !authorImageRefs.isEmpty()) {
                    imageInfo = ContextExtractorUtil.computeImageContextInfo(contentExtractor, attachmentsFilter, contextInfo, originalUsableContent, authorImageRefs.get(0));
                }
                if (imageInfo == null && (imageNodes = (documentModel = authorDocModelCreator.createDocumentModel(contentExtractor.getEditorLocation(), new StringReader(originalUsableContent))).getDocumentController().findNodesByXPath("//image", true, true, true)).length > 0 && imageNodes[0] instanceof AuthorNode) {
                    URL referenceURL;
                    HrefInfo hrefInformation = hrefInfoResolver.getHrefInformation(imageNodes[0]);
                    URL uRL = referenceURL = hrefInformation != null ? hrefInformation.getReferenceURL() : null;
                    if (referenceURL != null) {
                        imageInfo = ContextExtractorUtil.computeImageContextInfo(contentExtractor, attachmentsFilter, contextInfo, originalUsableContent, referenceURL);
                    }
                }
            }
            catch (InvalidAttachmentException | AuthorOperationException e) {
                throw new CannotComputeCompletionDetailsException(e.getMessage(), (Exception)e);
            }
            catch (IOException e) {
                throw new CannotComputeCompletionDetailsException(I18N.getTranslation("Action_works_only_with_selected_image"), e);
            }
        }
        if (imageInfo == null) {
            throw new CannotComputeCompletionDetailsException(I18N.getTranslation("Action_works_only_with_selected_image"));
        }
        return imageInfo;
    }

    private static ContextInfo computeImageContextInfo(DocumentContentInteractor contentExtractor, ImageAttachmentsFilter attachmentsFilter, ContextInfo contextInfo, String originalUsableContent, URL imageURL) throws InvalidAttachmentException, BadLocationException {
        attachmentsFilter.accept(imageURL);
        String usableContent = contentExtractor.computeUserInputFromDocument(contentExtractor.getCaretOffset(), 500) + originalUsableContent + String.format(ATTACHMENT_VAR_TEMPLATE, attachmentsFilter.cleanSensitiveInfo(imageURL).toExternalForm());
        return new ContextInfo(usableContent, contextInfo.getStartOffset(), contextInfo.getEndOffset());
    }

    private static List<URL> getImageReferencesFromAuthorPage(ContextInfo contextInfo, HrefInfoResolver hrefInfoResolver) throws BadLocationException {
        ArrayList<URL> imageRefs = null;
        if (contextInfo instanceof AuthorContextInfo) {
            imageRefs = new ArrayList<URL>();
            AuthorContextInfo authorInfo = (AuthorContextInfo)contextInfo;
            List<AuthorNode> nodesInSelection = authorInfo.getNodesInSelection();
            if (nodesInSelection != null) {
                ArrayList<AuthorNode> allImages = new ArrayList<AuthorNode>();
                ContextExtractorUtil.gatherAllImages(nodesInSelection, allImages);
                for (AuthorNode authorNode : allImages) {
                    HrefInfo hrefInformation = hrefInfoResolver.getHrefInformation(authorNode);
                    URL referenceURL = hrefInformation != null ? hrefInformation.getReferenceURL() : null;
                    if (referenceURL == null) continue;
                    imageRefs.add(referenceURL);
                }
            }
        }
        return imageRefs;
    }

    private static void gatherAllImages(List<AuthorNode> nodes, List<AuthorNode> allImages) {
        if (nodes != null) {
            for (AuthorNode authorNode : nodes) {
                if (authorNode instanceof AuthorParentNode) {
                    ContextExtractorUtil.gatherAllImages(((AuthorParentNode)authorNode).getContentNodes(), allImages);
                }
                if (!(authorNode instanceof AuthorElement) || !"image".equals(((AuthorElement)authorNode).getLocalName())) continue;
                allImages.add(authorNode);
            }
        }
    }

    private static ContextInfo getInputContentFromActionDetails(AIActionDetails details, DocumentContentInteractor prefixExtractor) throws BadLocationException, OperationCancelledByAiIgnoreException {
        String inputContentTypes;
        ContextInfo toReturn = null;
        AdditionalInfo additionalInfo = details.getAdditionalInfo();
        if (additionalInfo != null && (inputContentTypes = (String)additionalInfo.getProperties().get("input_content")) != null && !inputContentTypes.isEmpty()) {
            String[] inputTypes = inputContentTypes.split(",");
            boolean includeMarkup = details.getInputType() == null || details.getInputType() == InputType.MARKUP;
            for (String inputType : inputTypes) {
                toReturn = ContextExtractorUtil.getInputContentFromInputType(prefixExtractor, includeMarkup, inputType);
                if (toReturn == null) continue;
                return toReturn;
            }
        }
        return toReturn;
    }

    private static ContextInfo getInputContentFromInputType(DocumentContentInteractor prefixExtractor, boolean obtainEntireTextIncludingMarkup, String inputType) throws BadLocationException, OperationCancelledByAiIgnoreException {
        ContextInfo toReturn = null;
        if ("selection".equals(inputType.strip())) {
            if (prefixExtractor.hasSelection()) {
                toReturn = prefixExtractor.getCurrentContextInfo(obtainEntireTextIncludingMarkup, InputContext.SELECTION, true);
            }
        } else if ("node".equals(inputType.strip())) {
            toReturn = prefixExtractor.getCurrentNodeContent(obtainEntireTextIncludingMarkup);
        } else if ("document".equals(inputType.strip())) {
            toReturn = prefixExtractor.getEntireDocumentContent(obtainEntireTextIncludingMarkup);
        } else {
            log.error("Unknown input type: '{}' ", (Object)inputType);
        }
        return toReturn;
    }

    private static ContextInfo newContextWithImageAttachmentsAsEditorVariables(DocumentContentInteractor contentExtractor, ImageAttachmentsFilter attachmentsFilter, AuthorDocumentModelCreator authorDocumentModelCreator, HrefInfoResolver hrefInfoResolver) throws BadLocationException, OperationCancelledByAiIgnoreException {
        ContextInfo contextInfo;
        block5: {
            contextInfo = contentExtractor.getEntireDocumentContent(true);
            String usableContent = contextInfo.getUsableContent();
            if (usableContent != null && !usableContent.isEmpty()) {
                List<URL> imageRefURLs = ContextExtractorUtil.getImageReferencesFromAuthorPage(contextInfo, hrefInfoResolver);
                try {
                    AuthorDocumentModel documentModel = authorDocumentModelCreator.createDocumentModel(contentExtractor.getEditorLocation(), new StringReader(usableContent));
                    AuthorDocumentController ctrl = documentModel.getDocumentController();
                    AuthorNode[] images = ctrl.findNodesByXPath("//image", true, true, false);
                    for (int i = 0; i < images.length; ++i) {
                        URL referenceURL;
                        AuthorNode imageNode = images[i];
                        if (!(imageNode instanceof AuthorElement)) continue;
                        AuthorElement imgElement = (AuthorElement)imageNode;
                        HrefInfo hrefInformation = hrefInfoResolver.getHrefInformation((AuthorNode)imgElement);
                        URL uRL = referenceURL = hrefInformation != null ? hrefInformation.getReferenceURL() : null;
                        if (referenceURL == null && imageRefURLs != null && i < imageRefURLs.size()) {
                            referenceURL = imageRefURLs.get(i);
                        }
                        if (referenceURL == null) continue;
                        attachmentsFilter.accept(referenceURL);
                        ctrl.insertXMLFragment(String.format(ATTACHMENT_VAR_TEMPLATE, attachmentsFilter.cleanSensitiveInfo(referenceURL).toExternalForm()), imgElement.getEndOffset() + 1);
                    }
                    String updatedContent = IOUtil.read((Reader)documentModel.getContentReader()).toString();
                    contextInfo = new ContextInfo(updatedContent, contextInfo.getStartOffset(), contextInfo.getEndOffset());
                }
                catch (InvalidAttachmentException | IOException | AuthorOperationException e) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug((Object)e, e);
                }
            }
        }
        return contextInfo;
    }

    public static String getContentOrAccessDeniedMessage(String editorLocation, Supplier<String> contentSupplier, boolean isCurrentEditedDocument) {
        return ContextExtractorUtil.getContentOrAccessDeniedMessage(editorLocation, contentSupplier, isCurrentEditedDocument, FunctionsAndRAGHelperProvider.getProjectRAGHelper());
    }

    public static String getContentOrAccessDeniedMessage(String editorLocation, Supplier<String> contentSupplier, boolean isCurrentEditedDocument, FunctionsAndRAGHelper projectHelper) {
        String toRet = null;
        try {
            if (editorLocation != null) {
                projectHelper.checkDocumentAccessPermissions(editorLocation, isCurrentEditedDocument, false);
            }
            toRet = contentSupplier.get();
        }
        catch (AccessDeniedException e) {
            toRet = e.getMessage();
        }
        return toRet;
    }

    public static String readDocumentContent(URL docURL) throws IOException {
        Reader reader;
        PluginWorkspace pw = PluginWorkspaceProvider.getPluginWorkspace();
        if (pw != null && pw.getUtilAccess() != null && (reader = pw.getUtilAccess().createReader(docURL, StandardCharsets.UTF_8.name())) != null) {
            return IOUtil.read((Reader)reader).toString();
        }
        return IOUtil.readURL((URL)docURL, (String)"UTF-8");
    }
}

