/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import com.oxygenxml.positron.api.connector.dto.ModelDescriptor;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.utilities.AIProviderConstants;
import com.oxygenxml.positron.utilities.credits.CreditsConverterUtil;
import com.oxygenxml.positron.utilities.models.ModelDTO;
import com.oxygenxml.positron.utilities.models.ModelLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public final class AIModelsUtil {
    private static final Translator TRANSLATOR = Translator.getInstance();

    private AIModelsUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String getUILabelForModelID(String modelID) {
        return ModelLoader.getInstance().getModelNameToUI(modelID);
    }

    public static String getUILabelForModelSnapshotID(String snapshotModel) {
        return AIModelsUtil.getUILabelForModelID(AIModelsUtil.getModelShortName(snapshotModel));
    }

    public static String getAIModelFromOptions(String optionTag) {
        String currentModel;
        WSOptionsStorage options = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        String returnedModel = currentModel = options.getOption(optionTag, null);
        boolean isSupportedModel = AIModelsUtil.getAllSupportedModelsForUI().stream().filter(t -> t.equalsIgnoreCase(currentModel)).findAny().isPresent();
        if (!isSupportedModel) {
            returnedModel = AIModelsUtil.getModelShortName(currentModel);
        }
        return returnedModel;
    }

    private static String getModelShortName(String currentModel) {
        String returnedModel = null;
        ModelLoader modelLoader = ModelLoader.getInstance();
        if (!TextUtils.isNullOrBlank(currentModel)) {
            ModelDTO modelDTOWithoutSnapshot = modelLoader.getBestMatchingModelDTO(currentModel);
            returnedModel = modelDTOWithoutSnapshot == null ? currentModel : modelDTOWithoutSnapshot.getModelID();
        }
        return returnedModel;
    }

    public static Map<String, List<ModelDescriptor>> getGroupedModelsForUI() {
        LinkedHashMap<String, List<ModelDescriptor>> groupedModels = new LinkedHashMap<String, List<ModelDescriptor>>();
        groupedModels.put("<Default>", Arrays.asList(AIModelsUtil.getDefaultOpenAIModelDescriptor(true)));
        ModelLoader loader = ModelLoader.getInstance();
        List loadedModels = loader.getLoadedModels();
        for (ModelDTO modelDTO : loadedModels) {
            if (!modelDTO.getShouldBeShownInUI().booleanValue() || modelDTO.getIsEnterpriseOnly() != null && modelDTO.getIsEnterpriseOnly().booleanValue()) continue;
            String modelId = modelDTO.getModelID();
            String label = AIModelsUtil.getUILabelForModelID(modelId);
            String description = AIModelsUtil.getModelExplanation(modelId, true);
            groupedModels.computeIfAbsent(ModelLoader.getLabelForServiceId((String)modelDTO.getAiServiceID()), k -> new ArrayList()).add(new ModelDescriptor(modelId, label, description, modelDTO.getMaxTotalTokens(), modelDTO.getMaxOutputTokens(), modelDTO.isReasoningModel()));
        }
        return groupedModels;
    }

    private static List<String> getAllSupportedModelsForUI() {
        ModelLoader loader = ModelLoader.getInstance();
        ArrayList<String> supportedOptionsModels = new ArrayList<String>();
        List loadedModels = loader.getLoadedModels();
        List collectedModels = loadedModels.stream().filter(ModelDTO::getShouldBeShownInUI).map(ModelDTO::getModelID).collect(Collectors.toList());
        supportedOptionsModels.addAll(collectedModels);
        return supportedOptionsModels;
    }

    public static List<ModelDescriptor> getSupportedOpenAIConnectorModelsForUI() {
        ArrayList<ModelDescriptor> supportedOptionsModels = new ArrayList<ModelDescriptor>();
        supportedOptionsModels.add(AIModelsUtil.getDefaultOpenAIModelDescriptor(false));
        List loadedModels = ModelLoader.getInstance().getLoadedModels();
        List collectedModels = loadedModels.stream().filter(ModelDTO::getShouldBeShownInUI).filter(m -> "openai".equals(m.getAiServiceID())).map(m -> new ModelDescriptor(m.getModelID(), AIModelsUtil.getUILabelForModelID(m.getModelID()), AIModelsUtil.getModelExplanation(m.getModelID(), false), m.getMaxTotalTokens(), m.getMaxOutputTokens(), m.isReasoningModel())).collect(Collectors.toList());
        supportedOptionsModels.addAll(collectedModels);
        return supportedOptionsModels;
    }

    private static ModelDescriptor getDefaultOpenAIModelDescriptor(boolean includeCreditsInfo) {
        ModelDTO defaultModelDTO = ModelLoader.getInstance().getModelDTOById("gpt-4.1");
        boolean isReasoning = defaultModelDTO != null && defaultModelDTO.isReasoningModel();
        Integer contextWindow = defaultModelDTO != null ? defaultModelDTO.getMaxTotalTokens() : null;
        Integer maxOutputTokens = defaultModelDTO != null ? defaultModelDTO.getMaxOutputTokens() : null;
        return new ModelDescriptor(AIProviderConstants.DEFAULT_ENGINE.getId(), AIModelsUtil.getUILabelForModelID("gpt-4.1") + " (" + Translator.getInstance().getTranslation("default") + ")", AIModelsUtil.getModelExplanation("gpt-4.1", includeCreditsInfo) + "\n\n" + AIModelsUtil.getDefaultEngineExtraExplanation(), contextWindow, maxOutputTokens, isReasoning);
    }

    public static List<ModelDescriptor> getSupportedNonOpenAIConnectorModelsForUI(String aiProvider) {
        List loadedModels = ModelLoader.getInstance().getLoadedModels();
        List collectedModels = loadedModels.stream().filter(ModelDTO::getShouldBeShownInUI).filter(m -> aiProvider.equals(m.getAiServiceID())).map(m -> new ModelDescriptor(m.getModelID(), AIModelsUtil.getUILabelForModelID(m.getModelID()), AIModelsUtil.getModelExplanation(m.getModelID(), false), m.getMaxTotalTokens(), m.getMaxOutputTokens(), m.isReasoningModel())).collect(Collectors.toList());
        return new ArrayList<ModelDescriptor>(collectedModels);
    }

    private static Optional<String> getEngineExplanation(String modelToSearch, boolean includeCredits) {
        ModelLoader loader = ModelLoader.getInstance();
        Optional<Object> result = Optional.empty();
        ModelDTO model = loader.getModelDTOById(modelToSearch);
        if (model != null) {
            String baseDescription = TRANSLATOR.getTranslation(model.getModelDescription());
            String creditsInfo = includeCredits ? " " + AIModelsUtil.getCreditsInfo(model) : "";
            result = Optional.of(baseDescription + creditsInfo);
        }
        return result;
    }

    private static String getCreditsInfo(ModelDTO model) {
        String creditsTag = model.isReasoningModel() ? "Model_Credits_With_Reasoning" : "Model_Credits_Standard";
        return MessageFormat.format(TRANSLATOR.getTranslation(creditsTag), Float.valueOf(CreditsConverterUtil.getApproximateCreditsPerWord((float)model.getInputWeight())), Float.valueOf(CreditsConverterUtil.getApproximateCreditsPerWord((float)model.getOutputWeight())));
    }

    public static String getDefaultEngineExtraExplanation() {
        return MessageFormat.format(TRANSLATOR.getTranslation("Default_Model_Additional_Explanation"), AIProviderConstants.DEFAULT_ENGINE.getId());
    }

    @NonNull
    public static String getModelExplanation(String model, boolean includeCredits) {
        return AIModelsUtil.getEngineExplanation(model, includeCredits).orElse(TRANSLATOR.getTranslation("Default_model_explanation"));
    }
}

