/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools.project;

import com.oxygenxml.positron.core.plugin.Translator;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.util.UtilAccess;

public class ProjectHelperSandbox {
    private static final Logger logger = LoggerFactory.getLogger((String)ProjectHelperSandbox.class.getName());

    public static boolean accept(String resourceURL) {
        String[] locations;
        PluginWorkspace pw = PluginWorkspaceProvider.getPluginWorkspace();
        WSOptionsStorage optionsStorage = pw.getOptionsStorage();
        UtilAccess utilAccess = pw.getUtilAccess();
        if (optionsStorage == null || utilAccess == null) {
            return true;
        }
        boolean accept = false;
        String enableRAGFunctionsOptionVal = optionsStorage.getOption("oxygen.positron.plugin.enable.rag", String.valueOf(true));
        boolean areRAGFunctionsEnabled = Boolean.parseBoolean(enableRAGFunctionsOptionVal);
        String enableLimitReadWriteAccessOptionVal = optionsStorage.getOption("oxygen.positron.plugin.enable.sandbox.rag", String.valueOf(true));
        boolean isLimitReadWriteAccessEnabled = Boolean.parseBoolean(enableLimitReadWriteAccessOptionVal);
        String readWriteLocations = optionsStorage.getOption("oxygen.positron.plugin.retrieval.sandbox.rag", "${pdu}, ${rootMapDirURL}");
        try {
            resourceURL = URLUtil.getCanonicalURL((URL)new URL(resourceURL)).toString();
        }
        catch (MalformedURLException e) {
            try {
                resourceURL = URLUtil.getCanonicalURL((URL)URLUtil.correct((File)new File(resourceURL))).toString();
            }
            catch (MalformedURLException e1) {
                logger.debug((Throwable)e1);
            }
        }
        if (readWriteLocations == null || readWriteLocations.isEmpty() || areRAGFunctionsEnabled && !isLimitReadWriteAccessEnabled) {
            accept = true;
        } else if (areRAGFunctionsEnabled && (locations = readWriteLocations.split(",")) != null) {
            for (int i = 0; i < locations.length; ++i) {
                String expandedPart = utilAccess.expandEditorVariables(locations[i].trim(), null);
                if (expandedPart == null || expandedPart.isEmpty() || !resourceURL.contains(expandedPart)) continue;
                accept = true;
                break;
            }
        }
        return accept;
    }

    public static String getAccessDeniedMessage(String url) {
        Translator translator = Translator.getInstance();
        return translator.getTranslation("access_denied") + ": '" + URLUtil.clearUserInfo((String)url) + "'. " + translator.getTranslation("Sandbox_access_denied_info");
    }
}

