/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.oxygenxml.positron.core.tools.internal.TreeAccessProvider;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.dita.HrefInfo;
import ro.sync.ecss.extensions.api.node.AuthorNode;

class StructureNode {
    private String name;
    private URL url;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<StructureNode> children;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private boolean current = false;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private int notExpandedChildren = 0;
    @JsonIgnore
    private final AuthorNode node;

    public StructureNode(AuthorNode node, Object tree) {
        this.name = TreeAccessProvider.getTreeAccess().getTextForNode(node, tree);
        this.children = new ArrayList<StructureNode>();
        this.node = node;
        HrefInfo hrefInfo = DITAAccess.getHrefInformation((AuthorNode)node);
        if (hrefInfo != null) {
            this.url = hrefInfo.getReferenceURL();
        } else if (node.getParent() != null && node.getParent().getType() == 2) {
            this.url = node.getXMLBaseURL();
        }
        if (this.url != null) {
            this.url = URLUtil.clearUserInfo((URL)this.url);
        }
    }

    public void addChild(StructureNode child) {
        this.children.add(child);
    }

    public void setCurrent(boolean current) {
        this.current = current;
    }

    public void setNonExpandedChildren(int notExpandedChildren) {
        this.notExpandedChildren = notExpandedChildren;
    }

    public String toString() {
        return "StructureNode(name=" + this.getName() + ", url=" + this.getUrl() + ", children=" + this.getChildren() + ", current=" + this.isCurrent() + ", notExpandedChildren=" + this.getNotExpandedChildren() + ", node=" + this.getNode() + ")";
    }

    public String getName() {
        return this.name;
    }

    public URL getUrl() {
        return this.url;
    }

    public List<StructureNode> getChildren() {
        return this.children;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public int getNotExpandedChildren() {
        return this.notExpandedChildren;
    }

    public AuthorNode getNode() {
        return this.node;
    }
}

