/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools.internal;

import com.oxygenxml.positron.core.tools.internal.IProblemFilter;
import java.net.URL;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.document.DocumentPositionedInfo;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.page.WSEditorPage;
import ro.sync.exml.workspace.api.editor.page.WSTextBasedEditorPage;

public class RangeProblemFilter
implements IProblemFilter {
    private static final Logger log = LoggerFactory.getLogger(RangeProblemFilter.class);
    private int startOffset;
    private int endOffset;
    private URL docUrl;

    public RangeProblemFilter(URL docUrl, int startOffset, int endOffset) {
        this.docUrl = docUrl;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @Override
    public boolean isInclude(DocumentPositionedInfo dpi) {
        int dpiOffset = dpi.getOffset();
        if (dpiOffset == -1) {
            dpiOffset = this.determineDPIOffsetFromEditorPage(dpi);
        }
        return dpiOffset == -1 ? false : dpiOffset >= this.startOffset && dpiOffset <= this.endOffset;
    }

    protected int determineDPIOffsetFromEditorPage(DocumentPositionedInfo dpi) {
        int dpiOffset = -1;
        WSEditorPage currentPage = this.getCurrentEditorPage();
        if (currentPage instanceof WSTextBasedEditorPage) {
            try {
                int[] startEndOffsets = ((WSTextBasedEditorPage)currentPage).getStartEndOffsets(dpi);
                if (startEndOffsets != null) {
                    dpiOffset = startEndOffsets[0];
                }
            }
            catch (BadLocationException e) {
                log.debug((Object)e, (Throwable)e);
            }
        }
        return dpiOffset;
    }

    protected WSEditorPage getCurrentEditorPage() {
        WSEditor editor;
        WSEditorPage currentPage = null;
        PluginWorkspace workspace = PluginWorkspaceProvider.getPluginWorkspace();
        if (workspace != null && (editor = workspace.getEditorAccess(this.docUrl, 0)) != null) {
            currentPage = editor.getCurrentPage();
        }
        return currentPage;
    }
}

